/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.webservices.api.message;

import com.oracle.webservices.api.message.AccessorFactory;
import com.oracle.webservices.api.message.PropertySet;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class BasePropertySet
implements PropertySet {
    private Map<String, Object> mapView;

    protected BasePropertySet() {
    }

    protected abstract PropertyMap getPropertyMap();

    protected static PropertyMap parse(Class<?> clazz) {
        return BasePropertySet.parse(clazz, MethodHandles.lookup());
    }

    protected static PropertyMap parse(Class<?> clazz, MethodHandles.Lookup caller) {
        Class<?> cl = Objects.requireNonNull(clazz, "clazz must not be null");
        MethodHandles.Lookup lookup = Objects.requireNonNull(caller, "caller must not be null");
        try {
            return AccessController.doPrivileged(() -> {
                PropertyMap props = new PropertyMap();
                for (Class c = cl; c != Object.class; c = c.getSuperclass()) {
                    PropertySet.Property cp;
                    MethodHandles.Lookup privateLookup = AccessorFactory.createPrivateLookup(c, lookup);
                    for (Field field : c.getDeclaredFields()) {
                        cp = field.getAnnotation(PropertySet.Property.class);
                        if (cp == null) continue;
                        for (String value : cp.value()) {
                            props.put(value, AccessorFactory.createAccessor(field, value, privateLookup));
                        }
                    }
                    for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                        Method setter;
                        cp = ((Method)accessibleObject).getAnnotation(PropertySet.Property.class);
                        if (cp == null) continue;
                        String name = ((Method)accessibleObject).getName();
                        assert (name.startsWith("get") || name.startsWith("is"));
                        String setName = name.startsWith("is") ? "set" + name.substring(2) : "s" + name.substring(1);
                        try {
                            setter = cl.getMethod(setName, ((Method)accessibleObject).getReturnType());
                        }
                        catch (NoSuchMethodException e) {
                            setter = null;
                        }
                        for (String value : cp.value()) {
                            props.put(value, AccessorFactory.createAccessor((Method)accessibleObject, setter, value, privateLookup));
                        }
                    }
                }
                return props;
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable t = ex.getCause();
            throw new RuntimeException(t);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Accessor sp = (Accessor)this.getPropertyMap().get(key);
        if (sp != null) {
            return sp.get(this) != null;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Accessor sp = (Accessor)this.getPropertyMap().get(key);
        if (sp != null) {
            return sp.get(this);
        }
        throw new IllegalArgumentException("Undefined property " + String.valueOf(key));
    }

    @Override
    public Object put(String key, Object value) {
        Accessor sp = (Accessor)this.getPropertyMap().get(key);
        if (sp != null) {
            Object old = sp.get(this);
            sp.set(this, value);
            return old;
        }
        throw new IllegalArgumentException("Undefined property " + key);
    }

    @Override
    public boolean supports(Object key) {
        return this.getPropertyMap().containsKey(key);
    }

    @Override
    public Object remove(Object key) {
        Accessor sp = (Accessor)this.getPropertyMap().get(key);
        if (sp != null) {
            Object old = sp.get(this);
            sp.set(this, null);
            return old;
        }
        throw new IllegalArgumentException("Undefined property " + String.valueOf(key));
    }

    @Override
    public Map<String, Object> asMap() {
        if (this.mapView == null) {
            this.mapView = this.createView();
        }
        return this.mapView;
    }

    protected Map<String, Object> createView() {
        return new MapView(this.mapAllowsAdditionalProperties());
    }

    protected boolean mapAllowsAdditionalProperties() {
        return false;
    }

    protected void createEntrySet(Set<Map.Entry<String, Object>> core) {
        for (final Map.Entry e : this.getPropertyMap().entrySet()) {
            core.add(new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return (String)e.getKey();
                }

                @Override
                public Object getValue() {
                    return ((Accessor)e.getValue()).get(BasePropertySet.this);
                }

                @Override
                public Object setValue(Object value) {
                    Accessor acc = (Accessor)e.getValue();
                    Object old = acc.get(BasePropertySet.this);
                    acc.set(BasePropertySet.this, value);
                    return old;
                }
            });
        }
    }

    protected static class PropertyMap
    extends HashMap<String, Accessor> {
        private static final long serialVersionUID = 2640743517567338373L;
        transient PropertyMapEntry[] cachedEntries = null;

        protected PropertyMap() {
        }

        PropertyMapEntry[] getPropertyMapEntries() {
            if (this.cachedEntries == null) {
                this.cachedEntries = this.createPropertyMapEntries();
            }
            return this.cachedEntries;
        }

        private PropertyMapEntry[] createPropertyMapEntries() {
            PropertyMapEntry[] modelEntries = new PropertyMapEntry[this.size()];
            int i = 0;
            for (Map.Entry e : this.entrySet()) {
                modelEntries[i++] = new PropertyMapEntry((String)e.getKey(), (Accessor)e.getValue());
            }
            return modelEntries;
        }
    }

    protected static interface Accessor {
        public String getName();

        public boolean hasValue(PropertySet var1);

        public Object get(PropertySet var1);

        public void set(PropertySet var1, Object var2);
    }

    final class MapView
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -8512282119705090517L;
        boolean extensible;

        MapView(boolean extensible) {
            super(BasePropertySet.this.getPropertyMap().getPropertyMapEntries().length);
            this.extensible = extensible;
            this.initialize();
        }

        public void initialize() {
            PropertyMapEntry[] entries;
            for (PropertyMapEntry entry : entries = BasePropertySet.this.getPropertyMap().getPropertyMapEntries()) {
                super.put(entry.key, entry.value);
            }
        }

        @Override
        public Object get(Object key) {
            Object o = super.get(key);
            if (o instanceof Accessor) {
                return ((Accessor)o).get(BasePropertySet.this);
            }
            return o;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
            for (String key : this.keySet()) {
                entries.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, this.get(key)));
            }
            return entries;
        }

        @Override
        public Object put(String key, Object value) {
            Object o = super.get(key);
            if (o instanceof Accessor) {
                Object oldValue = ((Accessor)o).get(BasePropertySet.this);
                ((Accessor)o).set(BasePropertySet.this, value);
                return oldValue;
            }
            if (this.extensible) {
                return super.put(key, value);
            }
            throw new IllegalStateException("Unknown property [" + key + "] for PropertySet [" + BasePropertySet.this.getClass().getName() + "]");
        }

        @Override
        public void clear() {
            for (String key : this.keySet()) {
                this.remove(key);
            }
        }

        @Override
        public Object remove(Object key) {
            Object o = super.get(key);
            if (o instanceof Accessor) {
                ((Accessor)o).set(BasePropertySet.this, null);
            }
            return super.remove(key);
        }
    }

    public static class PropertyMapEntry {
        String key;
        Accessor value;

        public PropertyMapEntry(String k, Accessor v) {
            this.key = k;
            this.value = v;
        }
    }
}

