/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.config.types.Property;

public final class AdminEndpointDecider {
    private static final Logger logger = KernelLoggerInfo.getLogger();
    public static final int DEFAULT_ADMIN_PORT = 4848;
    private static final String CONTEXT_ROOT = "/__asadmin";
    private final Config config;
    private String guiContextRoot;
    private List<String> asadminHosts;
    private List<String> guiHosts;
    private InetAddress address;
    private int port;
    private int maxThreadPoolSize = 5;

    public AdminEndpointDecider(Config config) {
        if (config == null || logger == null) {
            throw new IllegalArgumentException("config or logger can't be null");
        }
        this.config = config;
        this.setValues();
    }

    public int getListenPort() {
        return this.port;
    }

    public InetAddress getListenAddress() {
        return this.address;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public List<String> getAsadminHosts() {
        return this.asadminHosts;
    }

    public List<String> getGuiHosts() {
        return this.guiHosts;
    }

    public String getAsadminContextRoot() {
        return CONTEXT_ROOT;
    }

    public String getGuiContextRoot() {
        return this.guiContextRoot;
    }

    private void setValues() {
        NetworkListener adminListener = this.config.getAdminListener();
        ThreadPool threadPool = adminListener.findThreadPool();
        if (threadPool != null) {
            try {
                this.maxThreadPoolSize = Integer.parseInt(threadPool.getMaxThreadPoolSize());
            }
            catch (NumberFormatException ne) {
                logger.log(Level.WARNING, "Invalid maxThreadPoolSize value: {0}", threadPool.getMaxThreadPoolSize());
            }
        }
        String defaultVirtualServer = adminListener.findHttpProtocol().getHttp().getDefaultVirtualServer();
        this.guiHosts = List.of(defaultVirtualServer);
        this.asadminHosts = this.guiHosts;
        try {
            this.address = InetAddress.getByName(adminListener.getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        if ("admin-listener".equals(adminListener.getName())) {
            this.guiContextRoot = "";
            try {
                this.port = Integer.parseInt(adminListener.getPort());
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Invalid admin port: {0}", adminListener.getPort());
                this.port = 4848;
            }
        } else {
            try {
                this.port = Integer.parseInt(adminListener.getPort());
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Invalid admin port: {0}", adminListener.getPort());
                this.port = 8080;
            }
            AdminService adminService = this.config.getAdminService();
            if (adminService == null) {
                this.guiContextRoot = "/admin";
            } else {
                this.setGuiContextRootFromAdminService(adminService);
            }
        }
    }

    private void setGuiContextRootFromAdminService(AdminService adminService) {
        for (Property property : adminService.getProperty()) {
            this.setGuiContextRoot(property);
        }
    }

    private void setGuiContextRoot(Property property) {
        if (property == null) {
            this.guiContextRoot = "/admin";
            return;
        }
        if ("adminConsoleContextRoot".equals(property.getName())) {
            if (property.getValue() != null && property.getValue().startsWith("/")) {
                this.guiContextRoot = property.getValue();
                logger.log(Level.INFO, "NCLS-CORE-00079", this.guiContextRoot);
            } else {
                logger.log(Level.INFO, "NCLS-CORE-00078", "/admin");
                this.guiContextRoot = "/admin";
            }
        }
    }
}

