/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingUnmarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingMarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeDirectCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.ChoiceCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.DirectCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;

public class XMLChoiceCollectionMappingMarshalNodeValue
extends MappingNodeValue
implements ContainerValue {
    private ChoiceCollectionMapping xmlChoiceCollectionMapping;
    private Map<Field, NodeValue> fieldToNodeValues;
    private Map<Class<?>, List<FieldNodeValue>> classToNodeValues;
    private NodeValue choiceElementNodeValue;
    private Field xmlField;
    private boolean isMixedNodeValue;
    private boolean isAny;
    private NodeValue anyNodeValue;
    private int index = -1;

    public XMLChoiceCollectionMappingMarshalNodeValue(ChoiceCollectionMapping mapping, Field xmlField) {
        this.xmlChoiceCollectionMapping = mapping;
        this.xmlField = xmlField;
        this.isAny = mapping.isAny();
        this.initializeNodeValue();
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        if (this.isMixedNodeValue) {
            return xPathFragment.nameIsText();
        }
        return this.choiceElementNodeValue.isOwningNode(xPathFragment);
    }

    public void setFieldToNodeValues(Map<Field, NodeValue> fieldToNodeValues) {
        this.fieldToNodeValues = fieldToNodeValues;
        this.classToNodeValues = new HashMap();
        for (Field nextField : fieldToNodeValues.keySet()) {
            Class<?> associatedClass = this.xmlChoiceCollectionMapping.getFieldToClassMappings().get(nextField);
            if (this.classToNodeValues.containsKey(associatedClass)) {
                this.classToNodeValues.get(associatedClass).add(new FieldNodeValue(nextField, fieldToNodeValues.get(nextField)));
                continue;
            }
            ArrayList<FieldNodeValue> newFieldToNodeValuesList = new ArrayList<FieldNodeValue>();
            newFieldToNodeValuesList.add(new FieldNodeValue(nextField, fieldToNodeValues.get(nextField)));
            this.classToNodeValues.put(associatedClass, newFieldToNodeValuesList);
        }
        Set<Class<?>> classes = this.classToNodeValues.keySet();
        for (Class<?> nextClass : this.xmlChoiceCollectionMapping.getChoiceElementMappingsByClass().keySet()) {
            if (classes.contains(nextClass)) continue;
            Field field = (Field)this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(nextClass);
            XMLChoiceCollectionMappingUnmarshalNodeValue nodeValue = new XMLChoiceCollectionMappingUnmarshalNodeValue(this.xmlChoiceCollectionMapping, this.xmlField, (Mapping)this.xmlChoiceCollectionMapping.getChoiceElementMappingsByClass().get(nextClass));
            ArrayList<FieldNodeValue> newFieldToNodeValuesList = new ArrayList<FieldNodeValue>();
            newFieldToNodeValuesList.add(new FieldNodeValue(field, nodeValue));
            this.classToNodeValues.put(nextClass, newFieldToNodeValuesList);
            NodeValue nodeValueForField = fieldToNodeValues.get(field);
            ((NodeValue)nodeValue).setXPathNode(nodeValueForField.getXPathNode());
        }
    }

    private void initializeNodeValue() {
        CollectionReferenceMapping refMapping;
        Mapping xmlMapping = (Mapping)this.xmlChoiceCollectionMapping.getChoiceElementMappings().get(this.xmlField);
        this.choiceElementNodeValue = xmlMapping instanceof BinaryDataCollectionMapping ? new XMLBinaryDataCollectionMappingNodeValue((BinaryDataCollectionMapping)xmlMapping) : (xmlMapping instanceof DirectCollectionMapping ? new XMLCompositeDirectCollectionMappingNodeValue((DirectCollectionMapping)xmlMapping) : (xmlMapping instanceof CompositeCollectionMapping ? new XMLCompositeCollectionMappingNodeValue((CompositeCollectionMapping)xmlMapping) : ((refMapping = (CollectionReferenceMapping)xmlMapping).usesSingleNode() || refMapping.getFields().size() == 1 ? new XMLCollectionReferenceMappingNodeValue(refMapping, this.xmlField) : new XMLCollectionReferenceMappingMarshalNodeValue((CollectionReferenceMapping)xmlMapping))));
        if (this.isAny) {
            this.anyNodeValue = new XMLChoiceCollectionMappingUnmarshalNodeValue(this.xmlChoiceCollectionMapping, null, this.xmlChoiceCollectionMapping.getAnyMapping());
        }
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlChoiceCollectionMapping.isReadOnly()) {
            return false;
        }
        Object value = this.xmlChoiceCollectionMapping.getAttributeValueFromObject(object);
        if (value == null) {
            AbstractNullPolicy wrapperNP = this.xmlChoiceCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        Object iterator = cp.iteratorFor(value);
        if (null != iterator && cp.hasNext(iterator)) {
            if (xPathFragment != null) {
                XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
                marshalRecord.closeStartGroupingElements(groupingFragment);
            }
        } else {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlChoiceCollectionMapping.getWrapperNullPolicy() != null);
        }
        if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON()) {
            ArrayList<NodeValue> nodeValues = new ArrayList<NodeValue>();
            ArrayList values = new ArrayList();
            XMLChoiceCollectionMappingMarshalNodeValue mixedNodeValue = null;
            ArrayList<Object> mixedValues = null;
            while (cp.hasNext(iterator)) {
                Object nextValue = this.xmlChoiceCollectionMapping.convertObjectValueToDataValue(cp.next(iterator, session), session, marshalRecord.getMarshaller());
                NodeValue nodeValue = this.getNodeValueForValue(nextValue);
                if (nodeValue == null) continue;
                if (nodeValue == this) {
                    mixedNodeValue = this;
                    if (mixedValues == null) {
                        mixedValues = new ArrayList<Object>();
                    }
                    mixedValues.add(nextValue);
                    continue;
                }
                int index = nodeValues.indexOf(nodeValue);
                if (index > -1) {
                    ((List)values.get(index)).add(nextValue);
                    continue;
                }
                nodeValues.add(nodeValue);
                ArrayList<Object> valuesList = new ArrayList<Object>();
                valuesList.add(nextValue);
                values.add(valuesList);
            }
            if (mixedNodeValue != null) {
                nodeValues.add(mixedNodeValue);
                values.add(mixedValues);
            }
            for (int i = 0; i < nodeValues.size(); ++i) {
                NodeValue associatedNodeValue = (NodeValue)nodeValues.get(i);
                List listValue = (List)values.get(i);
                XPathFragment frag = null;
                if (associatedNodeValue == this) {
                    frag = marshalRecord.getTextWrapperFragment();
                } else {
                    frag = associatedNodeValue.getXPathNode().getXPathFragment();
                    if (frag != null) {
                        frag = this.getOwningFragment(associatedNodeValue, frag);
                        associatedNodeValue = ((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementMarshalNodeValue();
                    }
                }
                if (frag == null && !associatedNodeValue.isAnyMappingNodeValue()) continue;
                int valueSize = listValue.size();
                if (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays()) {
                    marshalRecord.startCollection();
                }
                for (int j = 0; j < valueSize; ++j) {
                    this.marshalSingleValueWithNodeValue(frag, marshalRecord, object, listValue.get(j), session, namespaceResolver, ObjectMarshalContext.getInstance(), associatedNodeValue);
                }
                if (valueSize <= 1 && ((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays()) continue;
                marshalRecord.endCollection();
            }
        } else {
            while (cp.hasNext(iterator)) {
                Object nextValue = cp.next(iterator, session);
                this.marshalSingleValue(xPathFragment, marshalRecord, object, nextValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
            }
        }
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if ((value = this.xmlChoiceCollectionMapping.convertObjectValueToDataValue(value, session, marshalRecord.getMarshaller())) != null && value.getClass() == CoreClassConstants.STRING && this.xmlChoiceCollectionMapping.isMixedContent()) {
            this.marshalMixedContent(marshalRecord, (String)value);
            return true;
        }
        NodeValue associatedNodeValue = this.getNodeValueForValue(value);
        if (associatedNodeValue != null) {
            if (associatedNodeValue.isAnyMappingNodeValue()) {
                return this.marshalSingleValueWithNodeValue(null, marshalRecord, object, value, session, namespaceResolver, marshalContext, associatedNodeValue);
            }
            XPathFragment frag = associatedNodeValue.getXPathNode().getXPathFragment();
            if (frag != null) {
                frag = this.getOwningFragment(associatedNodeValue, frag);
                NodeValue unwrappedNodeValue = ((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementMarshalNodeValue();
                return this.marshalSingleValueWithNodeValue(frag, marshalRecord, object, value, session, namespaceResolver, marshalContext, unwrappedNodeValue);
            }
        }
        return true;
    }

    private boolean marshalSingleValueWithNodeValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext, NodeValue unwrappedNodeValue) {
        if (unwrappedNodeValue != null) {
            unwrappedNodeValue.marshalSingleValue(xPathFragment, marshalRecord, object, value, session, namespaceResolver, marshalContext);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private NodeValue getNodeValueForValue(Object value) {
        void var3_16;
        if (value == null) {
            for (XMLChoiceCollectionMappingUnmarshalNodeValue xMLChoiceCollectionMappingUnmarshalNodeValue : this.fieldToNodeValues.values()) {
                Mapping nextMapping;
                NodeValue nextNodeValue = xMLChoiceCollectionMappingUnmarshalNodeValue.getChoiceElementMarshalNodeValue();
                if (!(nextNodeValue instanceof MappingNodeValue) || !((nextMapping = ((MappingNodeValue)nextNodeValue).getMapping()).isAbstractCompositeCollectionMapping() ? ((CompositeCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil() : (nextMapping.isAbstractCompositeDirectCollectionMapping() ? ((DirectCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil() : nextMapping instanceof BinaryDataCollectionMapping && ((BinaryDataCollectionMapping)nextMapping).getNullPolicy().isNullRepresentedByXsiNil()))) continue;
                return xMLChoiceCollectionMappingUnmarshalNodeValue;
            }
            return null;
        }
        Field associatedField = null;
        Object var3_5 = null;
        if (value instanceof Root) {
            Root rootValue = (Root)value;
            String localName = rootValue.getLocalName();
            String namespaceUri = rootValue.getNamespaceURI();
            Object fieldValue = rootValue.getObject();
            associatedField = this.getFieldForName(localName, namespaceUri);
            if (associatedField == null) {
                if (this.xmlChoiceCollectionMapping.isAny()) {
                    return this.anyNodeValue;
                }
                Class<?> theClass = fieldValue.getClass();
                while (associatedField == null) {
                    associatedField = (Field)this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(theClass);
                    if (theClass.getSuperclass() == null) break;
                    theClass = theClass.getSuperclass();
                }
            }
            if (associatedField != null) {
                NodeValue nodeValue = this.fieldToNodeValues.get(associatedField);
            }
        } else {
            Class<?> theClass = value.getClass();
            while (associatedField == null) {
                associatedField = (Field)this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(theClass);
                List<FieldNodeValue> fieldNodes = this.classToNodeValues.get(theClass);
                Object var3_9 = null;
                if (null != fieldNodes) {
                    void var3_10;
                    if (null != associatedField && fieldNodes.size() > 1) {
                        for (FieldNodeValue fieldNode : fieldNodes) {
                            if (!fieldNode.getField().equals(associatedField)) continue;
                            NodeValue nodeValue = fieldNode.getNodeValue();
                        }
                    }
                    if (null == var3_10 && fieldNodes.size() > 0) {
                        NodeValue nodeValue = fieldNodes.get(0).getNodeValue();
                    }
                }
                if (theClass.getSuperclass() == null) break;
                theClass = theClass.getSuperclass();
            }
        }
        if (associatedField == null) {
            List sourceFields = null;
            for (Class<?> theClass = value.getClass(); theClass != null && (sourceFields = this.xmlChoiceCollectionMapping.getClassToSourceFieldsMappings().get(theClass)) == null; theClass = theClass.getSuperclass()) {
            }
            if (sourceFields != null) {
                associatedField = (Field)sourceFields.get(0);
                NodeValue nodeValue = this.fieldToNodeValues.get(associatedField);
            }
        }
        if (var3_16 != null) {
            return var3_16;
        }
        if (associatedField != null) {
            return this.fieldToNodeValues.get(associatedField);
        }
        if (this.xmlChoiceCollectionMapping.isMixedContent() && value instanceof String) {
            return this;
        }
        if (this.xmlChoiceCollectionMapping.isAny()) {
            return this.anyNodeValue;
        }
        return null;
    }

    private XPathFragment getOwningFragment(NodeValue nodeValue, XPathFragment frag) {
        while (frag != null) {
            if (nodeValue.isOwningNode(frag)) {
                return frag;
            }
            frag = frag.getNextFragment();
        }
        return null;
    }

    private void marshalMixedContent(MarshalRecord record, String value) {
        record.characters(value);
    }

    private Field getFieldForName(String localName, String namespaceUri) {
        for (Field nextField : this.fieldToNodeValues.keySet()) {
            if (nextField == null) continue;
            for (XPathFragment fragment = nextField.getXPathFragment(); fragment != null && !fragment.nameIsText(); fragment = fragment.getNextFragment()) {
                if (fragment.getNextFragment() != null && !fragment.getHasText() || !fragment.getLocalName().equals(localName)) continue;
                String fragUri = fragment.getNamespaceURI();
                if ((namespaceUri != null || fragUri != null) && (namespaceUri == null || fragUri == null || !namespaceUri.equals(fragUri))) continue;
                return nextField;
            }
        }
        return null;
    }

    public Collection<NodeValue> getAllNodeValues() {
        return this.fieldToNodeValues.values();
    }

    @Override
    public boolean isMarshalNodeValue() {
        return true;
    }

    @Override
    public boolean isUnmarshalNodeValue() {
        return false;
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return false;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlChoiceCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlChoiceCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public ChoiceCollectionMapping getMapping() {
        return this.xmlChoiceCollectionMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    public void setIsMixedNodeValue(boolean b) {
        this.isMixedNodeValue = b;
    }

    @Override
    public boolean isMixedContentNodeValue() {
        return this.isMixedNodeValue;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }

    @Override
    public void setXPathNode(XPathNode xPathNode) {
        super.setXPathNode(xPathNode);
        if (this.anyNodeValue != null) {
            this.anyNodeValue.setXPathNode(xPathNode);
        }
    }

    private static class FieldNodeValue {
        private final Field field;
        private final NodeValue nodeValue;

        public FieldNodeValue(Field field, NodeValue nodeValue) {
            this.field = field;
            this.nodeValue = nodeValue;
        }

        public Field getField() {
            return this.field;
        }

        public NodeValue getNodeValue() {
            return this.nodeValue;
        }
    }
}

