/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

public class ClusterBrokerInfoReply {
    private BrokerInfo brokerInfo = null;
    private int status = 0;
    private GPacket pkt = null;

    private ClusterBrokerInfoReply(BrokerInfo bi, int status) {
        this.brokerInfo = bi;
        this.status = status;
    }

    private ClusterBrokerInfoReply(GPacket pkt) throws Exception {
        assert (pkt.getType() == 46);
        this.pkt = pkt;
        this.status = (Integer)pkt.getProp((Object)"S");
        ByteArrayInputStream bis = new ByteArrayInputStream(pkt.getPayload().array());
        FilteringObjectInputStream ois = new FilteringObjectInputStream((InputStream)bis);
        this.brokerInfo = (BrokerInfo)ois.readObject();
    }

    public static ClusterBrokerInfoReply newInstance(BrokerInfo bi, int status) {
        return new ClusterBrokerInfoReply(bi, status);
    }

    public static ClusterBrokerInfoReply newInstance(GPacket pkt) throws Exception {
        return new ClusterBrokerInfoReply(pkt);
    }

    public GPacket getGPacket() throws Exception {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)46);
        gp.setBit(1, false);
        gp.putProp((Object)"S", (Object)this.status);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this.brokerInfo);
        oos.flush();
        oos.close();
        byte[] buf = bos.toByteArray();
        gp.setPayload(ByteBuffer.wrap(buf));
        return gp;
    }

    public int getStatus() {
        return this.status;
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public boolean isTakingover() {
        return this.getStatus() == 1;
    }

    public boolean sendAndClose() {
        return this.isTakingover();
    }
}

