/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import jakarta.ejb.EJBException;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class CallbackInterceptor {
    protected int index;
    protected Method method;

    CallbackInterceptor(int index, Method method) {
        this.index = index;
        this.method = method;
        try {
            final Method finalM = method;
            if (System.getSecurityManager() == null) {
                if (!finalM.trySetAccessible()) {
                    throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(finalM));
                }
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!finalM.trySetAccessible()) {
                            throw new InaccessibleObjectException("Unable to make accessible: " + String.valueOf(finalM));
                        }
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    Object intercept(final CallbackInvocationContext invContext) throws Throwable {
        try {
            final Object[] interceptors = invContext.getInterceptorInstances();
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return CallbackInterceptor.this.method.invoke(interceptors[CallbackInterceptor.this.index], invContext);
                    }
                });
            }
            return this.method.invoke(interceptors[this.index], invContext);
        }
        catch (InvocationTargetException invEx) {
            throw invEx.getCause();
        }
        catch (PrivilegedActionException paEx) {
            Throwable th = paEx.getCause();
            if (th.getCause() != null) {
                throw th.getCause();
            }
            throw th;
        }
    }

    boolean isBeanCallback() {
        return false;
    }

    public String toString() {
        return "callback[" + this.index + "]: " + String.valueOf(this.method);
    }
}

