/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.glassfish.admin.mbeanserver.JMXSslConfigHolder;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.grizzly.config.SSLConfigurator;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.logging.annotation.LogMessageInfo;

public class SecureRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private final InetAddress mAddress;
    private final ServiceLocator locator;
    private final Ssl ssl;
    private String[] enabledCipherSuites;
    private volatile Object enabledCipherSuitesLock;
    private String[] enabledProtocols;
    private volatile Object enabledProtocolsLock;
    private final Object cipherSuitesSync = new Object();
    private final Object protocolsSync = new Object();
    private final Map<Integer, ServerSocket> socketMap = new HashMap<Integer, ServerSocket>();
    @LogMessageInfo(level="INFO", message="Creating a SecureRMIServerSocketFactory @ {0} with ssl config = {1}")
    private static final String creatingServerSocketFactory = "NCLS-JMX-00024";
    @LogMessageInfo(level="INFO", message="SSLServerSocket {0} and {1} created")
    private static final String createdServerSocket = "NCLS-JMX-00025";

    public SecureRMIServerSocketFactory(ServiceLocator locator, Ssl sslConfig, InetAddress addr) {
        this.mAddress = addr;
        this.locator = locator;
        this.ssl = sslConfig;
        Util.getLogger().log(Level.INFO, creatingServerSocketFactory, new Object[]{addr.getHostAddress(), this.ssl});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecureRMIServerSocketFactory that = (SecureRMIServerSocketFactory)o;
        if (this.cipherSuitesSync != null ? !this.cipherSuitesSync.equals(that.cipherSuitesSync) : that.cipherSuitesSync != null) {
            return false;
        }
        if (!Arrays.equals(this.enabledCipherSuites, that.enabledCipherSuites)) {
            return false;
        }
        if (!Arrays.equals(this.enabledProtocols, that.enabledProtocols)) {
            return false;
        }
        if (this.locator != null ? !this.locator.equals((Object)that.locator) : that.locator != null) {
            return false;
        }
        if (this.mAddress != null ? !this.mAddress.equals(that.mAddress) : that.mAddress != null) {
            return false;
        }
        if (this.protocolsSync != null ? !this.protocolsSync.equals(that.protocolsSync) : that.protocolsSync != null) {
            return false;
        }
        if (this.socketMap != null ? !this.socketMap.equals(that.socketMap) : that.socketMap != null) {
            return false;
        }
        return !(this.ssl != null ? !this.ssl.equals((Object)that.ssl) : that.ssl != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.mAddress != null ? this.mAddress.hashCode() : 0);
        result = 31 * result + (this.locator != null ? this.locator.hashCode() : 0);
        result = 31 * result + (this.ssl != null ? this.ssl.hashCode() : 0);
        result = 31 * result + (this.enabledCipherSuites != null ? Arrays.hashCode(this.enabledCipherSuites) : 0);
        result = 31 * result + (this.enabledProtocols != null ? Arrays.hashCode(this.enabledProtocols) : 0);
        result = 31 * result + (this.cipherSuitesSync != null ? this.cipherSuitesSync.hashCode() : 0);
        result = 31 * result + (this.protocolsSync != null ? this.protocolsSync.hashCode() : 0);
        result = 31 * result + (this.socketMap != null ? this.socketMap.hashCode() : 0);
        return result;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        JMXSslConfigHolder sslConfigHolder;
        if (this.socketMap.containsKey(port)) {
            return this.socketMap.get(port);
        }
        int backlog = 5;
        try {
            sslConfigHolder = new JMXSslConfigHolder(this.locator, this.ssl);
        }
        catch (SSLException ssle) {
            throw new IllegalStateException(ssle);
        }
        SSLContext context = sslConfigHolder.getSslContext();
        ServerSocket sslSocket = context.getServerSocketFactory().createServerSocket(port, 5, this.mAddress);
        if (!(sslSocket instanceof SSLServerSocket)) {
            throw new IllegalStateException("ServerSocketFactory returned non-secure server socket.");
        }
        this.configureSSLSocket((SSLServerSocket)sslSocket, sslConfigHolder);
        Util.getLogger().log(Level.INFO, createdServerSocket, new Object[]{sslSocket.getLocalSocketAddress(), sslSocket.toString()});
        this.socketMap.put(port, sslSocket);
        return sslSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureSSLSocket(SSLServerSocket sslSocket, SSLConfigurator sslConfigHolder) {
        Object object;
        if (sslConfigHolder.getEnabledCipherSuites() != null) {
            if (this.enabledCipherSuitesLock == null) {
                object = this.cipherSuitesSync;
                synchronized (object) {
                    if (this.enabledCipherSuitesLock == null) {
                        this.enabledCipherSuitesLock = new Object();
                        this.enabledCipherSuites = SecureRMIServerSocketFactory.configureEnabledCiphers(sslSocket, sslConfigHolder.getEnabledCipherSuites());
                    }
                }
            }
            sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (sslConfigHolder.getEnabledProtocols() != null) {
            if (this.enabledProtocolsLock == null) {
                object = this.protocolsSync;
                synchronized (object) {
                    if (this.enabledProtocolsLock == null) {
                        this.enabledProtocolsLock = new Object();
                        this.enabledProtocols = SecureRMIServerSocketFactory.configureEnabledProtocols(sslSocket, sslConfigHolder.getEnabledProtocols());
                    }
                }
            }
            sslSocket.setEnabledProtocols(this.enabledProtocols);
        }
        sslSocket.setUseClientMode(sslConfigHolder.isClientMode());
    }

    private static String[] configureEnabledProtocols(SSLServerSocket socket, String[] requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static String[] configureEnabledCiphers(SSLServerSocket socket, String[] requestedCiphers) {
        String[] supportedCiphers = socket.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }
}

