/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.PacketUtil;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.GlobalProperties;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeInfo;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.LocalTransaction;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DebugHandler;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.AckEntryNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.BrokerDownException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MaxConsecutiveRollbackException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class TransactionHandler
extends PacketHandler {
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
    private DestinationList DL = Globals.getDestinationList();
    FaultInjection fi = FaultInjection.getInjection();

    public void sendReply(IMQConnection con, Packet msg, int type, int status, long tid, String reason) {
        this.sendReply(con, msg, type, status, tid, reason, null, null, 0L);
    }

    public void sendReply(IMQConnection con, Packet msg, int type, int status, long tid, String reason, BrokerException bex) {
        this.sendReply(con, msg, type, status, tid, reason, bex, null, 0L);
    }

    public void sendReply(IMQConnection con, Packet msg, int type, int status, long tid, String reason, BrokerException bex, Map props, long nextTid) {
        if (this.fi.FAULT_INJECTION) {
            this.checkFIAfterProcess(msg.getPacketType());
        }
        Packet pkt = new Packet(con.useDirectBuffers());
        pkt.setPacketType(type);
        pkt.setConsumerID(msg.getConsumerID());
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        hash.put("JMQStatus", status);
        if (reason != null) {
            hash.put("JMQReason", reason);
        }
        if (tid != 0L) {
            hash.put("JMQTransactionID", tid);
        }
        if (bex != null && bex.isRemote()) {
            hash.put("JMQRemote", Boolean.TRUE);
            if (bex.getRemoteConsumerUIDs() != null) {
                hash.put("JMQRemoteConsumerIDs", bex.getRemoteConsumerUIDs());
            }
        }
        if (props != null) {
            Iterator itr = props.entrySet().iterator();
            Map.Entry pair = null;
            Object key = null;
            while (itr.hasNext()) {
                pair = itr.next();
                key = pair.getKey();
                hash.put((String)key, pair.getValue());
            }
        }
        if (nextTid != 0L) {
            hash.put("JMQNextTransactionID", nextTid);
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        if (this.fi.FAULT_INJECTION) {
            this.checkFIAfterReply(msg.getPacketType());
        }
    }

    public void sendReplyBody(IMQConnection con, Packet msg, int type, int status, Hashtable hash, byte[] body) {
        Packet pkt;
        block6: {
            block5: {
                pkt = new Packet(con.useDirectBuffers());
                pkt.setPacketType(type);
                pkt.setConsumerID(msg.getConsumerID());
                if (hash == null) {
                    hash = new Hashtable<String, Integer>();
                }
                hash.put("JMQStatus", status);
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block5;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block6;
            }
            hash.put("JMQReqID", (Integer)((Object)msg.getSysMessageID().toString()));
        }
        pkt.setProperties(hash);
        if (body != null) {
            pkt.setMessageBody(body);
        }
        con.sendControlMessage(pkt);
    }

    public long getJMQTransactionID(Hashtable props) {
        if (props != null) {
            Object obj = props.get("JMQTransactionID");
            if (obj instanceof Integer) {
                return ((Integer)obj).intValue();
            }
            if (obj != null) {
                return (Long)obj;
            }
        }
        return 0L;
    }

    public static void convertPacketTid(IMQConnection con, Packet p) {
        long messagetid = p.getTransactionID();
        HashMap tidMap = (HashMap)con.getClientData("tidmap");
        if (tidMap == null) {
            return;
        }
        TransactionUID id = (TransactionUID)tidMap.get(messagetid);
        if (id == null) {
            return;
        }
        p.setTransactionID(id.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        block96: {
            block97: {
                block95: {
                    messagetid = 0L;
                    id = null;
                    ts = null;
                    xid = null;
                    xaFlags = null;
                    redeliverMsgs = false;
                    startNextTransaction = false;
                    setRedeliverFlag = true;
                    isIndemp = msg.getIndempotent();
                    replay = false;
                    jmqonephase = false;
                    jmqonephaseFlag = null;
                    props = null;
                    reason = null;
                    Globals.getDestinationList();
                    tls = DestinationList.getTransactionList(con.getPartitionedStore());
                    translist = tls[0];
                    try {
                        props = msg.getProperties();
                        if (props == null) {
                            props = new Hashtable<K, V>();
                        }
                    }
                    catch (Exception ex) {
                        this.logger.logStack(16, "Unable to retrieve  properties from transaction message " + String.valueOf(msg), ex);
                        props = new Hashtable<K, V>();
                    }
                    startNextTransactionBool = (Boolean)props.get("JMQStartNextTransaction");
                    startNextTransaction = startNextTransactionBool != null && startNextTransactionBool != false;
                    redeliverMsgBool = (Boolean)props.get("JMQRedeliver");
                    redeliverMsgs = redeliverMsgBool != null && redeliverMsgBool != false;
                    b = (Boolean)props.get("JMQUpdateConsumed");
                    updateConsumed = b != null && b != false;
                    redeliverFlag = (Boolean)props.get("JMQSetRedelivered");
                    setRedeliverFlag = redeliverFlag == null || redeliverFlag != false;
                    maxRollbackFlag = (Integer)props.get("JMQMaxRollbacks");
                    maxRollbacks = maxRollbackFlag == null ? -1 : maxRollbackFlag;
                    dmqOnMaxRollbacksFlag = (Boolean)props.get("JMQDMQOnMaxRollbacks");
                    v0 = dmqOnMaxRollbacks = dmqOnMaxRollbacksFlag != null && dmqOnMaxRollbacksFlag != false;
                    if (maxRollbacks <= 0) {
                        dmqOnMaxRollbacks = Consumer.MSG_MAX_CONSECUTIVE_ROLLBACKS > 0;
                    }
                    v1 = jmqonephase = (jmqonephaseFlag = (Boolean)props.get("JMQXAOnePhase")) != null && jmqonephaseFlag != false;
                    if (TransactionHandler.DEBUG) {
                        this.logger.log(4, PacketType.getString(msg.getPacketType()) + ": TUID=" + String.valueOf(id) + ", JMQRedeliver=" + redeliverMsgBool + (String)(jmqonephaseFlag == null ? "" : ", JMQXAOnePhase=" + jmqonephase));
                    }
                    if ((conlist = (ArrayList<E>)con.getClientData("transaction")) == null) {
                        conlist = new ArrayList<E>();
                        con.addClientData("transaction", conlist);
                    }
                    if ((body = msg.getMessageBodyByteBuffer()) != null) {
                        bbis = new JMQByteBufferInputStream(body);
                        try {
                            xid = JMQXid.read(new DataInputStream(bbis));
                            startNextTransaction = false;
                        }
                        catch (IOException e) {
                            this.logger.log(32, "B3100", "Could not decode xid from packet: " + String.valueOf(e) + " Ignoring " + PacketType.getString(msg.getPacketType()));
                            reason = e.getMessage();
                            this.sendReply(con, msg, msg.getPacketType() + 1, 400, 0L, (String)reason);
                            return true;
                        }
                    }
                    xaFlags = (Integer)props.get("JMQXAFlags");
                    tidMap = null;
                    e = con;
                    synchronized (e) {
                        tidMap = (HashMap<K, V>)con.getClientData("tidmap");
                        if (tidMap == null) {
                            tidMap = new HashMap<K, V>();
                            con.addClientData("tidmap", tidMap);
                        }
                    }
                    messagetid = this.getJMQTransactionID(props);
                    if (this.fi.FAULT_INJECTION) {
                        this.checkFIBeforeProcess(msg.getPacketType());
                    }
                    translistResolved = false;
                    if (msg.getPacketType() != 44 || xaFlags != null && !TransactionState.isFlagSet(0, xaFlags)) break block95;
                    if (isIndemp) {
                        rets /* !! */  = TransactionList.getTransactionByCreator(msg.getSysMessageID().toString());
                        if (rets /* !! */  == null) {
                            id = new TransactionUID();
                        } else {
                            translist = (TransactionList)rets /* !! */ [0];
                            id = (TransactionUID)rets /* !! */ [1];
                            replay = true;
                        }
                    } else {
                        id = new TransactionUID();
                    }
                    translistResolved = true;
                    break block96;
                }
                if (msg.getPacketType() != 60) break block97;
                if (messagetid != 0L) {
                    id = new TransactionUID(messagetid);
                }
                xid = null;
                break block96;
            }
            if (messagetid != 0L || xid == null) ** GOTO lbl107
            rets /* !! */  = TransactionList.mapXidToTid(xid, con);
            if (rets /* !! */  != null) {
                translist = (TransactionList)rets /* !! */ [0];
                id = (TransactionUID)rets /* !! */ [1];
                messagetid = id.longValue();
                translistResolved = true;
            } else {
                this.logger.log(16, PacketType.getString(msg.getPacketType()) + ": Ignoring unknown XID=" + String.valueOf(xid) + " broker will " + (msg.getSendAcknowledge() != false ? "notify the client" : " not notify the client"));
                if (msg.getSendAcknowledge()) {
                    reason = "Uknown XID " + String.valueOf(xid);
                    this.sendReply(con, msg, msg.getPacketType() + 1, 404, 0L, (String)reason);
                }
                return true;
lbl107:
                // 1 sources

                if (messagetid != 0L) {
                    if (con.getClientProtocolVersion() == 100) {
                        rets /* !! */  = tidMap;
                        synchronized (rets /* !! */ ) {
                            id = (TransactionUID)tidMap.get(messagetid);
                        }
                    } else {
                        id = new TransactionUID(messagetid);
                    }
                }
            }
            if (id == null) {
                this.logger.log(8, "InternalError: Transaction ID was not passed by the jms api on a method that reqires an existing transaction ");
                this.sendReply(con, msg, msg.getPacketType() + 1, 500, 0L, "Internal Error: bad MQ protocol, missing TransactionID");
                return true;
            }
            if (translistResolved) {
                if (translist == null) {
                    emsg = "XXXNo transaction list found to process " + PacketType.getString(msg.getPacketType()) + " for transaction " + String.valueOf(id) + "[" + String.valueOf(xid) + "]";
                    this.logger.log(16, emsg);
                    if (msg.getSendAcknowledge()) {
                        reason = emsg;
                        this.sendReply(con, msg, msg.getPacketType() + 1, 410, 0L, (String)reason);
                    }
                    return true;
                }
                ts = translist.retrieveState(id);
            } else {
                oo = TransactionList.getTransListAndState(id, con, false, false);
                if (oo != null) {
                    translist = (TransactionList)oo[0];
                    ts = (TransactionState)oo[1];
                }
            }
            if (ts == null) {
                if (isIndemp && (msg.getPacketType() == 48 || msg.getPacketType() == 46)) {
                    if (msg.getSendAcknowledge()) {
                        this.sendReply(con, msg, msg.getPacketType() + 1, 200, id.longValue(), (String)reason);
                        return true;
                    }
                    if (this.fi.FAULT_INJECTION) {
                        this.checkFIAfterProcess(msg.getPacketType());
                        this.checkFIAfterReply(msg.getPacketType());
                    }
                } else {
                    ts = this.cacheGetState(id, con);
                    if (ts != null) {
                        this.logger.log(32, "Transaction ID " + String.valueOf(id) + " has already been resolved. Ignoring request: " + PacketType.getString(msg.getPacketType()) + ". Last state of this transaction: " + ts.toString() + " broker will " + (msg.getSendAcknowledge() != false ? "notify the client" : " not notify the client"));
                    } else {
                        this.logger.log(BrokerStateHandler.isShuttingDown() != false ? 4 : 16, Globals.getBrokerResources().getKString(msg.getSendAcknowledge() != false ? "B2188" : "B2189", String.valueOf(id) + "(" + messagetid + ")" + (String)(xid == null ? "" : "XID=" + String.valueOf(xid)), PacketType.getString(msg.getPacketType())) + "\n" + PacketUtil.dumpPacket(msg));
                    }
                    if (msg.getSendAcknowledge()) {
                        reason = "Unknown transaction " + String.valueOf(id);
                        this.sendReply(con, msg, msg.getPacketType() + 1, 404, id.longValue(), (String)reason);
                    }
                    return true;
                }
            }
        }
        if (TransactionHandler.DEBUG) {
            this.logger.log(8, this.getClass().getName() + ": " + PacketType.getString(msg.getPacketType()) + ": TUID=" + String.valueOf(id) + " XAFLAGS=" + TransactionState.xaFlagToString(xaFlags) + (String)(jmqonephaseFlag == null ? "" : " JMQXAOnePhase=" + jmqonephase) + " State=" + String.valueOf(ts) + " Xid=" + String.valueOf(xid));
        }
        if (!(xid == null || ts == null || ts.getXid() != null && xid.equals(ts.getXid()))) {
            this.logger.log(32, "B3100", "Transaction Xid mismatch. " + PacketType.getString(msg.getPacketType()) + " Packet has tuid=" + String.valueOf(id) + " xid=" + String.valueOf(xid) + ", transaction table has tuid=" + String.valueOf(id) + " xid=" + String.valueOf(ts.getXid()) + ". Using values from table.");
            xid = ts.getXid();
        }
        if (xid == null && ts != null && ts.getXid() != null && msg.getPacketType() != 60) {
            xid = ts.getXid();
            this.logger.log(16, "B3100", "Transaction Xid " + String.valueOf(xid) + " not found in " + PacketType.getString(msg.getPacketType()) + " packet for tuid " + String.valueOf(id) + ". Will use " + String.valueOf(xid));
        }
        status = 200;
        type = null;
        lifetime = 0L;
        sessionLess = false;
        typeValue = (Integer)props.get("JMQAutoRollback");
        lifetimeValue = (Long)props.get("JMQLifetime");
        sessionLessValue = (Boolean)props.get("JMQSessionLess");
        if (typeValue != null) {
            type = AutoRollbackType.getType(typeValue);
        }
        if (lifetimeValue != null) {
            lifetime = lifetimeValue;
        }
        sessionLess = sessionLessValue != null ? sessionLessValue : xid != null;
        switch (msg.getPacketType()) {
            case 44: {
                try {
                    this.doStart(translist, id, conlist, con, type, xid, sessionLess, lifetime, messagetid, xaFlags, msg.getPacketType(), replay, msg.getSysMessageID().toString());
                }
                catch (Exception ex) {
                    status = 500;
                    this.logger.logStack(32, ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid), ex);
                    reason = ex.getMessage();
                    if (!(ex instanceof BrokerException)) ** GOTO lbl185
                    status = ((BrokerException)ex).getStatusCode();
                }
lbl185:
                // 3 sources

                this.sendReply(con, msg, 45, status, id.longValue(), (String)reason);
                break;
            }
            case 58: {
                try {
                    jmqnoop = (Boolean)props.get("JMQNoOp");
                    if (jmqnoop == null || !jmqnoop.booleanValue()) {
                        this.doEnd(translist, msg.getPacketType(), xid, xaFlags, ts, id);
                    }
                }
                catch (Exception ex) {
                    status = 500;
                    reason = ex.getMessage();
                    if (!(ex instanceof BrokerException)) ** GOTO lbl198
                    status = ((BrokerException)ex).getStatusCode();
                }
lbl198:
                // 3 sources

                this.sendReply(con, msg, msg.getPacketType() + 1, status, id.longValue(), (String)reason);
                break;
            }
            case 56: {
                bex = null;
                tmpp = null;
                try {
                    this.doPrepare(translist, id, xaFlags, ts, msg.getPacketType(), jmqonephase, null, con);
                }
                catch (Exception ex) {
                    status = 500;
                    if (!(ex instanceof BrokerDownException) && !(ex instanceof AckEntryNotFoundException) || TransactionHandler.DEBUG_CLUSTER_TXN) {
                        this.logger.logStack(32, ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid), ex);
                    } else {
                        this.logger.log(ex instanceof AckEntryNotFoundException != false ? 16 : 32, ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid));
                    }
                    reason = ex.getMessage();
                    if (ex instanceof BrokerException) {
                        status = ((BrokerException)ex).getStatusCode();
                        bex = (BrokerException)ex;
                    }
                    if (ts.getState() != 2) ** GOTO lbl221
                    tmpp = new HashMap<String, Boolean>();
                    tmpp.put("JMQPrepareStateFAILED", Boolean.TRUE);
                }
lbl221:
                // 3 sources

                this.sendReply(con, msg, msg.getPacketType() + 1, status, id.longValue(), (String)reason, bex, tmpp, 0L);
                break;
            }
            case 60: {
                v = null;
                if (id != null) {
                    v = new Vector();
                    ts = translist.retrieveState(id);
                    if (ts.getState() == 5) {
                        v.add(id);
                    }
                } else {
                    if (xaFlags == null || !TransactionState.isFlagSet(0x1000000, xaFlags)) {
                        hash = new Hashtable<String, Integer>();
                        hash.put("JMQQuantity", 0);
                        this.sendReplyBody(con, msg, 61, 200, hash, null);
                        break;
                    }
                    v = translist.getTransactions(5);
                }
                nIDs = v.size();
                nWritten = 0;
                bos = new ByteArrayOutputStream(nIDs * JMQXid.size());
                dos = new DataOutputStream(bos);
                for (n = 0; n < nIDs; ++n) {
                    tuid = (TransactionUID)v.get(n);
                    _ts = translist.retrieveState(tuid);
                    if (_ts == null) {
                        this.logger.log(32, "B3100", "Could not find state for TUID " + String.valueOf(tuid));
                        continue;
                    }
                    _xid = _ts.getXid();
                    if (_xid == null) continue;
                    try {
                        _xid.write(dos);
                        ++nWritten;
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.log(32, "B3100", "Could not write Xid " + String.valueOf(_xid) + " to message body: " + e.toString());
                    }
                }
                hash = new Hashtable<String, Number>();
                hash.put("JMQQuantity", nWritten);
                if (id != null) {
                    hash.put("JMQTransactionID", id.longValue());
                }
                this.sendReplyBody(con, msg, 61, 200, hash, bos.toByteArray());
                break;
            }
            case 46: {
                try {
                    if (xaFlags != null && jmqonephase) {
                        newxaFlags = xaFlags & -1073741825;
                        this.doCommit(translist, id, xid, newxaFlags, ts, conlist, true, con, msg);
                        break;
                    }
                    this.doCommit(translist, id, xid, xaFlags, ts, conlist, true, con, msg, startNextTransaction);
                }
                catch (BrokerException ex) {
                    status = ex.getStatusCode();
                    reason = ex.getMessage();
                    if (msg.getSendAcknowledge()) {
                        tmppp = null;
                        if (!jmqonephase && TransactionState.isFlagSet(0x40000000, xaFlags) && ts.getState() == 2) {
                            tmppp = new HashMap<String, Boolean>();
                            tmppp.put("JMQPrepareStateFAILED", Boolean.TRUE);
                        }
                        this.sendReply(con, msg, msg.getPacketType() + 1, status, id.longValue(), (String)reason, ex, tmppp, 0L);
                        break;
                    }
                    if (!this.fi.FAULT_INJECTION) break;
                    this.checkFIAfterProcess(msg.getPacketType());
                    this.checkFIAfterReply(msg.getPacketType());
                }
                break;
            }
            case 48: {
                maxrbex = null;
                try {
                    this.preRollback(translist, id, xid, xaFlags, ts);
                    try {
                        processActiveConsumers = redeliverMsgs;
                        this.redeliverUnacked(translist, id, processActiveConsumers, setRedeliverFlag, updateConsumed, maxRollbacks, dmqOnMaxRollbacks);
                    }
                    catch (BrokerException ex) {
                        if (ex instanceof MaxConsecutiveRollbackException) {
                            maxrbex = ex;
                        } else {
                            this.logger.logStack(32, "REDELIVER: " + ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid), ex);
                        }
                        reason = ex.getMessage();
                        status = ex.getStatusCode();
                    }
                    if (maxrbex == null || dmqOnMaxRollbacks) {
                        try {
                            if (this.fi.checkFault("txn.rollback.1_5.exception", null)) {
                                throw new BrokerException("txn.rollback.1_5.exception");
                            }
                            this.doRollback(translist, id, xid, xaFlags, ts, conlist, con, RollbackReason.APPLICATION);
                        }
                        catch (BrokerException ex) {
                            if (!ex.isStackLogged()) {
                                this.logger.logStack(16, ex.getMessage(), ex);
                            } else {
                                this.logger.log(16, this.br.getKString("B4428", id, ex.getMessage()));
                            }
                            if (maxrbex == null) {
                                reason = ex.getMessage();
                                status = ex.getStatusCode();
                            }
                        }
                    }
                }
                catch (BrokerException ex) {
                    reason = ex.getMessage();
                    status = ex.getStatusCode();
                }
                nextTxnID = 0L;
                if (!startNextTransaction) ** GOTO lbl339
                try {
                    nextid = new TransactionUID();
                    this.doStart(translist, nextid, conlist, con, type, xid, sessionLess, lifetime, 0L, xaFlags, 44, replay, msg.getSysMessageID().toString());
                    nextTxnID = nextid.longValue();
                }
                catch (Exception ex) {
                    this.logger.logStack(32, ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid), ex);
                    if (maxrbex != null) ** GOTO lbl339
                    status = 500;
                    reason = ex.getMessage();
                    if (!(ex instanceof BrokerException)) ** GOTO lbl339
                    status = ((BrokerException)ex).getStatusCode();
                }
lbl339:
                // 5 sources

                if (msg.getSendAcknowledge()) {
                    this.sendReply(con, msg, msg.getPacketType() + 1, status, id.longValue(), (String)reason, null, null, nextTxnID);
                    break;
                }
                if (!this.fi.FAULT_INJECTION) break;
                this.checkFIAfterProcess(msg.getPacketType());
                this.checkFIAfterReply(msg.getPacketType());
                break;
            }
        }
        return true;
    }

    public void checkFIBeforeProcess(int type) throws BrokerException {
        switch (type) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.1", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.1", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.1", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.1", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.1", null, 2, false);
                break;
            }
        }
    }

    public void checkFIAfterProcess(int type) {
        switch (type) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.2", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.2", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.2", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.2", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.2", null, 2, false);
                break;
            }
        }
    }

    public void checkFIAfterDB(int type) {
        switch (type) {
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.4", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.4", null, 2, false);
                break;
            }
        }
    }

    public void checkFIAfterReply(int type) {
        switch (type) {
            case 44: {
                this.fi.checkFaultAndExit("txn.start.3", null, 2, false);
                break;
            }
            case 58: {
                this.fi.checkFaultAndExit("txn.end.3", null, 2, false);
                break;
            }
            case 56: {
                this.fi.checkFaultAndExit("txn.prepare.3", null, 2, false);
                break;
            }
            case 48: {
                this.fi.checkFaultAndExit("txn.rollback.3", null, 2, false);
                break;
            }
            case 46: {
                this.fi.checkFaultAndExit("txn.commit.3", null, 2, false);
                break;
            }
        }
    }

    private void cacheSetState(TransactionUID id, TransactionState ts, IMQConnection con) {
        if (GlobalProperties.getGlobalProperties().TRANSACTION_DEBUG) {
            if (con == null) {
                return;
            }
            CacheHashMap<TransactionUID, TransactionState> cache = (CacheHashMap<TransactionUID, TransactionState>)con.getClientData("txncache");
            if (cache == null) {
                cache = new CacheHashMap<TransactionUID, TransactionState>(4);
                con.addClientData("txncache", cache);
            }
            cache.put(id, ts);
        }
    }

    private TransactionState cacheGetState(TransactionUID id, IMQConnection con) {
        CacheHashMap cache;
        TransactionState ts = null;
        if (GlobalProperties.getGlobalProperties().TRANSACTION_DEBUG && (cache = (CacheHashMap)con.getClientData("txncache")) != null) {
            ts = (TransactionState)cache.get(id);
        }
        return ts;
    }

    public void doCommit(TransactionList translist, TransactionUID id, JMQXid xid, Integer xaFlags, TransactionState ts, List conlist, boolean sendReply, IMQConnection con, Packet msg) throws BrokerException {
        this.doCommit(translist, id, xid, xaFlags, ts, conlist, sendReply, con, msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommit(TransactionList translist, TransactionUID id, JMQXid xid, Integer xaFlags, TransactionState ts, List conlist, boolean sendReply, IMQConnection con, Packet msg, boolean startNextTransaction) throws BrokerException {
        int status = 200;
        HashMap cmap = null;
        HashMap sToCmap = null;
        List plist = null;
        PartitionedStore pstore = translist.getPartitionedStore();
        int transactionType = 0;
        if (this.fi.checkFault("txn.commit.1.exception", null)) {
            this.fi.unsetFault("txn.commit.1.exception");
            throw new BrokerException("txn.commit.1.exception");
        }
        plist = translist.retrieveSentMessages(id);
        cmap = translist.retrieveConsumedMessages(id);
        sToCmap = translist.retrieveStoredConsumerUIDs(id);
        this.cacheSetState(id, ts, con);
        if (conlist != null) {
            conlist.remove(id);
        }
        try {
            Globals.getStore().txnLogSharedLock.lock();
            TransactionWork txnWork = null;
            if (Globals.isNewTxnLogEnabled()) {
                txnWork = this.getTransactionWork2(translist.getPartitionedStore(), plist, cmap, sToCmap);
            }
            try {
                int s = xid == null ? 6 : ts.nextState(46, xaFlags);
                BaseTransaction baseTransaction = this.doRemoteCommit(translist, id, xaFlags, ts, s, msg, txnWork, con);
                if (Globals.isNewTxnLogEnabled()) {
                    if (ts.getState() == 5) {
                        transactionType = 1;
                        if (translist.isClusterTransaction(id)) {
                            transactionType = 3;
                        }
                        this.logTxnCompletion(translist.getPartitionedStore(), id, 6, transactionType);
                    } else if (baseTransaction != null && baseTransaction.getState() == 5) {
                        transactionType = baseTransaction.getType();
                        this.logTxnCompletion(translist.getPartitionedStore(), id, 6, transactionType);
                    } else {
                        transactionType = 1;
                        LocalTransaction localTxn = new LocalTransaction(id, 6, xid, txnWork);
                        this.logTxn(translist.getPartitionedStore(), localTxn);
                    }
                }
                if (this.fi.FAULT_INJECTION) {
                    this.fi.checkFaultAndThrowBrokerException("txn.commit.1_1", null);
                }
                if (ts.getState() == 5 || baseTransaction != null && baseTransaction.getState() == 5) {
                    translist.updateState(id, s, true);
                } else if (ts.getType() != AutoRollbackType.NEVER && Globals.isMinimumPersistLevel2()) {
                    translist.updateStateCommitWithWork(id, s, true);
                } else {
                    translist.updateState(id, s, true);
                }
                if (this.fi.FAULT_INJECTION) {
                    this.checkFIAfterDB(46);
                    this.fi.checkFaultAndExit("txn.commit.1_5", null, 2, false);
                }
                this.startTxnAndSendReply(translist, con, msg, status, startNextTransaction, conlist, xid, id, xaFlags, sendReply);
            }
            catch (BrokerException ex) {
                this.logger.logStack(ex instanceof AckEntryNotFoundException ? 16 : 32, ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid), ex);
                throw ex;
            }
            try {
                Agent agent = Globals.getAgent();
                if (agent != null) {
                    agent.notifyTransactionCommit(id);
                }
            }
            catch (Exception e) {
                this.logger.log(16, "JMX agent notify transaction committed failed:" + e.getMessage());
            }
            int pLogRecordByteCount = 0;
            ArrayList<byte[]> pLogMsgList = null;
            for (int i = 0; plist != null && i < plist.size(); ++i) {
                SysMessageID sysid = (SysMessageID)plist.get(i);
                PacketReference ref = DestinationList.get(pstore, sysid);
                if (ref == null) {
                    this.logger.log(16, Globals.getBrokerResources().getKString("B2254", sysid));
                    continue;
                }
                try {
                    MessageDeliveryTimeInfo di;
                    if (Globals.txnLogEnabled()) {
                        if (pLogMsgList == null) {
                            pLogMsgList = new ArrayList<byte[]>();
                        }
                        pLogRecordByteCount = (int)((long)pLogRecordByteCount + ref.getSize());
                        pLogMsgList.add(ref.getPacket().getBytes());
                    }
                    Destination[] ds = DestinationList.getDestination(pstore, ref.getDestinationUID());
                    Destination d = ds[0];
                    if (this.fi.FAULT_INJECTION) {
                        this.fi.checkFaultAndExit("txn.commit.1_6", null, 2, false);
                    }
                    if ((di = ref.getDeliveryTimeInfo()) != null) {
                        d.routeCommittedMessageWithDeliveryTime(ref);
                        continue;
                    }
                    Set s = d.routeNewMessage(ref);
                    d.forwardMessage(s, ref);
                    continue;
                }
                catch (Exception ex) {
                    this.logger.logStack(BrokerStateHandler.isShuttingDown() ? 4 : 32, ex.getMessage() + "[" + String.valueOf(sysid) + "]TUID=" + String.valueOf(id), ex);
                }
            }
            boolean processDone = true;
            int cLogRecordCount = 0;
            ArrayList<String> cLogDstList = null;
            ArrayList<SysMessageID> cLogMsgList = null;
            ArrayList<ConsumerUID> cLogIntList = null;
            HashMap<TransactionBroker, Object> remoteNotified = new HashMap<TransactionBroker, Object>();
            if (cmap != null && cmap.size() > 0) {
                for (Map.Entry entry : cmap.entrySet()) {
                    SysMessageID sysid = (SysMessageID)entry.getKey();
                    if (sysid == null) continue;
                    PacketReference ref = DestinationList.get(null, sysid);
                    if (ref == null || ref.isDestroyed() || ref.isInvalid()) continue;
                    PartitionedStore refpstore = ref.getPartitionedStore();
                    Destination[] ds = DestinationList.getDestination(refpstore, ref.getDestinationUID());
                    Destination dst = ds[0];
                    if (dst == null && (ref.isDestroyed() || ref.isInvalid())) continue;
                    List interests = (List)entry.getValue();
                    for (int i = 0; i < interests.size(); ++i) {
                        ConsumerUID intid = (ConsumerUID)interests.get(i);
                        ConsumerUID sid = (ConsumerUID)sToCmap.get(intid);
                        if (sid == null) {
                            sid = intid;
                        }
                        try {
                            block71: {
                                Session s = Session.getSession(intid);
                                if (s != null) {
                                    Consumer c = Consumer.getConsumer(intid);
                                    if (c != null) {
                                        c.messageCommitted(sysid);
                                    }
                                    PacketReference r1 = null;
                                    if (this.fi.FAULT_INJECTION && this.fi.checkFault("txn.commit.1_7_1", null)) {
                                        Globals.getConnectionManager().getConnection(s.getConnectionUID()).destroyConnection(true, 6, "Fault injection of closing connection");
                                    }
                                    r1 = (PacketReference)s.ackMessage(intid, sysid, id, translist, remoteNotified, true);
                                    try {
                                        s.postAckMessage(intid, sysid, true);
                                        if (r1 != null) {
                                            if (this.fi.FAULT_INJECTION) {
                                                this.fi.checkFaultAndExit("txn.commit.1_7", null, 2, false);
                                            }
                                            if (dst != null) {
                                                dst.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                                            }
                                        } else {
                                            s = Session.getSession(intid);
                                        }
                                    }
                                    finally {
                                        if (r1 != null) {
                                            r1.postAcknowledgedRemoval();
                                        }
                                    }
                                }
                                if (s == null) {
                                    try {
                                        if (!ref.acknowledged(intid, sid, true, true, id, translist, remoteNotified, true)) break block71;
                                        try {
                                            if (dst != null) {
                                                dst.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                                            }
                                        }
                                        finally {
                                            ref.postAcknowledgedRemoval();
                                        }
                                    }
                                    catch (BrokerException ex) {
                                        this.logger.log(16, "Internal error", ex);
                                    }
                                }
                            }
                            if (!Globals.txnLogEnabled()) continue;
                            if (cLogDstList == null) {
                                cLogDstList = new ArrayList<String>();
                                cLogMsgList = new ArrayList<SysMessageID>();
                                cLogIntList = new ArrayList<ConsumerUID>();
                            }
                            if (dst == null || !dst.isQueue() && !sid.shouldStore()) continue;
                            ++cLogRecordCount;
                            cLogDstList.add(dst.getUniqueName());
                            cLogMsgList.add(sysid);
                            cLogIntList.add(sid);
                            continue;
                        }
                        catch (Exception ex) {
                            processDone = false;
                            Object[] args = new String[]{"[" + String.valueOf(sysid) + ":" + String.valueOf(intid) + ", " + String.valueOf(dst) + "]ref=" + String.valueOf(ref.getSysMessageID()), id.toString(), con.getConnectionUID().toString()};
                            String emsg = Globals.getBrokerResources().getKString("B2255", args);
                            this.logger.logStack(16, emsg + "\n" + PacketUtil.dumpPacket(msg) + "--------------------------------------------", ex);
                        }
                    }
                }
            }
            if (Globals.isNewTxnLogEnabled()) {
                this.loggedCommitWrittenToMessageStore(translist.getPartitionedStore(), id, transactionType);
            }
            if (this.fi.FAULT_INJECTION) {
                this.checkFIAfterDB(46);
                this.fi.checkFaultAndExit("txn.commit.2_1", null, 2, false);
            }
            translist.removeTransaction(id, !processDone || cmap.size() > 0 && BrokerStateHandler.isShuttingDown());
            if (conlist == null) {
                this.logger.log(16, "B2178", (Object)id, xid == null ? "null" : xid.toString());
            }
            try {
                if (pLogRecordByteCount > 0 && cLogRecordCount > 0) {
                    bos = new ByteArrayOutputStream(pLogRecordByteCount + cLogRecordCount * 72 + 16);
                    dos = new DataOutputStream(bos);
                    dos.writeLong(id.longValue());
                    dos.writeInt(pLogMsgList.size());
                    Iterator itr = pLogMsgList.iterator();
                    while (itr.hasNext()) {
                        dos.write((byte[])itr.next());
                    }
                    dos.writeInt(cLogRecordCount);
                    for (int i = 0; i < cLogRecordCount; ++i) {
                        String dst = (String)cLogDstList.get(i);
                        dos.writeUTF(dst);
                        SysMessageID sysid = (SysMessageID)cLogMsgList.get(i);
                        sysid.writeID(dos);
                        ConsumerUID intid = (ConsumerUID)cLogIntList.get(i);
                        dos.writeLong(intid.longValue());
                    }
                    dos.close();
                    bos.close();
                    ((TxnLoggingStore)((Object)pstore)).logTxn(4, bos.toByteArray());
                } else if (pLogRecordByteCount > 0) {
                    ByteBuffer bbuf = ByteBuffer.allocate(pLogRecordByteCount + 12);
                    bbuf.putLong(id.longValue());
                    bbuf.putInt(pLogMsgList.size());
                    Iterator itr = pLogMsgList.iterator();
                    while (itr.hasNext()) {
                        bbuf.put((byte[])itr.next());
                    }
                    ((TxnLoggingStore)((Object)pstore)).logTxn(1, bbuf.array());
                } else if (cLogRecordCount > 0) {
                    bos = new ByteArrayOutputStream(cLogRecordCount * 72 + 12);
                    dos = new DataOutputStream(bos);
                    dos.writeLong(id.longValue());
                    dos.writeInt(cLogRecordCount);
                    for (int i = 0; i < cLogRecordCount; ++i) {
                        String dst = (String)cLogDstList.get(i);
                        dos.writeUTF(dst);
                        SysMessageID sysid = (SysMessageID)cLogMsgList.get(i);
                        sysid.writeID(dos);
                        ConsumerUID intid = (ConsumerUID)cLogIntList.get(i);
                        dos.writeLong(intid.longValue());
                    }
                    dos.close();
                    bos.close();
                    ((TxnLoggingStore)((Object)pstore)).logTxn(2, bos.toByteArray());
                }
            }
            catch (IOException ex) {
                this.logger.logStack(32, "B3100", "Got exception while writing to transaction log", (Throwable)ex);
                throw new BrokerException("Got exception while writing to transaction log", ex);
            }
        }
        finally {
            Globals.getStore().txnLogSharedLock.unlock();
        }
    }

    private TransactionWork getTransactionWork2(PartitionedStore pstore, List plist, HashMap cmap, HashMap sToCmap) {
        TransactionWork txnWork = new TransactionWork();
        for (int i = 0; plist != null && i < plist.size(); ++i) {
            SysMessageID sysid = (SysMessageID)plist.get(i);
            PacketReference ref = DestinationList.get(pstore, sysid);
            if (ref == null) {
                this.logger.log(16, Globals.getBrokerResources().getKString("B2254", sysid));
                continue;
            }
            try {
                if (!ref.isPersistent()) continue;
                TransactionWorkMessage txnWorkMessage = new TransactionWorkMessage();
                Destination dest = ref.getDestination();
                txnWorkMessage.setDestUID(dest.getDestinationUID());
                txnWorkMessage.setPacketReference(ref);
                txnWork.addMessage(txnWorkMessage);
                continue;
            }
            catch (Exception ex) {
                this.logger.logStack(BrokerStateHandler.isShuttingDown() ? 4 : 32, "B3100", "unable to log transaction message " + String.valueOf(sysid), (Throwable)ex);
            }
        }
        if (cmap != null && cmap.size() > 0) {
            for (Map.Entry entry : cmap.entrySet()) {
                SysMessageID sysid = (SysMessageID)entry.getKey();
                List interests = (List)entry.getValue();
                if (sysid == null) continue;
                PacketReference ref = DestinationList.get(null, sysid);
                if (ref == null || ref.isDestroyed() || ref.isInvalid() || !ref.isLocal()) continue;
                Destination[] ds = DestinationList.getDestination(ref.getPartitionedStore(), ref.getDestinationUID());
                Destination dst = ds[0];
                for (int i = 0; i < interests.size(); ++i) {
                    ConsumerUID intid = (ConsumerUID)interests.get(i);
                    ConsumerUID sid = (ConsumerUID)sToCmap.get(intid);
                    if (sid == null) {
                        sid = intid;
                    }
                    try {
                        if (!dst.isQueue() && !sid.shouldStore() || !ref.isPersistent()) continue;
                        TransactionWorkMessageAck ack = new TransactionWorkMessageAck();
                        ack.setConsumerID(sid);
                        ack.setDest(dst.getDestinationUID());
                        ack.setSysMessageID(sysid);
                        txnWork.addMessageAcknowledgement(ack);
                        continue;
                    }
                    catch (Exception ex) {
                        this.logger.logStack(32, "B3100", " unable to log transaction message acknowledgement " + String.valueOf(sysid) + ":" + String.valueOf(intid), (Throwable)ex);
                    }
                }
            }
        }
        return txnWork;
    }

    void startTxnAndSendReply(TransactionList translist, IMQConnection con, Packet msg, int status, boolean startNextTransaction, List conlist, JMQXid xid, TransactionUID id, Integer xaFlags, boolean sendReply) {
        String reason;
        long nextTxnID;
        block4: {
            nextTxnID = 0L;
            reason = null;
            if (startNextTransaction) {
                try {
                    TransactionUID nextid = new TransactionUID();
                    this.doStart(translist, nextid, conlist, con, AutoRollbackType.NOT_PREPARED, xid, false, 0L, 0L, xaFlags, 44, false, msg.getSysMessageID().toString());
                    nextTxnID = nextid.longValue();
                }
                catch (Exception ex) {
                    status = 500;
                    this.logger.logStack(32, "B3100", ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid), (Throwable)ex);
                    reason = ex.getMessage();
                    if (!(ex instanceof BrokerException)) break block4;
                    status = ((BrokerException)ex).getStatusCode();
                }
            }
        }
        if (sendReply) {
            this.sendReply(con, msg, 47, status, id.longValue(), reason, null, null, nextTxnID);
        }
    }

    private void logTxn(PartitionedStore pstore, BaseTransaction baseTxn) throws BrokerException {
        boolean requiresLogging = this.calculateStoredRouting(pstore, baseTxn);
        if (requiresLogging || baseTxn.getState() == 5) {
            ((TxnLoggingStore)((Object)pstore)).logTxn(baseTxn);
        }
    }

    private boolean calculateStoredRouting(PartitionedStore pstore, BaseTransaction baseTxn) throws BrokerException {
        boolean sentMessagesNeedLogging = false;
        TransactionWork txnWork = baseTxn.getTransactionWork();
        List<TransactionWorkMessage> sentMessages = txnWork.getSentMessages();
        if (sentMessages != null) {
            for (TransactionWorkMessage twm : sentMessages) {
                sentMessagesNeedLogging |= this.calculateStoredRouting(pstore, twm);
            }
        }
        boolean ackedMessagesNeedLogging = false;
        List<TransactionWorkMessageAck> ackedMessages = txnWork.getMessageAcknowledgments();
        if (ackedMessages != null) {
            Iterator<TransactionWorkMessageAck> ackIter = ackedMessages.iterator();
            while (ackIter.hasNext()) {
                ackIter.next();
                ackedMessagesNeedLogging |= true;
            }
        }
        return ackedMessagesNeedLogging || sentMessagesNeedLogging;
    }

    private boolean calculateStoredRouting(PartitionedStore pstore, TransactionWorkMessage twm) throws BrokerException {
        PacketReference ref = twm.getPacketReference();
        Destination[] ds = DestinationList.getDestination(pstore, twm.getDestUID());
        Destination dest = ds[0];
        ConsumerUID[] storedInterests = null;
        if (dest == null) {
            String msg = "Could not find destination for " + String.valueOf(twm.getDestUID()) + " refDest= " + ref.getDestinationName();
            this.logger.log(32, msg);
            throw new BrokerException(msg);
        }
        try {
            storedInterests = dest.calculateStoredInterests(ref);
            twm.setStoredInterests(storedInterests);
        }
        catch (SelectorFormatException sfe) {
            throw new BrokerException("Could not route transacted message on commit", sfe);
        }
        if (storedInterests == null) {
            if (DEBUG_CLUSTER_TXN) {
                this.logger.log(8, Thread.currentThread().getName() + " stored routing = null " + String.valueOf(twm) + " persist=" + ref.isPersistent());
            }
            return false;
        }
        if (DEBUG_CLUSTER_TXN) {
            for (int i = 0; i < storedInterests.length; ++i) {
                this.logger.log(8, Thread.currentThread().getName() + " stored routing " + String.valueOf(storedInterests[i]) + " " + String.valueOf(twm));
            }
        }
        return true;
    }

    private void logTxnCompletion(PartitionedStore pstore, TransactionUID tid, int state, int type) throws BrokerException {
        ((TxnLoggingStore)((Object)pstore)).logTxnCompletion(tid, state, type);
    }

    private void loggedCommitWrittenToMessageStore(PartitionedStore pstore, TransactionUID tid, int type) {
        ((TxnLoggingStore)((Object)pstore)).loggedCommitWrittenToMessageStore(tid, type);
    }

    public void preRollback(TransactionList translist, TransactionUID id, JMQXid xid, Integer xaFlags, TransactionState ts) throws BrokerException {
        if (xid != null && ts.getState() == 1) {
            int oldstate = 1;
            try {
                ts.nextState(48, xaFlags);
                return;
            }
            catch (BrokerException e) {
                BrokerException ex = e;
                this.logger.log(32, e.getMessage());
                translist.updateState(id, 2, 1, true);
                Object[] args = new String[]{"ROLLBACK", id.toString() + "[" + TransactionState.toString(oldstate) + "]XID=", xid.toString()};
                this.logger.log(16, Globals.getBrokerResources().getKString("B2176", args));
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRollback(TransactionList translist, TransactionUID id, JMQXid xid, Integer xaFlags, TransactionState ts, List conlist, IMQConnection con, RollbackReason rbreason) throws BrokerException {
        Map m;
        int s;
        int oldstate = ts.getState();
        PartitionedStore pstore = translist.getPartitionedStore();
        try {
            if (xid == null) {
                s = 7;
            } else {
                if ((rbreason == RollbackReason.ADMIN || rbreason == RollbackReason.CONNECTION_CLEANUP) && ts.getState() == 1) {
                    ts = translist.updateState(id, 2, 1, true);
                    Object[] args = new String[]{rbreason.toString(), id.toString() + "[" + TransactionState.toString(oldstate) + "]XID=", xid.toString()};
                    if (rbreason != RollbackReason.ADMIN && (DEBUG || DEBUG_CLUSTER_TXN || this.logger.getLevel() <= 4)) {
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2176", args));
                    }
                }
                s = ts.nextState(48, xaFlags);
            }
        }
        catch (BrokerException ex) {
            if (ex.getStatusCode() == 409) {
                this.logger.log(32, ex.toString());
            } else {
                this.logger.log(32, ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid));
            }
            throw ex;
        }
        ts = translist.updateState(id, s, true);
        if (Globals.isNewTxnLogEnabled() && oldstate == 5) {
            int transactionType = 1;
            if (translist.isClusterTransaction(id)) {
                transactionType = 3;
            }
            this.logTxnCompletion(pstore, id, 7, transactionType);
        }
        if (this.fi.FAULT_INJECTION) {
            this.checkFIAfterDB(48);
        }
        boolean processDone = true;
        ArrayList list = new ArrayList(translist.retrieveSentMessages(id));
        for (int i = 0; i < list.size(); ++i) {
            PacketReference ref;
            SysMessageID sysid = (SysMessageID)list.get(i);
            if (DEBUG) {
                this.logger.log(8, "Removing " + String.valueOf(sysid) + " because of rollback");
            }
            if ((ref = DestinationList.get(null, sysid)) == null) continue;
            DestinationUID duid = ref.getDestinationUID();
            Destination[] ds = DestinationList.getDestination(ref.getPartitionedStore(), duid);
            Destination d = ds[0];
            if (d == null) continue;
            Destination.RemoveMessageReturnInfo ret = d.removeMessageWithReturnInfo(sysid, RemoveReason.ROLLBACK);
            if (!ret.storermerror) continue;
            processDone = false;
        }
        if (conlist != null) {
            conlist.remove(id);
        }
        if ((m = translist.getOrphanAck(id)) != null) {
            for (Map.Entry me : m.entrySet()) {
                SysMessageID sysid = (SysMessageID)me.getKey();
                PacketReference ref = DestinationList.get(null, sysid, false);
                if (ref == null) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "Process transaction rollback " + String.valueOf(id) + ": orphan message already removed " + String.valueOf(sysid));
                    continue;
                }
                Destination dst = ref.getDestination();
                Map sids = (Map)me.getValue();
                if (sids == null) continue;
                for (Map.Entry se : sids.entrySet()) {
                    ConsumerUID sid = (ConsumerUID)se.getKey();
                    if (ref.isLocal()) {
                        if (dst != null) {
                            dst.forwardOrphanMessage(ref, sid);
                            continue;
                        }
                        if (!DEBUG) continue;
                        this.logger.log(8, "Process transaction rollback " + String.valueOf(id) + ": orphan consumed message destination already removed " + String.valueOf(sysid));
                        continue;
                    }
                    List cids = (List)se.getValue();
                    if (cids == null) continue;
                    for (ConsumerUID cid : cids) {
                        block40: {
                            try {
                                ref.acquireDestroyRemoteReadLock();
                                try {
                                    if (!ref.isLastRemoteConsumerUID(sid, cid) || !ref.acknowledged(cid, sid, !cid.isNoAck() && !cid.isDupsOK(), false, id, translist, null, false)) break block40;
                                    try {
                                        if (dst != null) {
                                            dst.removeRemoteMessage(sysid, RemoveReason.ACKNOWLEDGED, ref);
                                        } else {
                                            this.logger.log(8, "Process transaction rollback " + String.valueOf(id) + ": orphan consumed remote message destination already removed " + String.valueOf(sysid));
                                        }
                                    }
                                    finally {
                                        ref.postAcknowledgedRemoval();
                                    }
                                }
                                finally {
                                    ref.clearDestroyRemoteReadLock();
                                }
                            }
                            catch (Exception ex) {
                                this.logger.logStack(DEBUG_CLUSTER_TXN ? 16 : 4, "Unable to cleanup orphaned remote message [" + String.valueOf(cid) + "," + String.valueOf(sid) + "," + String.valueOf(sysid) + "] on rollback transaction " + String.valueOf(id), ex);
                            }
                        }
                        BrokerAddress addr = translist.getAckBrokerAddress(id, sysid, cid);
                        try {
                            HashMap<String, String> prop = new HashMap<String, String>();
                            prop.put("RB_RELEASE_MSG_ORPHAN", id.toString());
                            Globals.getClusterBroadcast().acknowledgeMessage(addr, sysid, cid, 5, prop, false);
                        }
                        catch (BrokerException e) {
                            Globals.getLogger().log(16, "Unable to notify " + String.valueOf(addr) + " for orphaned remote message [" + String.valueOf(cid) + ", " + String.valueOf(sid) + ", , " + String.valueOf(sysid) + "] in rollback transaction " + String.valueOf(id));
                        }
                    }
                }
            }
        }
        translist.removeTransactionAck(id, true);
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyTransactionRollback(id);
        }
        try {
            ts.setState(s);
            this.cacheSetState(id, ts, con);
            this.doRemoteRollback(translist, id, s);
            translist.removeTransaction(id, !processDone);
            if (rbreason == RollbackReason.ADMIN || rbreason == RollbackReason.CONNECTION_CLEANUP) {
                Object[] args = new String[]{rbreason.toString(), id.toString() + "[" + TransactionState.toString(oldstate) + "]", xid == null ? "null" : xid.toString()};
                if (rbreason == RollbackReason.CONNECTION_CLEANUP) {
                    if (DEBUG || DEBUG_CLUSTER_TXN || this.logger.getLevel() <= 4) {
                        this.logger.log(8, Globals.getBrokerResources().getKString("B2177", args));
                    }
                } else {
                    this.logger.log(16, Globals.getBrokerResources().getKString("B2177", args));
                }
            }
        }
        catch (BrokerException ex) {
            this.logger.logStack(32, this.br.getKString("B4430", id, ex.getMessage()), ex);
            ex.setStackLogged();
            throw ex;
        }
    }

    public void redeliverUnacked(TransactionList translist, TransactionUID tid, boolean processActiveConsumers, boolean redeliver, boolean updateConsumed, int maxRollbacks, boolean dmqOnMaxRollbacks) throws BrokerException {
        HashMap cmap = null;
        HashMap sToCmap = null;
        cmap = translist.retrieveConsumedMessages(tid, true);
        sToCmap = translist.retrieveStoredConsumerUIDs(tid);
        if (DEBUG) {
            this.logger.log(8, "redeliverUnacked:tid=" + String.valueOf(tid) + ", consumed#=" + String.valueOf(cmap));
        }
        HashMap sendMap = this.sortPreprocessRetrievedMessages(cmap, sToCmap, processActiveConsumers, maxRollbacks, dmqOnMaxRollbacks, tid);
        if (DEBUG) {
            this.logger.log(8, "redeliverUnacked:tid=" + String.valueOf(tid) + ", sendMap#=" + sendMap.size());
        }
        HashMap sendMapRemoved = null;
        if (processActiveConsumers) {
            HashMap cmapRemoved = translist.retrieveRemovedConsumedMessages(tid, false);
            sendMapRemoved = this.sortPreprocessRetrievedMessages(cmapRemoved, sToCmap, processActiveConsumers, maxRollbacks, dmqOnMaxRollbacks, tid);
        }
        String deadComment = null;
        ArrayList updatedRefs = new ArrayList();
        Iterator sitr = sendMap.entrySet().iterator();
        while (sitr.hasNext()) {
            PacketReference lastref;
            String emsg;
            Map.Entry entry = sitr.next();
            ConsumerUID intid = (ConsumerUID)entry.getKey();
            ConsumerUID stored = (ConsumerUID)sToCmap.get(intid);
            if (stored == null) {
                stored = intid;
            }
            SortedSet ss = (SortedSet)entry.getValue();
            Consumer cs = Consumer.getConsumer(intid);
            if (cs != null && processActiveConsumers || updateConsumed) {
                this.updateRefsState(stored, ss, redeliver | updateConsumed, updatedRefs, tid);
            }
            if (cs == null) {
                if (!DEBUG) continue;
                this.logger.log(8, String.valueOf(tid) + ":Can not redeliver messages to " + String.valueOf(intid) + " consumer is gone");
                continue;
            }
            if (DEBUG) {
                this.logger.log(8, String.valueOf(tid) + ":Redelivering " + ss.size() + " msgs to " + String.valueOf(intid));
            }
            if (!processActiveConsumers) {
                sitr.remove();
                continue;
            }
            if (ss.size() <= 0) continue;
            if (dmqOnMaxRollbacks && (emsg = TransactionHandler.makeDeadIfMaxRollbacked(lastref = (PacketReference)ss.last(), cs, tid, maxRollbacks)) != null) {
                if (deadComment == null) {
                    deadComment = emsg;
                }
                ss.remove(lastref);
            }
            if (cs.routeMessages(ss, true)) {
                if (DEBUG) {
                    this.logger.log(8, "Sucessfully routed msgs to " + String.valueOf(cs));
                }
                sitr.remove();
                continue;
            }
            if (!DEBUG) continue;
            this.logger.log(8, "Could not route messages to " + String.valueOf(cs));
        }
        if (DEBUG) {
            this.logger.log(8, String.valueOf(tid) + ":after redeliver, " + sendMap.size() + " inactive consumers remaining");
        }
        TransactionHandler.redeliverUnackedNoConsumer(sendMap, sToCmap, redeliver, tid, translist);
        if (sendMapRemoved != null) {
            this.releaseRemovedConsumedForActiveConsumer(sendMapRemoved, sToCmap, updatedRefs, tid, translist, redeliver, updateConsumed, maxRollbacks, dmqOnMaxRollbacks);
        }
        if (deadComment != null) {
            throw new MaxConsecutiveRollbackException(deadComment);
        }
    }

    private HashMap sortPreprocessRetrievedMessages(Map cmap, Map sToCmap, boolean processActiveConsumers, int maxRollbacks, boolean dmqOnMaxRollbacks, TransactionUID tid) throws BrokerException {
        HashMap<ConsumerUID, TreeSet<PacketReference>> sendMap = new HashMap<ConsumerUID, TreeSet<PacketReference>>();
        if (cmap != null && cmap.size() > 0) {
            for (Map.Entry entry : cmap.entrySet()) {
                SysMessageID sysid = (SysMessageID)entry.getKey();
                if (sysid == null) continue;
                PacketReference ref = DestinationList.get(null, sysid, false);
                if (ref == null || ref.isDestroyed() || ref.isInvalid()) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "redeliverUnacked:tid=" + String.valueOf(tid) + ": ref=" + String.valueOf(ref) + " already deleted");
                    continue;
                }
                if (ref.isOverrided()) continue;
                List interests = (List)entry.getValue();
                for (int i = 0; i < interests.size(); ++i) {
                    Consumer cs;
                    ConsumerUID intid = (ConsumerUID)interests.get(i);
                    ConsumerUID stored = (ConsumerUID)sToCmap.get(intid);
                    if (stored == null) {
                        stored = intid;
                    }
                    if (processActiveConsumers && !dmqOnMaxRollbacks && (cs = Consumer.getConsumer(intid)) != null && !cs.addRollbackCnt(ref.getSysMessageID(), maxRollbacks)) {
                        Object[] args = new Object[]{ref, cs, tid};
                        String emsg = this.br.getKString("B4485", args);
                        this.logger.log(32, emsg);
                        throw new MaxConsecutiveRollbackException(emsg);
                    }
                    TreeSet<PacketReference> ss = (TreeSet<PacketReference>)sendMap.get(intid);
                    if (ss == null) {
                        ss = new TreeSet<PacketReference>(new RefCompare());
                        sendMap.put(intid, ss);
                    }
                    ref.removeInDelivery(stored);
                    ss.add(ref);
                }
            }
        }
        return sendMap;
    }

    private String releaseRemovedConsumedForActiveConsumer(Map sendMap, Map sToCmap, List updatedRefs, TransactionUID tid, TransactionList translist, boolean redeliver, boolean updateConsumed, int maxRollbacks, boolean dmqOnMaxRollbacks) {
        String deadComment = null;
        for (Map.Entry entry : sendMap.entrySet()) {
            PacketReference lastref;
            String emsg;
            ConsumerUID intid = (ConsumerUID)entry.getKey();
            ConsumerUID stored = (ConsumerUID)sToCmap.get(intid);
            if (stored == null) {
                stored = intid;
            }
            SortedSet ss = (SortedSet)entry.getValue();
            Consumer cs = Consumer.getConsumer(intid);
            if (cs != null || updateConsumed) {
                this.updateRefsState(stored, ss, redeliver | updateConsumed, updatedRefs, tid);
            }
            if (cs == null) continue;
            if (DEBUG) {
                this.logger.log(8, String.valueOf(tid) + ":Releasing remote " + ss.size() + " msgs to consumer " + String.valueOf(intid));
            }
            if (ss.size() <= 0) continue;
            if (dmqOnMaxRollbacks && (emsg = TransactionHandler.makeDeadIfMaxRollbacked(lastref = (PacketReference)ss.last(), cs, tid, maxRollbacks)) != null) {
                if (deadComment == null) {
                    deadComment = emsg;
                }
                ss.remove(lastref);
            }
            for (PacketReference ref : ss) {
                TransactionHandler.releaseRemoteForActiveConsumer(ref, intid, tid, translist);
            }
        }
        return deadComment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeDeadIfMaxRollbacked(PacketReference ref, Consumer consumer, TransactionUID tid, int maxRollbacks) {
        String deadComment;
        block13: {
            if (ref == null) {
                return null;
            }
            if (consumer.addRollbackCnt(ref.getSysMessageID(), maxRollbacks)) {
                return null;
            }
            Session sess = Session.getSession(consumer.getSessionUID());
            if (sess == null) {
                return null;
            }
            Logger logger = Globals.getLogger();
            deadComment = null;
            Destination d = ref.getDestination();
            Object[] args = new Object[]{ref.toString() + "[" + (d == null ? "null" : d.getUniqueName()) + "]", Consumer.MSG_MAX_CONSECUTIVE_ROLLBACKS, consumer};
            String emsg = Globals.getBrokerResources().getKString("B2260", args);
            logger.log(16, emsg);
            PacketReference deadref = null;
            try {
                try {
                    deadref = (PacketReference)sess.handleDead(consumer.getConsumerUID(), ref.getSysMessageID(), RemoveReason.UNDELIVERABLE, null, emsg, Consumer.MSG_MAX_CONSECUTIVE_ROLLBACKS);
                    deadComment = Globals.getBrokerResources().getKString("B2261", args);
                    logger.log(16, deadComment);
                }
                catch (Throwable e) {
                    logger.logStack(32, Globals.getBrokerResources().getKString("B4390", String.valueOf(ref) + (d == null ? "null" : d.getUniqueName()) + ", " + String.valueOf(consumer) + "]"), e);
                }
                if (deadref == null) break block13;
                d = deadref.getDestination();
                try {
                    if (deadref.isDead()) {
                        d.removeDeadMessage(deadref);
                        break block13;
                    }
                    d.removeMessage(deadref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                }
                catch (Exception ex) {
                    Object[] egs = new String[]{deadref.toString() + "[" + (d == null ? "null" : d.getUniqueName()) + ", " + String.valueOf(consumer) + "]", ex.getMessage()};
                    emsg = Globals.getBrokerResources().getKString("B4389", egs);
                    if (DEBUG) {
                        logger.logStack(8, emsg, ex);
                        break block13;
                    }
                    logger.log(8, emsg);
                }
            }
            finally {
                if (deadref != null) {
                    deadref.postAcknowledgedRemoval();
                }
            }
        }
        return deadComment;
    }

    private void updateRefsState(ConsumerUID storedCuid, SortedSet refs, boolean redeliver, List updatedRefs, TransactionUID tid) {
        PacketReference ref = null;
        Iterator itr = refs.iterator();
        while (itr.hasNext()) {
            try {
                ref = (PacketReference)itr.next();
                if (updatedRefs.contains(ref)) continue;
                if (redeliver) {
                    ref.consumed(storedCuid, false, false);
                } else {
                    ref.removeDelivered(storedCuid, false);
                }
                updatedRefs.add(ref);
            }
            catch (Exception ex) {
                Object[] args = new Object[]{"[" + String.valueOf(ref) + ", " + String.valueOf(storedCuid) + "]", tid, ex.getMessage()};
                this.logger.log(16, Globals.getBrokerResources().getKString("B2243", args), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redeliverUnackedNoConsumer(HashMap sendMap, HashMap sToCmap, boolean redeliver, TransactionUID tid, TransactionList translist) throws BrokerException {
        Logger logger = Globals.getLogger();
        Iterator sitr = sendMap.entrySet().iterator();
        while (sitr.hasNext()) {
            PacketReference ref;
            Map.Entry entry = sitr.next();
            ConsumerUID intid = (ConsumerUID)entry.getKey();
            ConsumerUID storedID = (ConsumerUID)sToCmap.get(intid);
            SortedSet ss = (SortedSet)entry.getValue();
            Iterator itr = ss.iterator();
            while (itr.hasNext()) {
                SysMessageID sysid;
                block28: {
                    ref = (PacketReference)itr.next();
                    sysid = ref.getSysMessageID();
                    if (ref.isLocal()) continue;
                    if (tid != null && translist != null) {
                        translist.removeOrphanAck(tid, sysid, storedID, intid);
                    }
                    try {
                        ref.acquireDestroyRemoteReadLock();
                        try {
                            if (!ref.isLastRemoteConsumerUID(storedID, intid) || !ref.acknowledged(intid, storedID, !intid.isNoAck() && !intid.isDupsOK(), false, tid, translist, null, false)) break block28;
                            try {
                                Destination d = ref.getDestination();
                                if (d != null) {
                                    d.removeRemoteMessage(sysid, RemoveReason.ACKNOWLEDGED, ref);
                                } else if (DEBUG || DEBUG_CLUSTER_TXN) {
                                    logger.log(8, "Destination " + String.valueOf(ref.getDestinationUID()) + " not found on cleanup remote message [" + String.valueOf(intid) + "," + String.valueOf(storedID) + "," + String.valueOf(ref) + "] for rollback transaction " + String.valueOf(tid) + " for inactive consumer");
                                }
                            }
                            finally {
                                ref.postAcknowledgedRemoval();
                            }
                        }
                        finally {
                            ref.clearDestroyRemoteReadLock();
                        }
                    }
                    catch (Exception ex) {
                        logger.logStack(DEBUG_CLUSTER_TXN ? 16 : 4, "Unable to cleanup remote message [" + String.valueOf(intid) + "," + String.valueOf(storedID) + "," + String.valueOf(sysid) + "] on rollback transaction " + String.valueOf(tid) + " for inactive consumer.", ex);
                    }
                }
                BrokerAddress addr = null;
                addr = tid != null && translist != null ? translist.getAckBrokerAddress(tid, sysid, intid) : ref.getBrokerAddress();
                try {
                    HashMap<String, String> prop = new HashMap<String, String>();
                    if (tid != null) {
                        prop.put("RB_RELEASE_MSG_INACTIVE", tid.toString());
                    } else {
                        prop.put("RC_RELEASE_MSG_INACTIVE", "");
                    }
                    Globals.getClusterBroadcast().acknowledgeMessage(addr, sysid, intid, 5, prop, false);
                }
                catch (BrokerException e) {
                    Globals.getLogger().log(16, "Unable to notify " + String.valueOf(addr) + " for remote message [" + String.valueOf(intid) + ", " + String.valueOf(storedID) + ", , " + String.valueOf(sysid) + "] in " + (String)(tid != null ? "rollback transaction " + String.valueOf(tid) : "recover") + " for inactive consumer.");
                }
                itr.remove();
            }
            if (storedID == null || intid == storedID) {
                sitr.remove();
                continue;
            }
            if (ss.isEmpty()) {
                if (!DEBUG) continue;
                logger.log(8, "redeliverUnackedNoConsuemr: empty local message set for consumer " + String.valueOf(intid) + "[storedID=" + String.valueOf(storedID) + "]");
                continue;
            }
            if (storedID == PacketReference.getQueueUID()) {
                Destination d;
                ref = (PacketReference)ss.first();
                if (ref == null) {
                    if (!DEBUG) continue;
                    logger.log(8, "Internal Error:  null reterence");
                    continue;
                }
                if (!redeliver) {
                    ref.removeDelivered(storedID, false);
                }
                if ((d = ref.getDestination()) == null) {
                    if (!DEBUG) continue;
                    logger.log(8, "Destination " + String.valueOf(ref.getDestinationUID()) + " not found for reference: " + String.valueOf(ref));
                    continue;
                }
                try {
                    d.forwardOrphanMessages(ss, storedID);
                    sitr.remove();
                }
                catch (Exception ex) {
                    logger.log(8, "Internal Error: Unable to re-queue message  to queue " + String.valueOf(d), ex);
                }
                continue;
            }
            Consumer cs = Consumer.getConsumer(storedID);
            if (cs == null) {
                if (!DEBUG) continue;
                logger.log(8, "Internal Error:  unknown consumer " + String.valueOf(storedID));
                continue;
            }
            if (ss.isEmpty() || !cs.routeMessages(ss, true)) continue;
            sitr.remove();
        }
        if (DEBUG && sendMap.size() > 0) {
            logger.log(8, String.valueOf(tid) + ":after all processing, " + sendMap.size() + " inactive consumers remaining");
        }
    }

    public static void releaseRemoteForActiveConsumer(PacketReference ref, ConsumerUID intid, TransactionUID tid, TransactionList translist) {
        Consumer c = Consumer.getConsumer(intid);
        if (c == null) {
            return;
        }
        if (ref == null || ref.isLocal()) {
            return;
        }
        SysMessageID sysid = ref.getSysMessageID();
        BrokerAddress addr = null;
        try {
            addr = translist.getAckBrokerAddress(tid, sysid, intid);
        }
        catch (BrokerException e) {
            if (DEBUG) {
                Object[] args = new Object[]{"null", tid, sysid, "[" + String.valueOf(intid) + ", " + String.valueOf(c.getStoredConsumerUID()) + "]", e.getMessage()};
                Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B4486", args));
                Globals.getLogger().log(8, e.getMessage());
            }
            return;
        }
        try {
            Object[] args = new Object[]{addr, tid, sysid, "[" + String.valueOf(intid) + ", " + String.valueOf(c.getStoredConsumerUID()) + "]"};
            Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1515", args));
            HashMap<String, String> prop = new HashMap<String, String>();
            prop.put("RB_RELEASE_MSG_ACTIVE", tid.toString());
            Globals.getClusterBroadcast().acknowledgeMessage(addr, sysid, intid, 5, prop, false);
        }
        catch (BrokerException e) {
            Object[] args = new Object[]{addr, tid, sysid, "[" + String.valueOf(intid) + ", " + String.valueOf(c.getStoredConsumerUID()) + "]", e.getMessage()};
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B4486", args));
        }
    }

    public void doPrepare(TransactionList translist, TransactionUID id, Integer xaFlags, TransactionState ts, int pktType, IMQConnection con) throws BrokerException {
        this.doPrepare(translist, id, xaFlags, ts, pktType, false, null, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseTransaction doPrepare(TransactionList translist, TransactionUID id, Integer xaFlags, TransactionState ts, int pktType, boolean onephasePrepare, TransactionWork txnWork, IMQConnection con) throws BrokerException {
        BaseTransaction baseTransaction = null;
        boolean persist = true;
        PartitionedStore pstore = translist.getPartitionedStore();
        if (Globals.isNewTxnLogEnabled()) {
            persist = false;
            if (txnWork == null) {
                List plist = translist.retrieveSentMessages(id);
                HashMap cmap = translist.retrieveConsumedMessages(id);
                HashMap sToCmap = translist.retrieveStoredConsumerUIDs(id);
                txnWork = this.getTransactionWork2(pstore, plist, cmap, sToCmap);
            }
        }
        boolean prepared = false;
        int s = ts.nextState(pktType, xaFlags);
        try {
            TransactionState nextState = new TransactionState(ts);
            nextState.setState(s);
            nextState.setOnephasePrepare(true);
            baseTransaction = this.doRemotePrepare(translist, id, nextState, txnWork);
            if (baseTransaction == null && Globals.isNewTxnLogEnabled()) {
                baseTransaction = new LocalTransaction();
                baseTransaction.setTransactionWork(txnWork);
                baseTransaction.setTransactionState(nextState);
                baseTransaction.getTransactionDetails().setTid(id);
                baseTransaction.getTransactionDetails().setXid(ts.getXid());
                baseTransaction.getTransactionDetails().setState(5);
                this.logTxn(pstore, baseTransaction);
            }
            if (ts.getType() != AutoRollbackType.NEVER && Globals.isMinimumPersistLevel2()) {
                translist.updateStatePrepareWithWork(id, s, onephasePrepare, persist);
            } else {
                translist.updateState(id, s, onephasePrepare, persist);
            }
            prepared = true;
            if (this.fi.FAULT_INJECTION) {
                if (this.fi.checkFault("txn.prepare.3_kill_client", null)) {
                    this.fi.unsetFault("txn.prepare.3_kill_client");
                    p = new Properties();
                    p.setProperty("kill.jvm", "true");
                    try {
                        DebugHandler.sendClientDEBUG(con, new Hashtable(), p);
                    }
                    catch (IOException e) {
                        this.logger.log(16, "TransactionHandler: Unable to sendClientDEBUG: e.toString()");
                    }
                } else if (this.fi.checkFault("txn.prepare.3_close_client", null)) {
                    this.fi.unsetFault("txn.prepare.3_close_client");
                    p = new Properties();
                    p.setProperty("close.conn", "true");
                    try {
                        DebugHandler.sendClientDEBUG(con, new Hashtable(), p);
                    }
                    catch (IOException e) {
                        this.logger.log(16, "TransactionHandler: Unable to sendClientDEBUG: e.toString()");
                    }
                }
                this.fi.checkFaultAndExit("txn.prepare.2_0", null, 2, false);
            }
            try {
                Agent agent = Globals.getAgent();
                if (agent != null) {
                    agent.notifyTransactionPrepare(id);
                }
            }
            catch (Throwable t) {
                this.logger.log(16, "XXXI18N - JMX agent notify transaction prepared failed: " + t.getMessage());
            }
        }
        finally {
            if (!prepared) {
                translist.updateState(id, 2, onephasePrepare, 5, persist);
            }
        }
        return baseTransaction;
    }

    private ClusterTransaction doRemotePrepare(TransactionList translist, TransactionUID id, TransactionState nextState, TransactionWork txnWork) throws BrokerException {
        if (nextState.getState() != 5) {
            throw new BrokerException("Unexpected state " + String.valueOf(nextState) + " for transactionID:" + String.valueOf(id));
        }
        HashMap[] rets = this.retrieveConsumedRemoteMessages(translist, id, false);
        if (DEBUG_CLUSTER_TXN) {
            this.logger.log(8, "doRemotePrepare(" + String.valueOf(translist) + ", " + String.valueOf(id) + "): retrievedConsumedRemoteMsgs:" + (String)(rets == null ? "null" : String.valueOf(rets[0]) + ", " + String.valueOf(rets[1])));
        }
        if (this.fi.FAULT_INJECTION) {
            if (this.fi.checkFault("msg.remote_ack.c.txnprepare.0_5", null)) {
                this.fi.unsetFault("msg.remote_ack.c.txnprepare.0_5");
                throw new BrokerException("msg.remote_ack.c.txnprepare.0_5");
            }
        }
        if (rets == null) {
            return null;
        }
        if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
            return null;
        }
        HashMap bmmap = rets[0];
        TransactionBroker[] tranbas = rets[1].keySet().toArray(new TransactionBroker[rets[1].size()]);
        BrokerAddress[] bas = bmmap.keySet().toArray(new BrokerAddress[bmmap.size()]);
        boolean persist = true;
        ClusterTransaction clusterTransaction = null;
        if (Globals.isNewTxnLogEnabled()) {
            clusterTransaction = new ClusterTransaction(id, nextState, txnWork, tranbas);
            translist.logClusterTransaction(id, nextState, tranbas, true, persist, clusterTransaction);
        } else {
            translist.logClusterTransaction(id, nextState, tranbas, true, persist);
        }
        if (DEBUG_CLUSTER_TXN) {
            StringBuilder buf = new StringBuilder();
            buf.append("Preparing transaction ").append(id).append(", brokers");
            for (TransactionBroker tranba : tranbas) {
                buf.append("\n\t").append(tranba);
            }
            this.logger.log(8, buf.toString());
        }
        UID tranpid = null;
        Globals.getDestinationList();
        if (DestinationList.isPartitionMode()) {
            tranpid = translist.getPartitionedStore().getPartitionID();
            ArrayList mcl = null;
            TransactionBroker tba = null;
            UID tbapid = null;
            TransactionAcknowledgement[] tas = null;
            TransactionList tl = null;
            for (int i = 0; i < tranbas.length; ++i) {
                tba = tranbas[i];
                if (!tba.getBrokerAddress().equals(Globals.getMyAddress()) || (tbapid = tba.getBrokerAddress().getStoreSessionUID()).equals(tranpid)) continue;
                mcl = (ArrayList)rets[1].get(tba);
                tas = mcl.toArray(new TransactionAcknowledgement[mcl.size()]);
                tl = TransactionList.getTransListByPartitionID(tbapid);
                if (tl == null) {
                    throw new BrokerException("Can't prepare transaction " + String.valueOf(id) + " because transaction list for partition " + String.valueOf(tbapid) + " not found");
                }
                BrokerAddress home = (BrokerAddress)Globals.getMyAddress().clone();
                home.setStoreSessionUID(tranpid);
                tl.logLocalRemoteTransaction(id, nextState, tas, home, false, true, persist);
            }
        }
        ArrayList[] mcll = null;
        BrokerAddress ba = null;
        for (int i = 0; i < bas.length; ++i) {
            ba = bas[i];
            if (ba == Globals.getMyAddress() || ba.equals(Globals.getMyAddress())) continue;
            mcll = (ArrayList[])bmmap.get(ba);
            try {
                Globals.getClusterBroadcast().acknowledgeMessage2P(ba, mcll[0].toArray(new SysMessageID[mcll[0].size()]), mcll[1].toArray(new ConsumerUID[mcll[1].size()]), 8, null, id.longValue(), tranpid, true, false);
                continue;
            }
            catch (BrokerException e) {
                ConsumerUID uid;
                SysMessageID sysid;
                int j;
                if (!(e instanceof BrokerDownException) && !(e instanceof AckEntryNotFoundException)) {
                    throw e;
                }
                HashMap sToCmap = translist.retrieveStoredConsumerUIDs(id);
                ArrayList<String> remoteConsumerUIDa = new ArrayList<String>();
                StringBuilder remoteConsumerUIDs = new StringBuilder();
                String uidstr = null;
                StringBuilder debugbuf = new StringBuilder();
                for (j = 0; j < mcll[0].size(); ++j) {
                    sysid = (SysMessageID)mcll[0].get(j);
                    uid = (ConsumerUID)mcll[1].get(j);
                    ConsumerUID suid = (ConsumerUID)sToCmap.get(uid);
                    if (suid == null || suid.equals(uid)) continue;
                    if (e.isRemote() && !remoteConsumerUIDa.contains(uidstr = String.valueOf(uid.longValue()))) {
                        remoteConsumerUIDa.add(uidstr);
                        remoteConsumerUIDs.append(uidstr);
                        remoteConsumerUIDs.append(' ');
                        Consumer c = Consumer.getConsumer(uid);
                        if (c != null) {
                            c.recreationRequested();
                        } else {
                            this.logger.log(16, "Consumer " + String.valueOf(uid) + " not found in processing remote exception on preparing transaction " + String.valueOf(id));
                        }
                    }
                    debugbuf.append("\n\t[").append(sysid).append(':').append(uid).append(']');
                }
                if (e.isRemote()) {
                    e.setRemoteConsumerUIDs(remoteConsumerUIDs.toString());
                    if (DEBUG_CLUSTER_TXN) {
                        this.logger.log(8, "doRemotePrepare: JMQRemote Exception:remoteConsumerUIDs=" + String.valueOf(remoteConsumerUIDs) + ", remote broker " + String.valueOf(ba));
                    }
                }
                try {
                    translist.updateState(id, 2, false, 5, true);
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "Unable to update transaction " + String.valueOf(id) + " state to FAILED on PREPARE failure from " + String.valueOf(ba) + ": " + ex.getMessage() + debugbuf.toString(), ex);
                    throw e;
                }
                if (e instanceof AckEntryNotFoundException) {
                    mcll = ((AckEntryNotFoundException)e).getAckEntries();
                }
                for (j = 0; j < mcll[0].size(); ++j) {
                    ConsumerUID suid;
                    sysid = (SysMessageID)mcll[0].get(j);
                    uid = (ConsumerUID)mcll[1].get(j);
                    boolean remove = true;
                    if (e instanceof BrokerDownException && ((suid = (ConsumerUID)sToCmap.get(uid)) == null || suid.equals(uid))) {
                        if (DEBUG_CLUSTER_TXN) {
                            this.logger.log(8, "doRemotePrepare: no remove txnack " + String.valueOf(sysid) + ", " + String.valueOf(uid) + " for BrokerDownException from " + String.valueOf(ba));
                        }
                        remove = false;
                    }
                    if (!remove) continue;
                    try {
                        translist.removeAcknowledgement(id, sysid, uid, e instanceof AckEntryNotFoundException);
                        if (!DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "doRemotePrepare: removed txnack " + String.valueOf(sysid) + ", " + String.valueOf(uid) + " for BrokerDownException from " + String.valueOf(ba));
                        continue;
                    }
                    catch (Exception ex) {
                        this.logger.logStack(16, "Unable to remove transaction " + String.valueOf(id) + " ack [" + String.valueOf(sysid) + ":" + String.valueOf(uid) + "] on PREPARE failure from " + String.valueOf(ba) + ": " + ex.getMessage(), ex);
                    }
                }
                this.logger.log(16, "Preparing transaction " + String.valueOf(id) + " failed from " + String.valueOf(ba) + ": " + e.getMessage() + debugbuf.toString());
                throw e;
            }
        }
        return clusterTransaction;
    }

    private void doRemoteRollback(TransactionList translist, TransactionUID id, int nextState) throws BrokerException {
        if (nextState != 7) {
            throw new BrokerException("Unexpected state " + nextState + " for transactionUID:" + String.valueOf(id));
        }
        if (!translist.hasRemoteBroker(id)) {
            return;
        }
        if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
            return;
        }
        TransactionBroker[] bas = null;
        try {
            bas = translist.getClusterTransactionBrokers(id);
            if (DEBUG_CLUSTER_TXN) {
                StringBuilder buf = new StringBuilder();
                buf.append("Rollback transaction ").append(id).append(", remote brokers");
                for (TransactionBroker ba : bas) {
                    buf.append("\n\t").append(ba);
                }
                this.logger.log(8, buf.toString());
            }
            BrokerAddress addr = null;
            UID tranpid = null;
            Globals.getDestinationList();
            if (DestinationList.isPartitionMode()) {
                tranpid = translist.getPartitionedStore().getPartitionID();
            }
            for (int i = 0; i < bas.length; ++i) {
                Globals.getDestinationList();
                if (!DestinationList.isPartitionMode() ? bas[i].getBrokerAddress() == Globals.getMyAddress() : tranpid.equals(bas[i].getBrokerAddress().getStoreSessionUID())) continue;
                addr = bas[i].getCurrentBrokerAddress();
                if (addr == Globals.getMyAddress()) {
                    if (DEBUG_CLUSTER_TXN) {
                        this.logger.log(8, "Transaction remote broker current address " + bas[i].toString() + " is my address, TUID=" + String.valueOf(id));
                    }
                } else if (DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Transaction remote broker current address " + String.valueOf(addr) + ", TUID=" + String.valueOf(id));
                }
                try {
                    if (addr == null) {
                        throw new BrokerDownException(this.br.getKString("B4205", bas[i]), 410);
                    }
                    Globals.getClusterBroadcast().acknowledgeMessage2P(addr, null, null, 9, null, id.longValue(), tranpid, false, false);
                    continue;
                }
                catch (BrokerException e) {
                    String emsg = this.br.getKString("B2271", bas[i], id);
                    if (e.getStatusCode() == 410 || e.getStatusCode() == 408 || e instanceof BrokerDownException) {
                        this.logger.log(16, emsg + ": " + e.getMessage());
                        continue;
                    }
                    this.logger.logStack(16, emsg, e);
                }
            }
        }
        catch (Exception e) {
            StringBuilder buf = new StringBuilder();
            if (bas != null) {
                for (TransactionBroker ba : bas) {
                    buf.append("\n\t").append(ba);
                }
            }
            String emsg = this.br.getKString("B2272", buf.toString(), id);
            this.logger.logStack(16, emsg, e);
        }
    }

    private BaseTransaction doRemoteCommit(TransactionList translist, TransactionUID id, Integer xaFlags, TransactionState ts, int nextState, Packet msg, TransactionWork txnWork, IMQConnection con) throws BrokerException {
        if (nextState != 6) {
            throw new BrokerException("Unexpected next state: " + nextState + " for transaction " + String.valueOf(id));
        }
        BaseTransaction baseTransaction = null;
        if (ts.getState() != 5 && this.retrieveConsumedRemoteMessages(translist, id, true) != null) {
            if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                return null;
            }
            Packet p = new Packet();
            try {
                p.fill(msg);
            }
            catch (IOException e) {
                this.logger.logStack(8, "Internal Exception processing packet ", e);
                throw new BrokerException(e.getMessage(), e);
            }
            p.setPacketType(56);
            if (ts.getState() == 1 && ts.getXid() == null) {
                ts.setState(4);
                xaFlags = 0;
            }
            baseTransaction = this.doPrepare(translist, id, xaFlags, ts, p.getPacketType(), true, txnWork, con);
        }
        return baseTransaction;
    }

    private HashMap[] retrieveConsumedRemoteMessages(TransactionList translist, TransactionUID id, boolean checkOnly) throws BrokerException {
        HashMap mcmap = translist.retrieveConsumedMessages(id);
        HashMap sToCmap = translist.retrieveStoredConsumerUIDs(id);
        if (DEBUG_CLUSTER_TXN) {
            this.logger.log(8, "retrieveConsumedRemoteMessages(" + String.valueOf(translist) + ",TID=" + String.valueOf(id) + ") retrieveConsumedMessages: " + String.valueOf(mcmap));
        }
        if (mcmap == null || mcmap.size() == 0) {
            return null;
        }
        HashMap[] rets = new HashMap[2];
        HashMap<BrokerAddress, Object[]> bmmap = new HashMap<BrokerAddress, Object[]>();
        HashMap tbmmap = new HashMap();
        Object[] bmcll = null;
        ArrayList<TransactionAcknowledgement> tbmcl = null;
        boolean hasRemote = false;
        BrokerAddress myba = Globals.getMyAddress();
        UID tranpid = translist.getPartitionedStore().getPartitionID();
        UID refpid = null;
        ConsumerUID cuid = null;
        ConsumerUID scuid = null;
        TransactionAcknowledgement ta = null;
        Iterator itr = mcmap.entrySet().iterator();
        Map.Entry pair = null;
        while (itr.hasNext()) {
            int i;
            List interests;
            pair = itr.next();
            SysMessageID sysid = (SysMessageID)pair.getKey();
            if (sysid == null) continue;
            PacketReference ref = DestinationList.get(null, sysid, false);
            if (this.checkRefRequeued(translist, id, ref, sysid)) {
                BrokerException bex = new BrokerException(Globals.getBrokerResources().getKString("B4298", sysid) + ", TUID=" + String.valueOf(id), 410);
                bex.setRemote(true);
                StringBuilder buf = new StringBuilder();
                interests = (List)pair.getValue();
                for (i = 0; i < interests.size(); ++i) {
                    buf.append(String.valueOf(((ConsumerUID)interests.get(i)).longValue()));
                    buf.append(' ');
                }
                bex.setRemoteConsumerUIDs(buf.toString());
                throw bex;
            }
            if (ref == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4297", sysid) + ", TUID=" + String.valueOf(id), 409);
            }
            BrokerAddress ba = ref.getBrokerAddress();
            if (ba == null) {
                TransactionHandler transactionHandler = this;
                if (!transactionHandler.DL.isPartitionMode()) {
                    ba = myba;
                } else {
                    refpid = ref.getPartitionedStore().getPartitionID();
                    ba = (BrokerAddress)myba.clone();
                    ba.setStoreSessionUID(refpid);
                    if (!refpid.equals(tranpid)) {
                        hasRemote = true;
                    }
                }
            } else if (!hasRemote) {
                hasRemote = true;
            }
            if (hasRemote && checkOnly) {
                return rets;
            }
            TransactionBroker tba = new TransactionBroker(ba);
            bmcll = (ArrayList[])bmmap.get(tba.getBrokerAddress());
            tbmcl = (ArrayList<TransactionAcknowledgement>)tbmmap.get(tba);
            if (bmcll == null) {
                bmcll = new ArrayList[]{new ArrayList(), new ArrayList()};
                bmmap.put(tba.getBrokerAddress(), bmcll);
            }
            if (tbmcl == null) {
                tbmcl = new ArrayList<TransactionAcknowledgement>();
                tbmmap.put(tba, tbmcl);
            }
            interests = (List)mcmap.get(sysid);
            for (i = 0; i < interests.size(); ++i) {
                cuid = (ConsumerUID)interests.get(i);
                bmcll[0].add(sysid);
                ((ArrayList)bmcll[1]).add(cuid);
                scuid = (ConsumerUID)sToCmap.get(cuid);
                ta = new TransactionAcknowledgement(sysid, cuid, scuid);
                if (!scuid.shouldStore() || !ref.isPersistent()) {
                    ta.setShouldStore(false);
                }
                tbmcl.add(ta);
            }
            if (!DEBUG_CLUSTER_TXN) continue;
            this.logger.log(8, "retrieveConsumedRemoteMessages() for broker " + String.valueOf(tba) + ": " + Arrays.toString(bmcll) + ", " + String.valueOf(tbmcl));
        }
        if (!hasRemote) {
            return null;
        }
        rets[0] = bmmap;
        rets[1] = tbmmap;
        return rets;
    }

    private boolean checkRefRequeued(TransactionList translist, TransactionUID id, PacketReference ref, SysMessageID sysid) throws BrokerException {
        HashMap addrmap = translist.retrieveAckBrokerAddresses(id);
        BrokerAddress oldAddr = (BrokerAddress)addrmap.get(sysid);
        if (ref == null) {
            if (DestinationList.isLocked(null, sysid)) {
                this.logger.log(16, "Message " + String.valueOf(sysid) + (String)(oldAddr == null ? "" : " (" + String.valueOf(oldAddr) + ")") + " is in takeover, TUID=" + String.valueOf(id));
                return true;
            }
        }
        if (ref == null) {
            this.logger.log(16, Globals.getBrokerResources().getKString("B4297", sysid) + " " + (String)(oldAddr == null ? "" : " (" + String.valueOf(oldAddr) + ")") + ", TUID=" + String.valueOf(id));
            return false;
        }
        if (ref.isOverrided()) {
            return true;
        }
        BrokerAddress currAddr = ref.getBrokerAddress();
        if (oldAddr == null && currAddr == null) {
            return false;
        }
        if (oldAddr == null && currAddr != null || oldAddr != null && currAddr == null) {
            return true;
        }
        if (!oldAddr.equals(currAddr)) {
            return true;
        }
        UID oldUID = oldAddr.getBrokerSessionUID();
        UID currUID = currAddr.getBrokerSessionUID();
        if (oldUID == null || currUID == null) {
            return false;
        }
        return !oldUID.equals(currUID);
    }

    public void doStart(TransactionList translist, TransactionUID id, List conlist, IMQConnection con, AutoRollbackType type, JMQXid xid, boolean sessionLess, long lifetime, long messagetid, Integer xaFlags, int pktType, boolean replay, String creatorID) throws BrokerException {
        HashMap tidMap = (HashMap)con.getClientData("tidmap");
        int status = 0;
        String reason = null;
        TransactionState ts = null;
        ts = translist.retrieveState(id);
        if (type == AutoRollbackType.NEVER || lifetime > 0L) {
            status = 501;
            reason = "AutoRollbackType of NEVER not supported";
            throw new BrokerException(reason, status);
        }
        if (xid != null && !sessionLess) {
            status = 501;
            reason = "XA transactions only supported on sessionless connections";
            throw new BrokerException(reason, status);
        }
        if (xid == null && sessionLess) {
            status = 500;
            reason = "non-XA transactions only supported on  non-sessionless connections";
            throw new BrokerException(reason, status);
        }
        if (!replay) {
            if (xaFlags != null && !TransactionState.isFlagSet(0, xaFlags)) {
                int s = ts.nextState(pktType, xaFlags);
                translist.updateState(id, s, true);
            } else {
                try {
                    if (con.getClientProtocolVersion() == 100) {
                        tidMap.put(messagetid, id);
                    }
                    if (xid != null && type == null) {
                        type = TransactionList.AUTO_ROLLBACK ? AutoRollbackType.ALL : AutoRollbackType.NOT_PREPARED;
                    }
                    ts = new TransactionState(type, lifetime, sessionLess);
                    ts.setState(1);
                    ts.setUser(con.getUserName());
                    ts.setCreator(creatorID);
                    ts.setClientID((String)con.getClientData("client id"));
                    ts.setXid(xid);
                    ts.setConnectionString(con.userReadableString());
                    ts.setConnectionUID(con.getConnectionUID());
                    translist.addTransactionID(id, ts);
                    conlist.add(id);
                }
                catch (BrokerException ex) {
                    this.logger.log(32, "Exception starting new transaction: " + ex.toString(), ex);
                    throw ex;
                }
            }
        }
    }

    public void doEnd(TransactionList translist, int pktType, JMQXid xid, Integer xaFlags, TransactionState ts, TransactionUID id) throws BrokerException {
        String reason = null;
        boolean elogged = false;
        try {
            int s;
            try {
                s = ts.nextState(pktType, xaFlags);
            }
            catch (BrokerException e) {
                if (e.getStatusCode() == 304) {
                    elogged = true;
                    this.logger.log(16, e.getMessage() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid));
                }
                throw e;
            }
            if (ts.getType() != AutoRollbackType.NEVER && Globals.isMinimumPersist() || Globals.isNewTxnLogEnabled()) {
                translist.updateState(id, s, false);
            } else {
                translist.updateState(id, s, true);
            }
        }
        catch (Exception ex) {
            int status = 500;
            if (!elogged) {
                this.logger.logStack(32, ex.toString() + ": TUID=" + String.valueOf(id) + " Xid=" + String.valueOf(xid), ex);
            }
            reason = ex.getMessage();
            if (ex instanceof BrokerException) {
                status = ((BrokerException)ex).getStatusCode();
            }
            throw new BrokerException(reason, status);
        }
    }
}

