/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import java.math.BigInteger;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class IssuerNameAndSerialCertSelector
implements CertSelector {
    private final BigInteger serialNumber;
    private final String issuerName;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public IssuerNameAndSerialCertSelector(BigInteger serialNum, String issuer) {
        this.serialNumber = serialNum;
        this.issuerName = issuer;
    }

    @Override
    public boolean match(Certificate cert) {
        if (cert instanceof X509Certificate) {
            return this.matchesIssuerSerialAndName(this.serialNumber, this.issuerName, (X509Certificate)cert);
        }
        return false;
    }

    @Override
    public Object clone() {
        return new IssuerNameAndSerialCertSelector(this.serialNumber, this.issuerName);
    }

    private boolean matchesIssuerSerialAndName(BigInteger serialNumberMatch, String issuerNameMatch, X509Certificate x509Cert) {
        X500Principal thisIssuerPrincipal = x509Cert.getIssuerX500Principal();
        X500Principal issuerPrincipal = new X500Principal(this.issuerName);
        BigInteger thisSerialNumber = x509Cert.getSerialNumber();
        return this.serialNumber.equals(serialNumberMatch) && issuerPrincipal.equals(thisIssuerPrincipal);
    }
}

