/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.html;

import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import java.util.ArrayList;
import java.util.Map;

class HtmlComponentUtils {
    private static final String ATTRIBUTES_THAT_ARE_SET = "jakarta.faces.component.UIComponentBase.attributesThatAreSet";
    private static final String OPTIMIZED_PACKAGE = "jakarta.faces.component.";

    HtmlComponentUtils() {
    }

    static void handleAttribute(UIComponent component, String name, Object value) {
        String className;
        Map<String, Object> attributes = component.getAttributes();
        ArrayList<String> setAttributes = (ArrayList<String>)attributes.get(ATTRIBUTES_THAT_ARE_SET);
        if (setAttributes == null && (className = component.getClass().getName()).startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            attributes.put(ATTRIBUTES_THAT_ARE_SET, setAttributes);
        }
        if (setAttributes != null) {
            if (value == null) {
                ValueExpression ve = component.getValueExpression(name);
                if (ve == null) {
                    setAttributes.remove(name);
                }
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }
}

