/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.layout.RenderKitUtil;
import com.sun.jsftemplating.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.StateManagementStrategy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class LayoutStateManagementStrategy
extends StateManagementStrategy {
    private final Map<String, Class<?>> classMap = new ConcurrentHashMap(32);

    private void captureChild(List<TreeNode> tree, int parent, UIComponent component) {
        if (!component.isTransient()) {
            TreeNode treeNode = new TreeNode(parent, component);
            int position = tree.size();
            tree.add(treeNode);
            this.captureRest(tree, position, component);
        }
    }

    private void captureFacet(List<TreeNode> tree, int parent, String name, UIComponent component) {
        if (!component.isTransient()) {
            FacetNode facetNode = new FacetNode(parent, name, component);
            int position = tree.size();
            tree.add(facetNode);
            this.captureRest(tree, position, component);
        }
    }

    private void captureRest(List<TreeNode> tree, int position, UIComponent component) {
        int size = component.getChildCount();
        if (size > 0) {
            List children = component.getChildren();
            for (int i = 0; i < size; ++i) {
                this.captureChild(tree, position, (UIComponent)children.get(i));
            }
        }
        if ((size = component.getFacetCount()) > 0) {
            for (Map.Entry facetEntry : component.getFacets().entrySet()) {
                this.captureFacet(tree, position, (String)facetEntry.getKey(), (UIComponent)facetEntry.getValue());
            }
        }
    }

    private UIComponent createComponent(TreeNode treeNode) throws FacesException {
        try {
            Class componentClass = this.classMap.get(treeNode.componentType);
            if (componentClass == null) {
                componentClass = Util.loadClass(treeNode.componentType, treeNode);
                this.classMap.put(treeNode.componentType, componentClass);
            }
            UIComponent component = (UIComponent)componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            component.setId(treeNode.id);
            return component;
        }
        catch (ReflectiveOperationException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private UIViewRoot restoreTree(FacesContext facesContext, String renderKitId, Object[] tree) throws FacesException {
        for (int i = 0; i < tree.length; ++i) {
            UIComponent component;
            if (tree[i] instanceof FacetNode) {
                FacetNode facetNode = (FacetNode)tree[i];
                component = this.createComponent(facetNode);
                tree[i] = component;
                if (i == facetNode.getParent()) continue;
                ((UIComponent)tree[facetNode.getParent()]).getFacets().put(facetNode.facetName, component);
                continue;
            }
            TreeNode treeNode = (TreeNode)tree[i];
            component = this.createComponent(treeNode);
            tree[i] = component;
            if (i != treeNode.parent) {
                ((UIComponent)tree[treeNode.parent]).getChildren().add(component);
                continue;
            }
            UIViewRoot viewRoot = (UIViewRoot)component;
            facesContext.setViewRoot(viewRoot);
            viewRoot.setRenderKitId(renderKitId);
        }
        return (UIViewRoot)tree[0];
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId, String renderKitId) {
        UIViewRoot viewRoot = null;
        ResponseStateManager responseStateManager = RenderKitUtil.getRenderKit(facesContext, renderKitId).getResponseStateManager();
        Object[] state = (Object[])responseStateManager.getState(facesContext, viewId);
        if (state != null && state.length >= 2) {
            if (state[0] != null) {
                viewRoot = this.restoreTree(facesContext, renderKitId, (Object[])((Object[])state[0]).clone());
                facesContext.setViewRoot(viewRoot);
            }
            if (viewRoot != null && state[1] != null) {
                viewRoot.processRestoreState(facesContext, state[1]);
            }
        }
        return viewRoot;
    }

    public Object saveView(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        LayoutStateManagementStrategy.checkIdUniqueness(facesContext, (UIComponent)viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
        Object state = viewRoot.processSaveState(facesContext);
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>(32);
        this.captureChild(treeList, 0, (UIComponent)viewRoot);
        Object[] tree = treeList.toArray();
        return new Object[]{tree, state};
    }

    private static void checkIdUniqueness(FacesContext facesContext, UIComponent component, Set<String> componentIds) {
        Iterator children = component.getFacetsAndChildren();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            String componentId = child.getClientId(facesContext);
            if (componentIds.add(componentId)) {
                LayoutStateManagementStrategy.checkIdUniqueness(facesContext, child, componentIds);
                continue;
            }
            throw new IllegalStateException("Duplicate component id found in view: " + componentId);
        }
    }

    private static class TreeNode
    implements Externalizable {
        private static final long serialVersionUID = -835775352718473281L;
        private static final String NULL_ID = "";
        private String componentType;
        private String id;
        private int parent;

        public TreeNode() {
        }

        public TreeNode(int parent, UIComponent component) {
            this.parent = parent;
            this.id = component.getId();
            this.componentType = component.getClass().getName();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.parent = in.readInt();
            this.componentType = in.readUTF();
            this.id = in.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.parent);
            out.writeUTF(this.componentType);
            out.writeUTF(Objects.requireNonNullElse(this.id, NULL_ID));
        }

        public int getParent() {
            return this.parent;
        }
    }

    private static final class FacetNode
    extends TreeNode {
        private static final long serialVersionUID = -3777170310958005106L;
        private String facetName;

        public FacetNode() {
        }

        public FacetNode(int parent, String name, UIComponent component) {
            super(parent, component);
            this.facetName = name;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.facetName = in.readUTF();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeUTF(this.facetName);
        }
    }
}

