/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class InterfacePolicy
implements Serializable,
Cloneable {
    protected List<Class<?>> parentInterfaces;
    protected List<String> parentInterfaceNames;
    protected List<ClassDescriptor> parentDescriptors;
    protected List<ClassDescriptor> childDescriptors = new ArrayList<ClassDescriptor>();
    protected ClassDescriptor descriptor;
    protected Class<?> implementorDescriptor;
    protected String implementorDescriptorClassName;

    public InterfacePolicy() {
        this.parentInterfaces = new ArrayList(2);
        this.parentInterfaceNames = new ArrayList<String>(2);
        this.parentDescriptors = new ArrayList<ClassDescriptor>(2);
    }

    public InterfacePolicy(ClassDescriptor descriptor) {
        this();
        this.descriptor = descriptor;
    }

    public void addChildDescriptor(ClassDescriptor childDescriptor) {
        this.getChildDescriptors().add(childDescriptor);
    }

    public void addParentDescriptor(ClassDescriptor parentDescriptor) {
        this.getParentDescriptors().add(parentDescriptor);
    }

    public void addParentInterface(Class<?> parentInterface) {
        this.getParentInterfaces().add(parentInterface);
    }

    public void addParentInterfaceName(String parentInterfaceName) {
        this.getParentInterfaceNames().add(parentInterfaceName);
    }

    public boolean hasChild() {
        return this.childDescriptors.size() > 0;
    }

    public List<ClassDescriptor> getChildDescriptors() {
        return this.childDescriptors;
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public <T> Class<T> getImplementorDescriptor() {
        return this.implementorDescriptor;
    }

    public String getImplementorDescriptorClassName() {
        if (this.implementorDescriptorClassName == null && this.implementorDescriptor != null) {
            this.implementorDescriptorClassName = this.implementorDescriptor.getName();
        }
        return this.implementorDescriptorClassName;
    }

    public List<ClassDescriptor> getParentDescriptors() {
        return this.parentDescriptors;
    }

    public List<Class<?>> getParentInterfaces() {
        return this.parentInterfaces;
    }

    public List<String> getParentInterfaceNames() {
        if (this.parentInterfaceNames.isEmpty() && !this.parentInterfaces.isEmpty()) {
            for (int i = 0; i < this.parentInterfaces.size(); ++i) {
                this.parentInterfaceNames.add(this.parentInterfaces.get(i).getName());
            }
        }
        return this.parentInterfaceNames;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        ArrayList newParentInterfaces = new ArrayList(2);
        for (String interfaceName : this.getParentInterfaceNames()) {
            Object interfaceClass = null;
            newParentInterfaces.add(PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(interfaceName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(interfaceName, ex)));
        }
        this.parentInterfaces = newParentInterfaces;
    }

    public void initialize(AbstractSession session) {
    }

    public boolean isInterfaceChildDescriptor() {
        return this.parentInterfaces != null && !this.parentInterfaces.isEmpty() || this.parentInterfaceNames != null && !this.parentInterfaceNames.isEmpty();
    }

    public boolean isTablePerClassPolicy() {
        return false;
    }

    protected Object selectAllObjects(ReadAllQuery query) {
        ReadAllQuery concreteQuery = (ReadAllQuery)this.prepareQuery(query);
        return query.getSession().executeQuery((DatabaseQuery)concreteQuery, query.getTranslationRow());
    }

    protected ObjectLevelReadQuery prepareQuery(ObjectLevelReadQuery query) {
        ObjectLevelReadQuery concreteQuery = null;
        Class javaClass = this.descriptor.getJavaClass();
        boolean shouldPrepare = query.shouldPrepare();
        if (shouldPrepare) {
            concreteQuery = (ObjectLevelReadQuery)query.getConcreteSubclassQueries().get(javaClass);
        }
        if (concreteQuery == null) {
            concreteQuery = (ObjectLevelReadQuery)query.deepClone();
            concreteQuery.setReferenceClass(javaClass);
            concreteQuery.setDescriptor(this.descriptor);
            concreteQuery.setQueryResultsCachePolicy(null);
            concreteQuery.getExpressionBuilder().setQueryClassAndDescriptor(javaClass, this.descriptor);
            if (concreteQuery.getQueryMechanism().getSelectionCriteria() != null) {
                concreteQuery.getExpressionBuilder().setSession(query.getSession().getRootSession(concreteQuery));
                concreteQuery.setSelectionCriteria(concreteQuery.getQueryMechanism().getSelectionCriteria().rebuildOn(concreteQuery.getExpressionBuilder()));
            }
            if (concreteQuery.hasAdditionalFields()) {
                ArrayList<Object> rebuiltFields = new ArrayList<Object>(concreteQuery.getAdditionalFields().size());
                for (Object field : concreteQuery.getAdditionalFields()) {
                    if (field instanceof Expression) {
                        rebuiltFields.add(((Expression)field).rebuildOn(concreteQuery.getExpressionBuilder()));
                        continue;
                    }
                    rebuiltFields.add(field);
                }
                concreteQuery.setAdditionalFields(rebuiltFields);
            }
            if (shouldPrepare) {
                concreteQuery.setTranslationRow(null);
                if (concreteQuery.isReadObjectQuery()) {
                    ((ReadObjectQuery)concreteQuery).clearSelectionId();
                }
                concreteQuery.checkPrepare(query.getSession(), query.getTranslationRow());
                query.getConcreteSubclassQueries().put(javaClass, concreteQuery);
                concreteQuery = (ObjectLevelReadQuery)concreteQuery.clone();
                concreteQuery.setTranslationRow(query.getTranslationRow());
            }
            concreteQuery.setIsExecutionClone(true);
        } else {
            concreteQuery = (ObjectLevelReadQuery)concreteQuery.clone();
            concreteQuery.setIsExecutionClone(true);
            concreteQuery.setTranslationRow(query.getTranslationRow());
        }
        return concreteQuery;
    }

    public Object selectAllObjectsUsingMultipleTableSubclassRead(ReadAllQuery query) throws DatabaseException {
        ContainerPolicy containerPolicy = query.getContainerPolicy();
        Object objects = containerPolicy.containerInstance();
        if (query.shouldIncludeData()) {
            ComplexQueryResult result = new ComplexQueryResult();
            result.setResult(objects);
            result.setData(new ArrayList());
            objects = result;
        }
        int size = this.childDescriptors.size();
        for (int index = 0; index < size; ++index) {
            ClassDescriptor descriptor = this.childDescriptors.get(index);
            objects = containerPolicy.concatenateContainers(objects, descriptor.getInterfacePolicy().selectAllObjects(query), query.getSession());
        }
        return objects;
    }

    protected Object selectOneObject(ReadObjectQuery query) throws DescriptorException {
        ReadObjectQuery concreteQuery = (ReadObjectQuery)this.prepareQuery(query);
        return query.getSession().executeQuery((DatabaseQuery)concreteQuery, concreteQuery.getTranslationRow());
    }

    public Object selectOneObjectUsingMultipleTableSubclassRead(ReadObjectQuery query) throws DatabaseException, QueryException {
        int size = this.childDescriptors.size();
        for (int index = 0; index < size; ++index) {
            ClassDescriptor descriptor = this.childDescriptors.get(index);
            Object object = descriptor.getInterfacePolicy().selectOneObject(query);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setImplementorDescriptor(Class<?> implementorDescriptor) {
        this.implementorDescriptor = implementorDescriptor;
    }

    public void setImplementorDescriptorClassName(String implementorDescriptorClassName) {
        this.implementorDescriptorClassName = implementorDescriptorClassName;
    }

    public void setParentInterfaces(List<Class<?>> parentInterfaces) {
        this.parentInterfaces = parentInterfaces;
    }

    public void setParentInterfaceNames(List<String> parentInterfaceNames) {
        this.parentInterfaceNames = parentInterfaceNames;
    }

    public boolean usesImplementorDescriptor() {
        return this.implementorDescriptor != null;
    }
}

