/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.net;

import com.sun.enterprise.util.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public final class NetUtils {
    public static final int MAX_PORT = 65535;
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final int IS_RUNNING_DEFAULT_TIMEOUT = 3000;
    private static final int IS_PORT_FREE_TIMEOUT = 1000;

    private NetUtils() {
    }

    public static synchronized int getFreePort() throws IllegalStateException {
        int n;
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            n = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not open random free local port.", e);
            }
        }
        serverSocket.close();
        return n;
    }

    public static PortAvailability checkPort(int portNumber) {
        if (!NetUtils.isPortValid(portNumber)) {
            return PortAvailability.illegalNumber;
        }
        if (NetUtils.isPortFreeServer(portNumber)) {
            return PortAvailability.OK;
        }
        if (NetUtils.isPortFreeClient(null, portNumber)) {
            return PortAvailability.noPermission;
        }
        return PortAvailability.inUse;
    }

    public static boolean isPortStringValid(String portNumber) {
        try {
            return NetUtils.isPortValid(Integer.parseInt(portNumber));
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static boolean isPortValid(int portNumber) {
        return portNumber >= 0 && portNumber <= 65535;
    }

    public static boolean isPortFree(int portNumber) {
        return NetUtils.isPortFree(null, portNumber);
    }

    public static boolean isPortFree(String hostName, int portNumber) {
        if (portNumber <= 0 || portNumber > 65535) {
            return false;
        }
        if (hostName == null || NetUtils.isThisHostLocal(hostName)) {
            return NetUtils.isPortFreeServer(portNumber);
        }
        return NetUtils.isPortFreeClient(hostName, portNumber);
    }

    private static boolean isPortFreeClient(String hostName, int portNumber) {
        try {
            if (hostName == null) {
                hostName = NetUtils.getHostName();
            }
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(hostName, portNumber), 1000);
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private static boolean isPortFreeServer(int port) {
        try {
            InetAddress add = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
            if (!NetUtils.isPortFreeServer(port, add)) {
                return false;
            }
            try {
                add = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (!NetUtils.isPortFreeServer(port, add)) {
                return false;
            }
            add = InetAddress.getByName("localhost");
            return NetUtils.isPortFreeServer(port, add);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isPortFreeServer(int port, InetAddress add) {
        boolean bl;
        ServerSocket ss = new ServerSocket(port, 10, add);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        ss.close();
        return bl;
    }

    public static boolean isRunning(String host, int port) {
        return NetUtils.isRunning(host, port, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning(String host, int port, int timeoutMilliseconds) {
        Socket server = new Socket();
        try {
            if (host == null) {
                host = InetAddress.getByName(null).getHostName();
            }
            InetSocketAddress whom = new InetSocketAddress(host, port);
            server.connect(whom, timeoutMilliseconds);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                server.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isRemote(String ip) {
        return !NetUtils.isLocal(ip);
    }

    public static boolean isLocal(String ip) {
        if (ip == null) {
            return false;
        }
        if ((ip = NetUtils.trimIP(ip)).equals(LOCALHOST_IP)) {
            return true;
        }
        String[] myIPs = NetUtils.getHostIPs();
        if (myIPs == null) {
            return false;
        }
        for (String myIP : myIPs) {
            if (!ip.equals(myIP)) continue;
            return true;
        }
        return false;
    }

    public static boolean isThisHostLocal(String hostname) {
        if (hostname == null || hostname.isEmpty() || hostname.equalsIgnoreCase("localhost")) {
            return true;
        }
        InetAddress[] hostAddrs = null;
        try {
            hostAddrs = InetAddress.getAllByName(hostname);
            assert (hostAddrs != null);
            for (InetAddress ia : hostAddrs) {
                if (!ia.isLoopbackAddress()) continue;
                return true;
            }
            for (InetAddress lia : InetAddress.getAllByName("localhost")) {
                for (InetAddress ia : hostAddrs) {
                    if (!lia.equals(ia)) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        Enumeration<NetworkInterface> eni = null;
        try {
            eni = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return false;
        }
        if (hostAddrs != null) {
            while (eni.hasMoreElements()) {
                NetworkInterface ni = eni.nextElement();
                for (InterfaceAddress intf : ni.getInterfaceAddresses()) {
                    for (InetAddress ia : hostAddrs) {
                        if (!intf.getAddress().equals(ia)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isSameHost(String host1, String host2) {
        ArrayList<String> host1_ips = new ArrayList<String>();
        ArrayList<String> host2_ips = new ArrayList<String>();
        try {
            if (!StringUtils.ok(host1) && !StringUtils.ok(host2)) {
                return true;
            }
            if (!StringUtils.ok(host1) || !StringUtils.ok(host2)) {
                return false;
            }
            InetAddress[] adds1 = InetAddress.getAllByName(host1);
            InetAddress[] adds2 = InetAddress.getAllByName(host2);
            if (adds1.length == 0 && adds2.length == 0) {
                return true;
            }
            if (adds1.length == 0 || adds2.length == 0) {
                return false;
            }
            for (InetAddress ia : adds1) {
                host1_ips.add(ia.getHostAddress());
            }
            for (InetAddress ia : adds2) {
                host2_ips.add(ia.getHostAddress());
            }
            for (String h1ip : host1_ips) {
                for (String h2ip : host2_ips) {
                    if (!h1ip.equals(h2ip)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    public static String[] getHostIPs() {
        try {
            InetAddress[] adds = NetUtils.getHostAddresses();
            if (adds == null) {
                return null;
            }
            String[] ips = new String[adds.length];
            for (int i = 0; i < adds.length; ++i) {
                String ip;
                ips[i] = ip = NetUtils.trimIP(adds[i].toString());
            }
            return ips;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InetAddress[] getHostAddresses() {
        try {
            String hname = NetUtils.getHostName();
            if (hname == null) {
                return null;
            }
            return InetAddress.getAllByName(hname);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCanonicalHostName() throws UnknownHostException {
        String defaultHostname = InetAddress.getLocalHost().getHostName();
        if (Boolean.parseBoolean(System.getenv("AS_NO_REVERSE_DNS"))) {
            return defaultHostname;
        }
        String hostname = InetAddress.getLocalHost().getCanonicalHostName();
        if (hostname.equals(InetAddress.getLocalHost().getHostAddress()) || !hostname.startsWith(defaultHostname)) {
            return defaultHostname;
        }
        return hostname;
    }

    private static String trimIP(String ip) {
        if (ip == null || ip.isEmpty()) {
            return ip;
        }
        int index = ip.lastIndexOf(47);
        if (index >= 0) {
            return ip.substring(++index);
        }
        return ip;
    }

    public static enum PortAvailability {
        illegalNumber,
        noPermission,
        inUse,
        unknown,
        OK;

    }
}

