/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Path(value="/status/")
public class StatusGenerator
extends AbstractResource {
    private static final File FILE = new File(FileUtils.USER_HOME, "GlassFishI18NData.properties");
    private final Set<String> commandsUsed = new TreeSet<String>();
    private final Set<String> allCommands = new TreeSet<String>();
    private final Set<String> restRedirectCommands = new TreeSet<String>();
    private final Map<String, String> commandsToResources = new TreeMap<String, String>();
    private final Map<String, String> resourcesToDeleteCommands = new TreeMap<String, String>();
    private final Properties propsI18N = new SortedProperties();
    private final ServiceLocator globalLocator = Globals.getDefaultHabitat();

    @GET
    @Produces(value={"text/plain"})
    public String getPlain() {
        Domain domain = this.locate(Domain.class);
        if (domain != null) {
            Dom dom = Dom.unwrap((ConfigBeanProxy)domain);
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            NOOPResourcesGenerator resourcesGenerator = new NOOPResourcesGenerator(this.serviceLocator);
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
        }
        StringBuilder status = new StringBuilder();
        status.append("\n------------------------");
        status.append("All Commands used in REST Admin:\n");
        for (String command : this.commandsUsed) {
            status.append(command).append('\n');
        }
        this.detectFromCommandRunner(this.allCommands);
        for (String command : this.commandsUsed) {
            this.allCommands.remove(command);
        }
        status.append("\n------------------------");
        status.append("Missing Commands not used in REST Admin:\n");
        for (String command : this.allCommands) {
            if (this.hasTargetParam(command).booleanValue()) {
                status.append(command).append("          has a target param ").append('\n');
                continue;
            }
            status.append(command).append('\n');
        }
        status.append("\n------------------------");
        status.append("REST-REDIRECT Commands defined on ConfigBeans:\n");
        for (String ss : this.restRedirectCommands) {
            status.append(ss).append('\n');
        }
        status.append("\n------------------------");
        status.append("Commands to Resources Mapping Usage in REST Admin:\n");
        for (Map.Entry<String, String> entry : this.commandsToResources.entrySet()) {
            if (this.hasTargetParam(entry.getKey()).booleanValue()) {
                status.append(entry.getKey()).append("   :::target:::   ").append(entry.getValue()).append('\n');
                continue;
            }
            status.append(entry.getKey()).append("      :::      ").append(entry.getValue()).append('\n');
        }
        status.append("\n------------------------");
        status.append("Resources with Delete Commands in REST Admin (not counting RESTREDIRECT:\n");
        for (Map.Entry<String, String> entry : this.resourcesToDeleteCommands.entrySet()) {
            status.append(entry.getKey()).append("      :::      ").append(entry.getValue()).append('\n');
        }
        RestLogging.restLogger.log(Level.INFO, "Storing properties to the file {0}", FILE);
        try (FileOutputStream f = new FileOutputStream(FILE);){
            this.propsI18N.store(f, "");
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return status.toString();
    }

    @GET
    @Produces(value={"text/html"})
    public String getHtml() {
        Domain entity = this.locate(Domain.class);
        if (entity != null) {
            Dom dom = Dom.unwrap((ConfigBeanProxy)entity);
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            NOOPResourcesGenerator resourcesGenerator = new NOOPResourcesGenerator(this.serviceLocator);
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
        }
        StringBuilder status = new StringBuilder();
        status.append("<h4>All Commands used in REST Admin</h4>\n<ul>\n");
        for (String ss : this.commandsUsed) {
            status.append("<li>").append(ss).append("</li>\n");
        }
        this.detectFromCommandRunner(this.allCommands);
        for (String ss : this.commandsUsed) {
            this.allCommands.remove(ss);
        }
        status.append("</ul>\n<hr/>\n").append("<h4>Missing Commands not used in REST Admin</h4>\n<ul>\n");
        for (String ss : this.allCommands) {
            if (this.hasTargetParam(ss).booleanValue()) {
                status.append("<li>").append(ss).append("          has a target param.</li>\n");
                continue;
            }
            status.append("<li>").append(ss).append("</li>\n");
        }
        status.append("</ul>\n<hr/>\n").append("<h4>REST-REDIRECT Commands defined on ConfigBeans</h4>\n<ul>\n");
        for (String command : this.restRedirectCommands) {
            status.append("<li>").append(command).append("</li>\n");
        }
        status.append("</ul>\n<hr/>\n").append("<h4>Commands to Resources Mapping Usage in REST Admin</h4>\n").append("<table border=\"1\" style=\"border-collapse: collapse\">\n").append("<tr><th>Command</th><th>Target</th><th>Resource</th></tr>\n");
        for (Map.Entry<String, String> entry : this.commandsToResources.entrySet()) {
            status.append("<tr><td>").append(entry.getKey()).append("</td><td>").append(this.hasTargetParam(entry.getKey()) != false ? "target" : "").append("</td><td>").append(entry.getValue()).append("</td></tr>\n");
        }
        status.append("</table>\n<hr/>\n").append("<h4>Resources with Delete Commands in REST Admin (not counting RESTREDIRECT)</h4>\n").append("<table border=\"1\" style=\"border-collapse: collapse\">\n").append("<tr><th>Resource</th><th>Delete Command</th></tr>\n");
        for (Map.Entry<String, String> entry : this.resourcesToDeleteCommands.entrySet()) {
            status.append("<tr><td>").append(entry.getKey()).append("</td><td>").append(entry.getValue()).append("</td></tr>\n");
        }
        status.append("</table>");
        RestLogging.restLogger.log(Level.INFO, "Storing properties to the file {0}", FILE);
        try (FileOutputStream f = new FileOutputStream(FILE);){
            this.propsI18N.store(f, "");
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        return status.toString();
    }

    private void detectFromCommandRunner(Set<String> commands) {
        CommandRunner cr = this.locate(CommandRunner.class);
        RestActionReporter ar = new RestActionReporter();
        ParameterMap parameters = new ParameterMap();
        cr.getCommandInvocation("list-commands", (ActionReport)ar, this.getSubject()).parameters(parameters).execute();
        List children = ar.getTopMessagePart().getChildren();
        if (children != null) {
            for (ActionReport.MessagePart part : children) {
                commands.add(part.getMessage());
            }
        }
        ar = new RestActionReporter();
        parameters = new ParameterMap();
        parameters.add((Object)"DEFAULT", (Object)"_");
        cr.getCommandInvocation("list-commands", (ActionReport)ar, this.getSubject()).parameters(parameters).execute();
        children = ar.getTopMessagePart().getChildren();
        if (children != null) {
            for (ActionReport.MessagePart part : children) {
                commands.add(part.getMessage());
            }
        }
    }

    private <T> T locate(Class<T> clazz) {
        return this.globalLocator.getService(clazz, new Annotation[0]);
    }

    private Boolean hasTargetParam(String command) {
        try {
            if (command != null) {
                Collection<CommandModel.ParamModel> params = this.getParamMetaData(command);
                for (CommandModel.ParamModel param : params) {
                    CommandModel.ParamModel paramModel = param;
                    if (!paramModel.getName().equals("target")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            RestLogging.restLogger.log(Level.FINE, e.getMessage(), e);
        }
        return false;
    }

    private Collection<CommandModel.ParamModel> getParamMetaData(String commandName) {
        CommandRunner cr = this.locate(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, RestLogging.restLogger);
        Collection params = cm.getParameters();
        return params;
    }

    private static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<String> keyList = new Vector<String>();
            while (keysEnum.hasMoreElements()) {
                keyList.add((String)keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }
    }

    class NOOPResourcesGenerator
    extends ResourcesGeneratorBase {
        public NOOPResourcesGenerator(ServiceLocator h) {
            super(h);
        }

        @Override
        public ClassWriter getClassWriter(String className, String baseClassName, String resourcePath) {
            return new NOOPClassWriter(className, baseClassName, resourcePath);
        }

        @Override
        public String endGeneration() {
            return "done";
        }

        @Override
        public void configModelVisited(ConfigModel model) {
            for (String attrName : model.getAttributeNames()) {
                String key = model.targetTypeName + "." + Util.eleminateHypen(attrName);
                StatusGenerator.this.propsI18N.setProperty(key + ".label", attrName);
                StatusGenerator.this.propsI18N.setProperty(key + ".help", attrName);
            }
            Class<?> cbp = null;
            try {
                cbp = model.classLoaderHolder.loadClass(model.targetTypeName);
            }
            catch (MultiException e) {
                RestLogging.restLogger.log(Level.WARNING, "Cannot load " + model.targetTypeName, e);
                return;
            }
            RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
            if (restRedirects != null) {
                RestRedirect[] values;
                for (RestRedirect r : values = restRedirects.value()) {
                    StatusGenerator.this.commandsUsed.add(r.commandName());
                    StatusGenerator.this.restRedirectCommands.add(r.commandName());
                }
            }
        }
    }

    class NOOPClassWriter
    implements ClassWriter {
        private final String className;

        public NOOPClassWriter(String className, String baseClassName, String resourcePath) {
            this.className = className;
            if (baseClassName.equals("TemplateRestResource")) {
                StatusGenerator.this.resourcesToDeleteCommands.put(className, "");
            }
        }

        @Override
        public void createGetCommandResourcePaths(List<CommandResourceMetaData> commandMetaData) {
            for (CommandResourceMetaData metaData : commandMetaData) {
                StatusGenerator.this.commandsUsed.add(metaData.command);
                if (StatusGenerator.this.commandsToResources.containsKey(metaData.command)) {
                    String val = StatusGenerator.this.commandsToResources.get(metaData.command) + ", " + this.className;
                    StatusGenerator.this.commandsToResources.put(metaData.command, val);
                    continue;
                }
                StatusGenerator.this.commandsToResources.put(metaData.command, this.className);
            }
        }

        @Override
        public void createGetCommandResource(String commandResourceClassName, String resourcePath) {
        }

        @Override
        public void createCommandResourceConstructor(String commandResourceClassName, String commandName, String httpMethod, boolean linkedToParent, CommandResourceMetaData.ParameterMetaData[] commandParams, String commandDisplayName, String commandAction) {
        }

        @Override
        public void createCustomResourceMapping(String resourceClassName, String mappingPath) {
        }

        @Override
        public void done() {
        }

        @Override
        public void createGetDeleteCommand(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
            StatusGenerator.this.resourcesToDeleteCommands.put(this.className, commandName);
        }

        @Override
        public void createGetPostCommand(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetChildResource(String path, String childResourceClassName) {
        }

        @Override
        public void createGetChildResourceForListResources(String keyAttributeName, String childResourceClassName) {
        }

        @Override
        public void createGetPostCommandForCollectionLeafResource(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetDeleteCommandForCollectionLeafResource(String commandName) {
            StatusGenerator.this.commandsUsed.add(commandName);
            if (StatusGenerator.this.commandsToResources.containsKey(commandName)) {
                String val = StatusGenerator.this.commandsToResources.get(commandName) + ", " + this.className;
                StatusGenerator.this.commandsToResources.put(commandName, val);
            } else {
                StatusGenerator.this.commandsToResources.put(commandName, this.className);
            }
        }

        @Override
        public void createGetDisplayNameForCollectionLeafResource(String displayName) {
        }
    }
}

