/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.IgnoreFilter;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ScrollInsensitiveResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class MergeNode
extends DMLModStatementNode {
    public static final int SOURCE_TABLE_INDEX = 0;
    public static final int TARGET_TABLE_INDEX = 1;
    private static final String TARGET_ROW_LOCATION_NAME = "###TargetRowLocation";
    private FromBaseTable _targetTable;
    private FromTable _sourceTable;
    private ValueNode _searchCondition;
    private QueryTreeNodeVector<MatchingClauseNode> _matchingClauses;
    private ResultColumnList _selectList;
    private FromList _leftJoinFromList;
    private HalfOuterJoinNode _hojn;
    private ConstantAction _constantAction;
    private CursorNode _leftJoinCursor;

    public MergeNode(FromTable fromTable, FromTable fromTable2, ValueNode valueNode, QueryTreeNodeVector<MatchingClauseNode> queryTreeNodeVector, ContextManager contextManager) throws StandardException {
        super(null, null, contextManager);
        if (!(fromTable instanceof FromBaseTable)) {
            this.notBaseTable();
        } else {
            this._targetTable = (FromBaseTable)fromTable;
        }
        this._sourceTable = fromTable2;
        this._searchCondition = valueNode;
        this._matchingClauses = queryTreeNodeVector;
    }

    FromBaseTable getTargetTable() {
        return this._targetTable;
    }

    void associateColumn(FromList fromList, ColumnReference columnReference, int n) throws StandardException {
        if (n != 0) {
            columnReference.setMergeTableID(n);
        } else {
            String string = columnReference.getTableName();
            if (((FromTable)fromList.elementAt(0)).getMatchingColumn(columnReference) != null) {
                columnReference.setMergeTableID(1);
            } else if (((FromTable)fromList.elementAt(1)).getMatchingColumn(columnReference) != null) {
                columnReference.setMergeTableID(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindExpression(ValueNode valueNode, FromList fromList) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int n = compilerContext.getReliability();
        compilerContext.setReliability(n | 0x2000);
        compilerContext.pushCurrentPrivType(0);
        try {
            valueNode.bindExpression(fromList, new SubqueryList(this.getContextManager()), new ArrayList<AggregateNode>());
        }
        finally {
            compilerContext.popCurrentPrivType();
            compilerContext.setReliability(n);
        }
    }

    void getColumnsInExpression(HashMap<String, ColumnReference> hashMap, ValueNode valueNode, int n) throws StandardException {
        if (valueNode == null) {
            return;
        }
        List<ColumnReference> list = this.getColumnReferences(valueNode);
        this.getColumnsFromList(hashMap, list, n);
    }

    void getColumnsFromList(HashMap<String, ColumnReference> hashMap, ResultColumnList resultColumnList, int n) throws StandardException {
        List<ColumnReference> list = this.getColumnReferences(resultColumnList);
        this.getColumnsFromList(hashMap, list, n);
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (!(this._sourceTable instanceof FromVTI) && !(this._sourceTable instanceof FromBaseTable)) {
            throw StandardException.newException("42XAL", new Object[0]);
        }
        if (this.getExposedName(this._targetTable).equals(this.getExposedName(this._sourceTable))) {
            throw StandardException.newException("42XAM", new Object[0]);
        }
        this.forbidDerivedColumnLists();
        this.forbidSynonyms();
        IgnoreFilter ignoreFilter = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
        FromList fromList = new FromList(this.getContextManager());
        FromTable fromTable = this.cloneFromTable(this._sourceTable);
        FromBaseTable fromBaseTable = (FromBaseTable)this.cloneFromTable(this._targetTable);
        fromList.addFromTable(fromTable);
        fromList.addFromTable(fromBaseTable);
        fromList.bindTables(dataDictionary, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        if (!this.targetIsBaseTable(fromBaseTable)) {
            this.notBaseTable();
        }
        this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
        for (MatchingClauseNode matchingClauseNode : this._matchingClauses) {
            FromList fromList2 = this.cloneFromList(dataDictionary, fromBaseTable);
            FromBaseTable fromBaseTable2 = (FromBaseTable)fromList2.elementAt(1);
            matchingClauseNode.bind(dataDictionary, this, fromList2, fromBaseTable2);
            SelectNode.checkNoWindowFunctions(matchingClauseNode, "matching clause");
            MergeNode.checkNoAggregates(matchingClauseNode);
        }
        this.bindLeftJoin(dataDictionary);
    }

    static void checkNoAggregates(QueryTreeNode queryTreeNode) throws StandardException {
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(AggregateNode.class, SubqueryNode.class);
        queryTreeNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42Z09", new Object[0]);
        }
    }

    private String getExposedName(FromTable fromTable) throws StandardException {
        return fromTable.getTableName().getTableName();
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this._sourceTable.referencesSessionSchema() || this._targetTable.referencesSessionSchema() || this._searchCondition.referencesSessionSchema() || this._matchingClauses.referencesSessionSchema();
    }

    private void forbidDerivedColumnLists() throws StandardException {
        if (this._sourceTable.getResultColumns() != null || this._targetTable.getResultColumns() != null) {
            throw StandardException.newException("42XAQ", new Object[0]);
        }
    }

    private void forbidSynonyms() throws StandardException {
        this.forbidSynonyms(this._targetTable.getTableNameField().cloneMe());
        if (this._sourceTable instanceof FromBaseTable) {
            this.forbidSynonyms(((FromBaseTable)this._sourceTable).getTableNameField().cloneMe());
        }
    }

    private void forbidSynonyms(TableName tableName) throws StandardException {
        tableName.bind();
        TableName tableName2 = this.resolveTableToSynonym(tableName);
        if (tableName2 != null) {
            throw StandardException.newException("42XAP", new Object[0]);
        }
    }

    private void notBaseTable() throws StandardException {
        throw StandardException.newException("42XAK", new Object[0]);
    }

    private boolean targetIsBaseTable(FromBaseTable fromBaseTable) throws StandardException {
        FromBaseTable fromBaseTable2 = fromBaseTable;
        TableDescriptor tableDescriptor = fromBaseTable2.getTableDescriptor();
        if (tableDescriptor == null) {
            return false;
        }
        switch (tableDescriptor.getTableType()) {
            case 0: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private boolean sourceIsBase_or_VTI() throws StandardException {
        if (this._sourceTable instanceof FromVTI) {
            return true;
        }
        if (!(this._sourceTable instanceof FromBaseTable)) {
            return false;
        }
        FromBaseTable fromBaseTable = (FromBaseTable)this._sourceTable;
        TableDescriptor tableDescriptor = fromBaseTable.getTableDescriptor();
        if (tableDescriptor == null) {
            return false;
        }
        switch (tableDescriptor.getTableType()) {
            case 0: 
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindLeftJoin(DataDictionary dataDictionary) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int n = compilerContext.getReliability();
        try {
            compilerContext.setReliability(n | 0x2000);
            IgnoreFilter ignoreFilter = new IgnoreFilter();
            this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
            this._hojn = new HalfOuterJoinNode(this._sourceTable, this._targetTable, this._searchCondition, null, false, null, this.getContextManager());
            this._leftJoinFromList = this._hojn.makeFromList(true, true);
            this._leftJoinFromList.bindTables(dataDictionary, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
            if (!this.sourceIsBase_or_VTI()) {
                throw StandardException.newException("42XAL", new Object[0]);
            }
            FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            fromList.addFromTable(this._hojn);
            this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
            for (MatchingClauseNode matchingClauseNode : this._matchingClauses) {
                matchingClauseNode.bindRefinement(this, this._leftJoinFromList);
            }
            ResultColumnList resultColumnList = this.buildSelectList();
            this._selectList = resultColumnList.copyListAndObjects();
            this.resultSet = new SelectNode(resultColumnList, fromList, null, null, null, null, null, this.getContextManager());
            this._leftJoinCursor = new CursorNode("SELECT", this.resultSet, null, null, null, null, false, 1, null, true, this.getContextManager());
            this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
            this._leftJoinCursor.bindStatement();
            this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
            this.addOnClausePrivileges();
        }
        finally {
            compilerContext.setReliability(n);
        }
    }

    private FromList cloneFromList(DataDictionary dataDictionary, FromBaseTable fromBaseTable) throws StandardException {
        FromList fromList = new FromList(this.getContextManager());
        FromBaseTable fromBaseTable2 = new FromBaseTable(fromBaseTable.getTableNameField(), fromBaseTable.correlationName, null, null, this.getContextManager());
        FromTable fromTable = this.cloneFromTable(this._sourceTable);
        fromBaseTable2.setMergeTableID(2);
        fromTable.setMergeTableID(1);
        fromList.addFromTable(fromTable);
        fromList.addFromTable(fromBaseTable2);
        IgnoreFilter ignoreFilter = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
        fromList.bindTables(dataDictionary, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
        return fromList;
    }

    private FromTable cloneFromTable(FromTable fromTable) throws StandardException {
        if (fromTable instanceof FromVTI) {
            FromVTI fromVTI = (FromVTI)fromTable;
            return new FromVTI(fromVTI.methodCall, fromVTI.correlationName, fromVTI.getResultColumns(), null, fromVTI.exposedName, this.getContextManager());
        }
        if (fromTable instanceof FromBaseTable) {
            FromBaseTable fromBaseTable = (FromBaseTable)fromTable;
            return new FromBaseTable(fromBaseTable.tableName, fromBaseTable.correlationName, null, null, this.getContextManager());
        }
        throw StandardException.newException("42XAL", new Object[0]);
    }

    private void addOnClausePrivileges() throws StandardException {
        for (ColumnReference queryTreeNode : this.getColumnReferences(this._searchCondition)) {
            this.addColumnPrivilege(queryTreeNode);
        }
        for (StaticMethodCallNode staticMethodCallNode : this.getRoutineReferences(this._searchCondition)) {
            this.addRoutinePrivilege(staticMethodCallNode);
        }
        for (CastNode castNode : this.getCastNodes(this._searchCondition)) {
            this.addUDTUsagePriv(castNode);
        }
    }

    private void addColumnPrivilege(ColumnReference columnReference) throws StandardException {
        ColumnDescriptor columnDescriptor;
        CompilerContext compilerContext = this.getCompilerContext();
        ResultColumn resultColumn = columnReference.getSource();
        if (resultColumn != null && (columnDescriptor = resultColumn.getColumnDescriptor()) != null) {
            compilerContext.pushCurrentPrivType(0);
            compilerContext.addRequiredColumnPriv(columnDescriptor);
            compilerContext.popCurrentPrivType();
        }
    }

    private void addRoutinePrivilege(StaticMethodCallNode staticMethodCallNode) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        compilerContext.pushCurrentPrivType(6);
        compilerContext.addRequiredRoutinePriv(staticMethodCallNode.ad);
        compilerContext.popCurrentPrivType();
    }

    private List<CastNode> getCastNodes(QueryTreeNode queryTreeNode) throws StandardException {
        CollectNodesVisitor<CastNode> collectNodesVisitor = new CollectNodesVisitor<CastNode>(CastNode.class);
        queryTreeNode.accept(collectNodesVisitor);
        return collectNodesVisitor.getList();
    }

    private List<StaticMethodCallNode> getRoutineReferences(QueryTreeNode queryTreeNode) throws StandardException {
        CollectNodesVisitor<StaticMethodCallNode> collectNodesVisitor = new CollectNodesVisitor<StaticMethodCallNode>(StaticMethodCallNode.class);
        queryTreeNode.accept(collectNodesVisitor);
        return collectNodesVisitor.getList();
    }

    private ResultColumnList buildSelectList() throws StandardException {
        HashMap<String, ColumnReference> hashMap = new HashMap<String, ColumnReference>();
        this.getColumnsInExpression(hashMap, this._searchCondition, 0);
        for (MatchingClauseNode matchingClauseNode : this._matchingClauses) {
            matchingClauseNode.getColumnsInExpressions(this, hashMap);
            int n = matchingClauseNode.isDeleteClause() ? 2 : 0;
            this.getColumnsFromList(hashMap, matchingClauseNode.getThenColumns(), n);
        }
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        this.addColumns((FromTable)this._leftJoinFromList.elementAt(0), hashMap, resultColumnList, 1);
        this.addColumns((FromTable)this._leftJoinFromList.elementAt(1), hashMap, resultColumnList, 2);
        this.addTargetRowLocation(resultColumnList);
        return resultColumnList;
    }

    private void addTargetRowLocation(ResultColumnList resultColumnList) throws StandardException {
        this._targetTable.setRowLocationColumnName(TARGET_ROW_LOCATION_NAME);
        TableName tableName = this._targetTable.getTableName();
        ColumnReference columnReference = new ColumnReference(TARGET_ROW_LOCATION_NAME, tableName, this.getContextManager());
        columnReference.setMergeTableID(2);
        ResultColumn resultColumn = new ResultColumn((String)null, (ValueNode)columnReference, this.getContextManager());
        resultColumn.markGenerated();
        resultColumnList.addResultColumn(resultColumn);
    }

    private void addColumns(FromTable fromTable, HashMap<String, ColumnReference> hashMap, ResultColumnList resultColumnList, int n) throws StandardException {
        String[] stringArray = this.getColumns(n, hashMap);
        TableName tableName = fromTable.getTableName();
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnReference columnReference = new ColumnReference(stringArray[i], tableName, this.getContextManager());
            columnReference.setMergeTableID(n);
            ResultColumn resultColumn = new ResultColumn((String)null, (ValueNode)columnReference, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
    }

    private String[] getColumns(int n, HashMap<String, ColumnReference> hashMap) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ColumnReference columnReference : hashMap.values()) {
            if (columnReference.getMergeTableID() != n) continue;
            hashSet.add(columnReference.getColumnName());
        }
        Object[] objectArray = new String[hashSet.size()];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private List<ColumnReference> getColumnReferences(QueryTreeNode queryTreeNode) throws StandardException {
        CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        queryTreeNode.accept(collectNodesVisitor);
        return collectNodesVisitor.getList();
    }

    private void getColumnsFromList(HashMap<String, ColumnReference> hashMap, List<ColumnReference> list, int n) throws StandardException {
        for (ColumnReference columnReference : list) {
            this.addColumn(hashMap, columnReference, n);
        }
    }

    void addColumn(HashMap<String, ColumnReference> hashMap, ColumnReference valueNode, int n) throws StandardException {
        Object object;
        if (((ColumnReference)valueNode).getTableName() == null) {
            valueNode = ((ColumnReference)valueNode).bindExpression(this._leftJoinFromList, new SubqueryList(this.getContextManager()), (List)new ArrayList());
            object = ((ColumnReference)valueNode).getQualifiedTableName();
            valueNode = new ColumnReference(((ColumnReference)valueNode).getColumnName(), (TableName)object, this.getContextManager());
        }
        this.associateColumn(this._leftJoinFromList, (ColumnReference)valueNode, n);
        object = this.makeDCMKey(((ColumnReference)valueNode).getTableName(), ((ColumnReference)valueNode).getColumnName());
        ColumnReference columnReference = hashMap.get(object);
        if (columnReference != null) {
            columnReference.setMergeTableID(((ColumnReference)valueNode).getMergeTableID());
        } else {
            hashMap.put((String)object, (ColumnReference)valueNode);
        }
    }

    private String makeDCMKey(String string, String string2) {
        return IdUtil.mkQualifiedName(string, string2);
    }

    @Override
    public void optimizeStatement() throws StandardException {
        IgnoreFilter ignoreFilter = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignoreFilter);
        this._leftJoinCursor.optimizeStatement();
        for (MatchingClauseNode matchingClauseNode : this._matchingClauses) {
            matchingClauseNode.optimize();
        }
        this.getCompilerContext().removePrivilegeFilter(ignoreFilter);
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this._matchingClauses.size();
        this.generateParameterValueSet(activationClassBuilder);
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this._leftJoinCursor.generate(activationClassBuilder, methodBuilder);
        ScrollInsensitiveResultSetNode scrollInsensitiveResultSetNode = (ScrollInsensitiveResultSetNode)this._leftJoinCursor.resultSet;
        ResultSetNode resultSetNode = scrollInsensitiveResultSetNode.getChildResult();
        ConstantAction[] constantActionArray = new ConstantAction[n];
        for (int i = 0; i < n; ++i) {
            MatchingClauseNode matchingClauseNode = this._matchingClauses.elementAt(i);
            matchingClauseNode.generate(activationClassBuilder, this._selectList, resultSetNode, this._hojn, i);
            constantActionArray[i] = matchingClauseNode.makeConstantAction(activationClassBuilder);
        }
        this._constantAction = this.getGenericConstantActionFactory().getMergeConstantAction(constantActionArray);
        methodBuilder.callMethod((short)185, null, "getMergeResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this._constantAction;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        if (this._leftJoinCursor != null) {
            this._leftJoinCursor.acceptChildren(visitor);
        } else {
            super.acceptChildren(visitor);
            this._targetTable.accept(visitor);
            this._sourceTable.accept(visitor);
            this._searchCondition.accept(visitor);
        }
        for (MatchingClauseNode matchingClauseNode : this._matchingClauses) {
            matchingClauseNode.accept(visitor);
        }
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    String statementToString() {
        return "MERGE";
    }
}

