/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import jakarta.servlet.DispatcherType;
import java.io.CharConversionException;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import org.glassfish.grizzly.http.util.URLDecoder;

public class FilterMap
implements Serializable {
    private static final EnumSet<DispatcherType> DEFAULT_DISPATCHER = EnumSet.of(DispatcherType.REQUEST);
    private String filterName = null;
    private String servletName = null;
    private String urlPattern = null;
    private Set<DispatcherType> dispatcherTypes;

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String urlPattern) {
        try {
            this.urlPattern = URLDecoder.decode((String)urlPattern);
        }
        catch (CharConversionException e) {
            throw new IllegalStateException(e);
        }
    }

    public Set<DispatcherType> getDispatcherTypes() {
        return this.dispatcherTypes == null || this.dispatcherTypes.isEmpty() ? DEFAULT_DISPATCHER : this.dispatcherTypes;
    }

    public void setDispatcherTypes(Set<DispatcherType> dispatcherTypes) {
        this.dispatcherTypes = dispatcherTypes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FilterMap[");
        sb.append("filterName=");
        sb.append(this.filterName);
        if (this.servletName != null) {
            sb.append(", servletName=");
            sb.append(this.servletName);
        }
        if (this.urlPattern != null) {
            sb.append(", urlPattern=");
            sb.append(this.urlPattern);
        }
        sb.append("]");
        return sb.toString();
    }
}

