/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager.tasks;

import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.manager.spi.FilterClassesFromFacesInitializerAnnotationProvider;
import com.sun.faces.config.manager.tasks.ProvideMetadataToAnnotationScanTask;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.spi.AnnotationProviderFactory;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.util.Timer;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class FindAnnotatedConfigClasses
implements Callable<Map<Class<? extends Annotation>, Set<Class<?>>>> {
    private InitFacesContext facesContext;
    private AnnotationProvider provider;
    private ProvideMetadataToAnnotationScanTask metadataGetter;
    private Set<Class<?>> annotatedSet;

    public FindAnnotatedConfigClasses(ServletContext servletContext, InitFacesContext facesContext, ProvideMetadataToAnnotationScanTask metadataGetter) {
        this.facesContext = facesContext;
        this.provider = AnnotationProviderFactory.createAnnotationProvider(servletContext);
        this.metadataGetter = metadataGetter;
        this.annotatedSet = (Set)servletContext.getAttribute("com.sun.faces.AnnotatedClasses");
    }

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> call() throws Exception {
        Timer t = Timer.getInstance();
        if (t != null) {
            t.startTiming();
        }
        this.facesContext.addInitContextEntryForCurrentThread();
        Set<URI> scanUris = null;
        AnnotationScanner annotationScanner = this.metadataGetter.getAnnotationScanner();
        if (this.provider instanceof FilterClassesFromFacesInitializerAnnotationProvider && annotationScanner != null) {
            ((FilterClassesFromFacesInitializerAnnotationProvider)this.provider).setAnnotationScanner(annotationScanner, this.metadataGetter.getJarNames(this.annotatedSet));
            scanUris = Collections.emptySet();
        } else {
            scanUris = this.metadataGetter.getAnnotationScanURIs(this.annotatedSet);
        }
        Map<Class<? extends Annotation>, Set<Class<?>>> annotatedClasses = this.provider.getAnnotatedClasses(scanUris);
        if (t != null) {
            t.stopTiming();
            t.logResult("Configuration annotation scan complete.");
        }
        return annotatedClasses;
    }
}

