/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.reflection;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import org.glassfish.pfl.basic.reflection.BridgeBase;
import org.glassfish.pfl.basic.reflection.BridgePermission;
import sun.reflect.ReflectionFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Bridge
extends BridgeBase {
    private static final Permission GET_BRIDGE_PERMISSION = new BridgePermission("getBridge");
    private static Bridge bridge = null;
    private final Method latestUserDefinedLoaderMethod = this.getLatestUserDefinedLoaderMethod();
    private final Constructor<OptionalDataException> optionalDataExceptionConstructor;
    private final ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();
    private static Method hasStaticInitializerMethod = null;

    private Method getLatestUserDefinedLoaderMethod() {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                Method result;
                try {
                    Class<ObjectInputStream> io = ObjectInputStream.class;
                    result = io.getDeclaredMethod("latestUserDefinedLoader", new Class[0]);
                    result.setAccessible(true);
                }
                catch (NoSuchMethodException nsme) {
                    throw new Error("java.io.ObjectInputStream latestUserDefinedLoader " + nsme, nsme);
                }
                return result;
            }
        });
    }

    private Constructor<OptionalDataException> getOptDataExceptionCtor() {
        try {
            Constructor result = AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor>(){

                @Override
                public Constructor run() throws NoSuchMethodException, SecurityException {
                    Constructor constructor = OptionalDataException.class.getDeclaredConstructor(Boolean.TYPE);
                    constructor.setAccessible(true);
                    return constructor;
                }
            });
            if (result == null) {
                throw new Error("Unable to find OptionalDataException constructor");
            }
            return result;
        }
        catch (Exception ex) {
            throw new Error("Unable to find OptionalDataException constructor");
        }
    }

    private Bridge() {
        this.optionalDataExceptionConstructor = this.getOptDataExceptionCtor();
    }

    public static synchronized Bridge get() {
        SecurityManager sman = System.getSecurityManager();
        if (sman != null) {
            sman.checkPermission(GET_BRIDGE_PERMISSION);
        }
        if (bridge == null) {
            bridge = new Bridge();
        }
        return bridge;
    }

    @Override
    public final ClassLoader getLatestUserDefinedLoader() {
        try {
            return (ClassLoader)this.latestUserDefinedLoaderMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ite) {
            throw new Error(this.getClass().getName() + ".latestUserDefinedLoader: " + ite, ite);
        }
    }

    @Override
    public final <T> Constructor<T> newConstructorForExternalization(Class<T> cl) {
        try {
            Constructor<T> cons = cl.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return Bridge.isPublic(cons) ? cons : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static boolean isPublic(Constructor<?> cons) {
        return (cons.getModifiers() & 1) != 0;
    }

    @Override
    public final <T> Constructor<T> newConstructorForSerialization(Class<T> aClass, Constructor<?> cons) {
        Constructor<?> newConstructor = this.reflectionFactory.newConstructorForSerialization(aClass, cons);
        newConstructor.setAccessible(true);
        return newConstructor;
    }

    @Override
    public <T> Constructor<T> newConstructorForSerialization(Class<T> aClass) {
        Class<?> baseClass = Bridge.getNearestNonSerializableBaseClass(aClass);
        if (baseClass == null) {
            return null;
        }
        try {
            Constructor<?> cons = baseClass.getDeclaredConstructor(new Class[0]);
            if (Bridge.isPrivate(cons) || !Bridge.isAccessibleFromSubclass(cons, aClass, baseClass)) {
                return null;
            }
            return this.newConstructorForSerialization(aClass, cons);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static <T> Class<?> getNearestNonSerializableBaseClass(Class<T> clazz) {
        Class<T> baseClass = clazz;
        while (Serializable.class.isAssignableFrom(baseClass)) {
            if ((baseClass = baseClass.getSuperclass()) != null) continue;
            return null;
        }
        return baseClass;
    }

    private static boolean isAccessibleFromSubclass(Constructor<?> constructor, Class<?> clazz, Class<?> baseClass) {
        return Bridge.isPublicOrProtected(constructor) || Bridge.inSamePackage(clazz, baseClass);
    }

    private static boolean inSamePackage(Class<?> clazz, Class<?> baseClass) {
        return Objects.equals(clazz.getPackage(), baseClass.getPackage());
    }

    private static boolean isPublicOrProtected(Constructor<?> constructor) {
        return (constructor.getModifiers() & 5) != 0;
    }

    private static boolean isPrivate(Constructor<?> cons) {
        return (cons.getModifiers() & 2) != 0;
    }

    @Override
    public boolean hasStaticInitializerForSerialization(Class<?> cl) {
        try {
            return (Boolean)Bridge.getHasStaticInitializerMethod().invoke(null, cl);
        }
        catch (Exception ex) {
            throw new Error("Cannot invoke 'hasStaticInitializer' method on " + ObjectStreamClass.class.getName());
        }
    }

    private static Method getHasStaticInitializerMethod() throws NoSuchMethodException {
        if (hasStaticInitializerMethod == null) {
            hasStaticInitializerMethod = ObjectStreamClass.class.getDeclaredMethod("hasStaticInitializer", Class.class);
            hasStaticInitializerMethod.setAccessible(true);
        }
        return hasStaticInitializerMethod;
    }

    @Override
    public MethodHandle writeObjectForSerialization(Class<?> cl) {
        return Bridge.toMethodHandle(Bridge.getPrivateMethod(cl, "writeObject", Void.TYPE, ObjectOutputStream.class));
    }

    private static MethodHandle toMethodHandle(Method method) {
        try {
            if (method == null) {
                return null;
            }
            method.setAccessible(true);
            MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
            method.setAccessible(false);
            return methodHandle;
        }
        catch (IllegalAccessException | SecurityException e) {
            return null;
        }
    }

    private static Method getPrivateMethod(Class<?> cl, String name, Class<?> returnType, Class<?> ... argTypes) {
        try {
            Method method = cl.getDeclaredMethod(name, argTypes);
            return method.getReturnType() == returnType && Bridge.isPrivate(method) && !Bridge.isStatic(method) ? method : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    private static boolean isPrivate(Method method) {
        return Modifier.isPrivate(method.getModifiers());
    }

    @Override
    public MethodHandle readObjectForSerialization(Class<?> cl) {
        return Bridge.toMethodHandle(Bridge.getPrivateMethod(cl, "readObject", Void.TYPE, ObjectInputStream.class));
    }

    @Override
    public MethodHandle readResolveForSerialization(Class<?> cl) {
        return Bridge.toMethodHandle(Bridge.getInheritableMethod(cl, "readResolve", Object.class, new Class[0]));
    }

    private static Method getInheritableMethod(Class<?> cl, String name, Class<?> returnType, Class<?> ... argTypes) {
        Method method = Bridge.getMatchingMethod(cl, name, returnType, argTypes);
        return method != null && Bridge.isMethodInheritableBy(cl, method) ? method : null;
    }

    private static Method getMatchingMethod(Class<?> cl, String name, Class<?> returnType, Class<?>[] argTypes) {
        for (Class<?> aClass = cl; aClass != null; aClass = aClass.getSuperclass()) {
            try {
                Method method = aClass.getDeclaredMethod(name, argTypes);
                return method.getReturnType() == returnType ? method : null;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        return null;
    }

    private static boolean isMethodInheritableBy(Class<?> callingClass, Method method) {
        Class<?> baseClass = method.getDeclaringClass();
        int mods = method.getModifiers();
        if ((mods & 0x408) != 0) {
            return false;
        }
        if ((mods & 5) != 0) {
            return true;
        }
        if ((mods & 2) != 0) {
            return callingClass == baseClass;
        }
        return Bridge.packageEquals(callingClass, baseClass);
    }

    private static boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        Package pkg2;
        Package pkg1 = cl1.getPackage();
        return pkg1 == (pkg2 = cl2.getPackage()) || pkg1 != null && pkg1.equals(pkg2);
    }

    @Override
    public MethodHandle writeReplaceForSerialization(Class<?> cl) {
        return Bridge.toMethodHandle(Bridge.getInheritableMethod(cl, "writeReplace", Object.class, new Class[0]));
    }

    @Override
    public OptionalDataException newOptionalDataExceptionForSerialization(boolean endOfData) {
        try {
            return this.optionalDataExceptionConstructor.newInstance(endOfData);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new Error("Unable to create OptionalDataException");
        }
    }
}

