/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.deployment.util.ConnectorArchivist;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.deployment.deploy.shared.MemoryMappedArchive;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.config.types.Property;
import org.xml.sax.SAXException;

public class ConnectorDDTransformUtils {
    static Logger _logger = LogDomains.getLogger(ConnectorDDTransformUtils.class, (String)"jakarta.enterprise.resource.resourceadapter");

    public static ConnectorDescriptorInfo getConnectorDescriptorInfo(ConnectionDefDescriptor connectionDefDescriptor) {
        ConnectorDescriptorInfo connectorDescInfo = new ConnectorDescriptorInfo();
        connectorDescInfo.setConnectionDefinitionName(connectionDefDescriptor.getConnectionFactoryIntf());
        connectorDescInfo.setManagedConnectionFactoryClass(connectionDefDescriptor.getManagedConnectionFactoryImpl());
        connectorDescInfo.setConnectionFactoryClass(connectionDefDescriptor.getConnectionFactoryImpl());
        connectorDescInfo.setConnectionFactoryInterface(connectionDefDescriptor.getConnectionFactoryIntf());
        connectorDescInfo.setConnectionInterface(connectionDefDescriptor.getConnectionIntf());
        connectorDescInfo.setConnectionClass(connectionDefDescriptor.getConnectionImpl());
        connectorDescInfo.setMCFConfigProperties(connectionDefDescriptor.getConfigProperties());
        return connectorDescInfo;
    }

    public static Set<ConnectorConfigProperty> mergeProps(List<Property> props, Set<ConnectorConfigProperty> defaultMCFProps, Properties propertiesToSkip) {
        HashSet<ConnectorConfigProperty> mergedSet = new HashSet<ConnectorConfigProperty>();
        if (defaultMCFProps != null) {
            ConnectorConfigProperty[] defaultProps;
            for (ConnectorConfigProperty ep1 : defaultProps = (ConnectorConfigProperty[])defaultMCFProps.toArray(ConnectorConfigProperty[]::new)) {
                if (propertiesToSkip.containsKey(ep1.getName())) {
                    String propertyValue = (String)propertiesToSkip.get(ep1.getName());
                    if (ep1.getValue() != null && propertyValue != null && ep1.getValue().equals(propertyValue)) continue;
                }
                mergedSet.add(ep1);
            }
        }
        for (Property property : props) {
            ConnectorConfigProperty ep = new ConnectorConfigProperty(property.getName(), property.getValue(), null);
            if (defaultMCFProps.contains(ep)) {
                for (ConnectorConfigProperty envProp : defaultMCFProps) {
                    if (!envProp.equals((Object)ep)) continue;
                    if (envProp.getType() != null) {
                        ep.setType(envProp.getType());
                    }
                    ep.setConfidential(envProp.isConfidential());
                }
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.log(Level.FINER, "After merging props with defaultMCFProps: envPropName: " + ep.getName() + " envPropValue : " + ep.getValue());
                }
                mergedSet.remove(ep);
            }
            mergedSet.add(ep);
        }
        return mergedSet;
    }

    public static Set<ConnectorConfigProperty> mergeProps(List<Property> props, Set<ConnectorConfigProperty> defaultMCFProps) {
        return ConnectorDDTransformUtils.mergeProps(props, defaultMCFProps, new Properties());
    }

    public static ConnectorDescriptor getConnectorDescriptor(String moduleDir, String rarModuleName) throws ConnectorRuntimeException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader loader;
            File module = new File(moduleDir);
            FileArchive fileArchive = new FileArchive();
            fileArchive.open(module.toURI());
            ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
            if (ConnectorsUtil.belongsToSystemRA((String)rarModuleName)) {
                loader = ConnectorRuntime.getRuntime().getSystemRARClassLoader(rarModuleName);
                Thread.currentThread().setContextClassLoader(loader);
            } else {
                loader = runtime.createConnectorClassLoader(moduleDir, null, rarModuleName);
            }
            ConnectorArchivist connectorArchivist = runtime.getConnectorArchvist();
            connectorArchivist.setClassLoader(loader);
            connectorArchivist.setAnnotationProcessingRequested(true);
            ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)connectorArchivist.open((ReadableArchive)fileArchive);
            return connectorDescriptor;
        }
        catch (IOException ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to read the connector deployment descriptors");
            cre.initCause((Throwable)ex);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_read_error", moduleDir);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        catch (SAXException ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException("Failed to parse the connector deployment descriptors");
            cre.initCause((Throwable)ex);
            _logger.log(Level.SEVERE, "rardeployment.connector_descriptor_parse_error", moduleDir);
            _logger.log(Level.SEVERE, "", cre);
            throw cre;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static ConnectionDefDescriptor[] getConnectionDefs(ConnectorDescriptor connectorDesc) {
        ConnectionDefDescriptor[] connectionDefDescs = new ConnectionDefDescriptor[]{};
        OutboundResourceAdapter ora = connectorDesc.getOutboundResourceAdapter();
        if (ora != null) {
            Set connectionDefs = ora.getConnectionDefs();
            Iterator iter = connectionDefs.iterator();
            int size = connectionDefs.size();
            connectionDefDescs = new ConnectionDefDescriptor[size];
            for (int i = 0; i < size; ++i) {
                connectionDefDescs[i] = (ConnectionDefDescriptor)iter.next();
            }
        }
        return connectionDefDescs;
    }

    public static String getResourceAdapterClassName(String rarLocation) {
        block4: {
            try {
                FileInputStream fis = new FileInputStream(rarLocation);
                MemoryMappedArchive mma = new MemoryMappedArchive((InputStream)fis);
                ConnectorArchivist ca = new ConnectorArchivist();
                ConnectorDescriptor cd = (ConnectorDescriptor)ca.open((ReadableArchive)mma);
                return cd.getResourceAdapterClass();
            }
            catch (IOException e) {
                _logger.info(e.getMessage());
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Error while trying to read connector descriptor to get resource-adapter properties", e);
                }
            }
            catch (SAXException e) {
                _logger.info(e.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.log(Level.FINE, "Error while trying to read connector descriptor to get resource-adapter properties", e);
            }
        }
        return null;
    }

    public MessageListener[] getMessageListeners(ConnectorDescriptor desc) {
        InboundResourceAdapter inboundRA = null;
        Set messageListenerSet = null;
        if (desc != null && (inboundRA = desc.getInboundResourceAdapter()) != null) {
            messageListenerSet = inboundRA.getMessageListeners();
        }
        if (messageListenerSet == null) {
            return null;
        }
        int size = messageListenerSet.size();
        MessageListener[] messageListeners = new MessageListener[size];
        Iterator iter = messageListenerSet.iterator();
        for (int i = 0; i < size; ++i) {
            messageListeners[i] = (MessageListener)iter.next();
        }
        return messageListeners;
    }
}

