/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.ServletFilter;
import java.util.Collection;
import java.util.Objects;
import java.util.Vector;
import org.glassfish.deployment.common.Descriptor;

public class ServletFilterDescriptor
extends Descriptor
implements ServletFilter {
    private static final long serialVersionUID = 139903056507907238L;
    private String className = "";
    private String displayName = "";
    private String filterName = "";
    private final Vector<InitializationParameter> initParms = new Vector();
    private Boolean asyncSupported;
    private boolean conflict;

    public ServletFilterDescriptor() {
        super("", "");
        this.setClassName("");
    }

    public ServletFilterDescriptor(String className, String name) {
        super(name, "");
        this.setClassName(className);
    }

    public void setClassName(String name) {
        this.className = name != null ? name : "";
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = "";
        }
        return this.className;
    }

    public void setDisplayName(String name) {
        this.displayName = name == null ? "" : name;
    }

    public String getDisplayName() {
        String n = this.displayName;
        if (n == null || n.isEmpty()) {
            n = this.getName();
        }
        return n;
    }

    public boolean hasSetDisplayName() {
        return this.displayName != null && !this.displayName.isEmpty();
    }

    public void setName(String filterName) {
        this.filterName = filterName;
    }

    public String getName() {
        if (this.filterName == null || this.filterName.isEmpty()) {
            String c = this.getClassName();
            int p = c.lastIndexOf(46);
            this.filterName = p < 0 ? c : c.substring(p + 1);
        }
        return this.filterName;
    }

    public void setInitializationParameters(Collection<InitializationParameter> c) {
        this.initParms.clear();
        this.initParms.addAll(c);
    }

    public Vector<InitializationParameter> getInitializationParameters() {
        return (Vector)this.initParms.clone();
    }

    public void addInitializationParameter(InitializationParameter ref) {
        this.initParms.addElement(ref);
    }

    public void addInitializationParameter(EnvironmentProperty ref) {
        this.addInitializationParameter((InitializationParameter)ref);
    }

    public void removeInitializationParameter(InitializationParameter ref) {
        this.initParms.removeElement(ref);
    }

    public void setAsyncSupported(Boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public Boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setConflict(boolean conflict) {
        this.conflict = conflict;
    }

    public boolean isConflict() {
        return this.conflict;
    }

    public boolean isConflict(ServletFilterDescriptor other) {
        if (this.conflict || other.isConflict()) {
            return true;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        boolean matchClassName = this.getClassName().isEmpty() || other.getClassName().isEmpty() || this.getClassName().equals(other.getClassName());
        boolean otherAsyncSupported = other.isAsyncSupported() == null ? false : other.isAsyncSupported();
        boolean thisAsyncSupported = this.asyncSupported == null ? false : this.asyncSupported;
        boolean matchAsyncSupported = thisAsyncSupported == otherAsyncSupported;
        return !matchClassName || !matchAsyncSupported;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServletFilter && this.getClassName().equals(((ServletFilter)obj).getClassName()) && this.getName().equals(((ServletFilter)obj).getName());
    }

    public int hashCode() {
        return Objects.hash(this.getClassName(), this.getName());
    }
}

