/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.applicationimpl.events;

import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventInfo {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private final Class<? extends SystemEvent> systemEvent;
    private final Class<?> sourceClass;
    private final Set<SystemEventListener> listeners;
    private Constructor eventConstructor;
    private final Map<Class<?>, Constructor> constructorMap;

    public EventInfo(Class<? extends SystemEvent> systemEvent, Class<?> sourceClass) {
        this.systemEvent = systemEvent;
        this.sourceClass = sourceClass;
        this.listeners = new CopyOnWriteArraySet<SystemEventListener>();
        this.constructorMap = new HashMap();
        if (!sourceClass.equals(Void.class)) {
            this.eventConstructor = this.getEventConstructor(sourceClass);
        }
    }

    public Set<SystemEventListener> getListeners() {
        return this.listeners;
    }

    public SystemEvent createSystemEvent(Object source) {
        Constructor toInvoke = this.getCachedConstructor(source.getClass());
        if (toInvoke != null) {
            try {
                return (SystemEvent)toInvoke.newInstance(source);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new FacesException(e);
            }
        }
        return null;
    }

    private Constructor getCachedConstructor(Class<?> source) {
        if (this.eventConstructor != null) {
            return this.eventConstructor;
        }
        Constructor c = this.constructorMap.get(source);
        if (c == null && (c = this.getEventConstructor(source)) != null) {
            this.constructorMap.put(source, c);
        }
        return c;
    }

    private Constructor getEventConstructor(Class<?> source) {
        Constructor ctor = null;
        try {
            return this.systemEvent.getDeclaredConstructor(source);
        }
        catch (NoSuchMethodException ignored) {
            Constructor<?>[] ctors = this.systemEvent.getConstructors();
            if (ctors != null) {
                for (Constructor<?> c : ctors) {
                    Class<?>[] params = c.getParameterTypes();
                    if (params.length != 1 || !params[0].isAssignableFrom(source)) continue;
                    return c;
                }
            }
            if (this.eventConstructor == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find Constructor within {0} that accepts {1} instances.", new Object[]{this.systemEvent.getName(), this.sourceClass.getName()});
            }
            return ctor;
        }
    }
}

