/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.jacc;

import jakarta.security.jacc.PolicyContextException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Map;

public interface PolicyConfiguration {
    public String getContextID() throws PolicyContextException;

    default public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException {
        for (Permission permission : Collections.list(permissions.elements())) {
            this.addToRole(roleName, permission);
        }
    }

    public void addToRole(String var1, Permission var2) throws PolicyContextException;

    default public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException {
        for (Permission permission : Collections.list(permissions.elements())) {
            this.addToUncheckedPolicy(permission);
        }
    }

    public void addToUncheckedPolicy(Permission var1) throws PolicyContextException;

    default public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException {
        for (Permission permission : Collections.list(permissions.elements())) {
            this.addToExcludedPolicy(permission);
        }
    }

    public void addToExcludedPolicy(Permission var1) throws PolicyContextException;

    public Map<String, PermissionCollection> getPerRolePermissions();

    public PermissionCollection getUncheckedPermissions();

    public PermissionCollection getExcludedPermissions();

    public void removeRole(String var1) throws PolicyContextException;

    public void removeUncheckedPolicy() throws PolicyContextException;

    public void removeExcludedPolicy() throws PolicyContextException;

    public void linkConfiguration(PolicyConfiguration var1) throws PolicyContextException;

    public void delete() throws PolicyContextException;

    default public void commit() throws PolicyContextException {
    }

    default public boolean inService() throws PolicyContextException {
        return true;
    }
}

