/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class TimeOfDayMetadata
extends ORMetadata {
    private Integer m_hour;
    private Integer m_millisecond;
    private Integer m_minute;
    private Integer m_second;

    public TimeOfDayMetadata() {
        super("<time-of-day>");
    }

    public TimeOfDayMetadata(MetadataAnnotation timeOfDay, MetadataAccessor accessor) {
        super(timeOfDay, accessor);
        this.m_hour = timeOfDay.getAttributeInteger("hour");
        this.m_millisecond = timeOfDay.getAttributeInteger("millisecond");
        this.m_minute = timeOfDay.getAttributeInteger("minute");
        this.m_second = timeOfDay.getAttributeInteger("second");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TimeOfDayMetadata) {
            TimeOfDayMetadata timeOfDay = (TimeOfDayMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_hour, timeOfDay.getHour())) {
                return false;
            }
            if (!this.valuesMatch(this.m_millisecond, timeOfDay.getMillisecond())) {
                return false;
            }
            if (!this.valuesMatch(this.m_minute, timeOfDay.getMinute())) {
                return false;
            }
            return this.valuesMatch(this.m_second, timeOfDay.getSecond());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_hour != null ? this.m_hour.hashCode() : 0);
        result = 31 * result + (this.m_millisecond != null ? this.m_millisecond.hashCode() : 0);
        result = 31 * result + (this.m_minute != null ? this.m_minute.hashCode() : 0);
        result = 31 * result + (this.m_second != null ? this.m_second.hashCode() : 0);
        return result;
    }

    public Integer getHour() {
        return this.m_hour;
    }

    public Integer getMillisecond() {
        return this.m_millisecond;
    }

    public Integer getMinute() {
        return this.m_minute;
    }

    public Integer getSecond() {
        return this.m_second;
    }

    public Integer processHour() {
        return this.m_hour == null ? Integer.valueOf(0) : this.m_hour;
    }

    public Integer processMillisecond() {
        return this.m_millisecond == null ? Integer.valueOf(0) : this.m_millisecond;
    }

    public Integer processMinute() {
        return this.m_minute == null ? Integer.valueOf(0) : this.m_minute;
    }

    public Integer processSecond() {
        return this.m_second == null ? Integer.valueOf(0) : this.m_second;
    }

    public void setHour(Integer hour) {
        this.m_hour = hour;
    }

    public void setMillisecond(Integer millisecond) {
        this.m_millisecond = millisecond;
    }

    public void setMinute(Integer minute) {
        this.m_minute = minute;
    }

    public void setSecond(Integer second) {
        this.m_second = second;
    }
}

