/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.IdentifierToken;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.javac.SourceMember;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Node;
import org.glassfish.rmic.tools.tree.Statement;
import org.glassfish.rmic.tools.tree.Vset;

public class MemberDefinition
implements Constants {
    protected long where;
    protected int modifiers;
    protected Type type;
    protected String documentation;
    protected IdentifierToken[] expIds;
    protected ClassDeclaration[] exp;
    protected Node value;
    protected ClassDefinition clazz;
    protected Identifier name;
    protected ClassDefinition innerClass;
    protected MemberDefinition nextMember;
    protected MemberDefinition nextMatch;
    protected MemberDefinition accessPeer;
    protected boolean superAccessMethod;
    private static Map<String, MemberDefinition> proxyCache;
    static final int PUBLIC_ACCESS = 1;
    static final int PROTECTED_ACCESS = 2;
    static final int PACKAGE_ACCESS = 3;
    static final int PRIVATE_ACCESS = 4;

    public MemberDefinition(long where, ClassDefinition clazz, int modifiers, Type type, Identifier name, IdentifierToken[] expIds, Node value) {
        if (expIds == null) {
            expIds = new IdentifierToken[]{};
        }
        this.where = where;
        this.clazz = clazz;
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.expIds = expIds;
        this.value = value;
    }

    public MemberDefinition(ClassDefinition innerClass) {
        this(innerClass.getWhere(), innerClass.getOuterClass(), innerClass.getModifiers(), innerClass.getType(), innerClass.getName().getFlatName().getName(), null, null);
        this.innerClass = innerClass;
    }

    public static MemberDefinition makeProxyMember(MemberDefinition field, ClassDefinition classDef, Environment env) {
        String key;
        MemberDefinition proxy;
        if (proxyCache == null) {
            proxyCache = new HashMap<String, MemberDefinition>();
        }
        if ((proxy = proxyCache.get(key = field.toString() + "@" + classDef.toString())) != null) {
            return proxy;
        }
        proxy = new MemberDefinition(field.getWhere(), classDef, field.getModifiers(), field.getType(), field.getName(), field.getExceptionIds(), null);
        proxy.exp = field.getExceptions(env);
        proxyCache.put(key, proxy);
        return proxy;
    }

    public String getMemberValueString(Environment env) throws ClassNotFound {
        return null;
    }

    public final long getWhere() {
        return this.where;
    }

    public final ClassDeclaration getClassDeclaration() {
        return this.clazz.getClassDeclaration();
    }

    public void resolveTypeStructure(Environment env) {
    }

    public ClassDeclaration getDefiningClassDeclaration() {
        return this.getClassDeclaration();
    }

    public final ClassDefinition getClassDefinition() {
        return this.clazz;
    }

    public final ClassDefinition getTopClass() {
        return this.clazz.getTopClass();
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final void subModifiers(int mod) {
        this.modifiers &= ~mod;
    }

    public final void addModifiers(int mod) {
        this.modifiers |= mod;
    }

    public final Type getType() {
        return this.type;
    }

    public final Identifier getName() {
        return this.name;
    }

    public Vector<MemberDefinition> getArguments() {
        return this.isMethod() ? new Vector() : null;
    }

    public ClassDeclaration[] getExceptions(Environment env) {
        if (this.expIds != null && this.exp == null) {
            if (this.expIds.length == 0) {
                this.exp = new ClassDeclaration[0];
            } else {
                throw new CompilerError("getExceptions " + this);
            }
        }
        return this.exp;
    }

    public final IdentifierToken[] getExceptionIds() {
        return this.expIds;
    }

    public ClassDefinition getInnerClass() {
        return this.innerClass;
    }

    public boolean isUplevelValue() {
        if (!this.isSynthetic() || !this.isVariable() || this.isStatic()) {
            return false;
        }
        String name = this.name.toString();
        return name.startsWith("val$") || name.startsWith("loc$") || name.startsWith("this$");
    }

    public boolean isAccessMethod() {
        return this.isSynthetic() && this.isMethod() && this.accessPeer != null;
    }

    public MemberDefinition getAccessMethodTarget() {
        if (this.isAccessMethod()) {
            MemberDefinition f = this.accessPeer;
            while (f != null) {
                if (!f.isAccessMethod()) {
                    return f;
                }
                f = f.accessPeer;
            }
        }
        return null;
    }

    public void setAccessMethodTarget(MemberDefinition target) {
        if (this.getAccessMethodTarget() != target) {
            if (this.accessPeer != null || target.accessPeer != null) {
                throw new CompilerError("accessPeer");
            }
            this.accessPeer = target;
        }
    }

    public MemberDefinition getAccessUpdateMember() {
        if (this.isAccessMethod()) {
            MemberDefinition f = this.accessPeer;
            while (f != null) {
                if (f.isAccessMethod()) {
                    return f;
                }
                f = f.accessPeer;
            }
        }
        return null;
    }

    public void setAccessUpdateMember(MemberDefinition updater) {
        if (this.getAccessUpdateMember() != updater) {
            if (!this.isAccessMethod() || updater.getAccessMethodTarget() != this.getAccessMethodTarget()) {
                throw new CompilerError("accessPeer");
            }
            updater.accessPeer = this.accessPeer;
            this.accessPeer = updater;
        }
    }

    public final boolean isSuperAccessMethod() {
        return this.superAccessMethod;
    }

    public final void setIsSuperAccessMethod(boolean b) {
        this.superAccessMethod = b;
    }

    public final boolean isBlankFinal() {
        return this.isFinal() && !this.isSynthetic() && this.getValue() == null;
    }

    public boolean isNeverNull() {
        if (this.isUplevelValue()) {
            return !this.name.toString().startsWith("val$");
        }
        return false;
    }

    public Node getValue(Environment env) throws ClassNotFound {
        return this.value;
    }

    public final Node getValue() {
        return this.value;
    }

    public final void setValue(Node value) {
        this.value = value;
    }

    public Object getInitialValue() {
        return null;
    }

    public final MemberDefinition getNextMember() {
        return this.nextMember;
    }

    public final MemberDefinition getNextMatch() {
        return this.nextMatch;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void check(Environment env) throws ClassNotFound {
    }

    public Vset check(Environment env, Context ctx, Vset vset) throws ClassNotFound {
        return vset;
    }

    public void code(Environment env, Assembler asm) throws ClassNotFound {
        throw new CompilerError("code");
    }

    public void codeInit(Environment env, Context ctx, Assembler asm) throws ClassNotFound {
        throw new CompilerError("codeInit");
    }

    public boolean reportDeprecated(Environment env) {
        return this.isDeprecated() || this.clazz.reportDeprecated(env);
    }

    public final boolean canReach(Environment env, MemberDefinition f) {
        if (f.isLocal() || !f.isVariable() || !this.isVariable() && !this.isInitializer()) {
            return true;
        }
        if (this.getClassDeclaration().equals(f.getClassDeclaration()) && this.isStatic() == f.isStatic()) {
            while ((f = f.getNextMember()) != null && f != this) {
            }
            return f != null;
        }
        return true;
    }

    private int getAccessLevel() {
        if (this.isPublic()) {
            return 1;
        }
        if (this.isProtected()) {
            return 2;
        }
        if (this.isPackagePrivate()) {
            return 3;
        }
        if (this.isPrivate()) {
            return 4;
        }
        throw new CompilerError("getAccessLevel()");
    }

    private void reportError(Environment env, String errorString, ClassDeclaration clazz, MemberDefinition method) {
        if (clazz == null) {
            env.error(this.getWhere(), errorString, this, this.getClassDeclaration(), method.getClassDeclaration());
        } else {
            env.error(clazz.getClassDefinition().getWhere(), errorString, this, this.getClassDeclaration(), method.getClassDeclaration());
        }
    }

    public boolean sameReturnType(MemberDefinition method) {
        Type yourReturnType;
        if (!this.isMethod() || !method.isMethod()) {
            throw new CompilerError("sameReturnType: not method");
        }
        Type myReturnType = this.getType().getReturnType();
        return myReturnType == (yourReturnType = method.getType().getReturnType());
    }

    public boolean checkOverride(Environment env, MemberDefinition method) {
        return this.checkOverride(env, method, null);
    }

    private boolean checkOverride(Environment env, MemberDefinition method, ClassDeclaration clazz) {
        boolean success = true;
        if (!this.isMethod()) {
            throw new CompilerError("checkOverride(), expected method");
        }
        if (this.isSynthetic()) {
            if (method.isFinal() || method.isConstructor() || method.isStatic() || !this.isStatic()) {
                // empty if block
            }
            return true;
        }
        if (this.getName() != method.getName() || !this.getType().equalArguments(method.getType())) {
            throw new CompilerError("checkOverride(), signature mismatch");
        }
        if (method.isStatic() && !this.isStatic()) {
            this.reportError(env, "override.static.with.instance", clazz, method);
            success = false;
        }
        if (!method.isStatic() && this.isStatic()) {
            this.reportError(env, "hide.instance.with.static", clazz, method);
            success = false;
        }
        if (method.isFinal()) {
            this.reportError(env, "override.final.method", clazz, method);
            success = false;
        }
        if (method.reportDeprecated(env) && !this.isDeprecated() && this instanceof SourceMember) {
            this.reportError(env, "warn.override.is.deprecated", clazz, method);
        }
        if (this.getAccessLevel() > method.getAccessLevel()) {
            this.reportError(env, "override.more.restrictive", clazz, method);
            success = false;
        }
        if (!this.sameReturnType(method)) {
            // empty if block
        }
        if (!this.exceptionsFit(env, method)) {
            this.reportError(env, "override.incompatible.exceptions", clazz, method);
            success = false;
        }
        return success;
    }

    public boolean checkMeet(Environment env, MemberDefinition method, ClassDeclaration clazz) {
        if (!this.isMethod()) {
            throw new CompilerError("checkMeet(), expected method");
        }
        if (!this.isAbstract() && !method.isAbstract()) {
            throw new CompilerError("checkMeet(), no abstract method");
        }
        if (!this.isAbstract()) {
            return this.checkOverride(env, method, clazz);
        }
        if (!method.isAbstract()) {
            return method.checkOverride(env, this, clazz);
        }
        if (this.getName() != method.getName() || !this.getType().equalArguments(method.getType())) {
            throw new CompilerError("checkMeet(), signature mismatch");
        }
        if (!this.sameReturnType(method)) {
            env.error(clazz.getClassDefinition().getWhere(), "meet.different.return", this, this.getClassDeclaration(), method.getClassDeclaration());
            return false;
        }
        return true;
    }

    public boolean couldOverride(Environment env, MemberDefinition method) {
        if (!this.isMethod()) {
            throw new CompilerError("coulcOverride(), expected method");
        }
        if (!method.isAbstract()) {
            return false;
        }
        if (this.getAccessLevel() > method.getAccessLevel()) {
            return false;
        }
        return this.exceptionsFit(env, method);
    }

    private boolean exceptionsFit(Environment env, MemberDefinition method) {
        ClassDeclaration[] e1 = this.getExceptions(env);
        ClassDeclaration[] e2 = method.getExceptions(env);
        block2: for (int i = 0; i < e1.length; ++i) {
            try {
                ClassDefinition c1 = e1[i].getClassDefinition(env);
                for (int j = 0; j < e2.length; ++j) {
                    if (c1.subClassOf(env, e2[j])) continue block2;
                }
                if (c1.subClassOf(env, env.getClassDeclaration(idJavaLangError)) || c1.subClassOf(env, env.getClassDeclaration(idJavaLangRuntimeException))) continue;
                return false;
            }
            catch (ClassNotFound ee) {
                env.error(this.getWhere(), "class.not.found", ee.name, method.getClassDeclaration());
            }
        }
        return true;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isMethod() {
        return this.type.isType(12);
    }

    public final boolean isVariable() {
        return !this.type.isType(12) && this.innerClass == null;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x40000) != 0;
    }

    public final boolean isStrict() {
        return (this.modifiers & 0x200000) != 0;
    }

    public final boolean isInnerClass() {
        return this.innerClass != null;
    }

    public final boolean isInitializer() {
        return this.getName().equals(idClassInit);
    }

    public final boolean isConstructor() {
        return this.getName().equals(idInit);
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isInlineable(Environment env, boolean fromFinal) throws ClassNotFound {
        return (this.isStatic() || this.isPrivate() || this.isFinal() || this.isConstructor() || fromFinal) && !this.isSynchronized() && !this.isNative();
    }

    public boolean isConstant() {
        if (this.isFinal() && this.isVariable() && this.value != null) {
            try {
                this.modifiers &= 0xFFFFFFEF;
                boolean bl = ((Expression)this.value).isConstant();
                return bl;
            }
            finally {
                this.modifiers |= 0x10;
            }
        }
        return false;
    }

    public String toString() {
        Identifier name = this.getClassDefinition().getName();
        if (this.isInitializer()) {
            return this.isStatic() ? "static {}" : "instance {}";
        }
        if (this.isConstructor()) {
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append('(');
            Type[] argTypes = this.getType().getArgumentTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(argTypes[i].toString());
            }
            sb.append(')');
            return sb.toString();
        }
        if (this.isInnerClass()) {
            return this.getInnerClass().toString();
        }
        return this.type.typeString(this.getName().toString());
    }

    public void print(PrintStream out) {
        if (this.isPublic()) {
            out.print("public ");
        }
        if (this.isPrivate()) {
            out.print("private ");
        }
        if (this.isProtected()) {
            out.print("protected ");
        }
        if (this.isFinal()) {
            out.print("final ");
        }
        if (this.isStatic()) {
            out.print("static ");
        }
        if (this.isSynchronized()) {
            out.print("synchronized ");
        }
        if (this.isAbstract()) {
            out.print("abstract ");
        }
        if (this.isNative()) {
            out.print("native ");
        }
        if (this.isVolatile()) {
            out.print("volatile ");
        }
        if (this.isTransient()) {
            out.print("transient ");
        }
        out.println(this.toString() + ";");
    }

    public void cleanup(Environment env) {
        this.documentation = null;
        if (this.isMethod() && this.value != null) {
            int cost = 0;
            if (this.isPrivate() || this.isInitializer()) {
                this.value = Statement.empty;
            } else {
                cost = ((Statement)this.value).costInline(Statement.MAXINLINECOST, null, null);
                if (cost >= Statement.MAXINLINECOST) {
                    this.value = Statement.empty;
                } else {
                    try {
                        if (!this.isInlineable(null, true)) {
                            this.value = Statement.empty;
                        }
                    }
                    catch (ClassNotFound classNotFound) {
                        // empty catch block
                    }
                }
            }
            if (this.value != Statement.empty && env.dump()) {
                env.output("[after cleanup of " + this.getName() + ", " + cost + " expression cost units remain]");
            }
        } else if (this.isVariable() && (this.isPrivate() || !this.isFinal() || this.type.isType(9))) {
            this.value = null;
        }
    }
}

