/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.handler;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fx.ide.jdt.core.internal.BuildPathSupport;
import org.eclipse.fx.ide.jdt.ui.internal.editors.model.anttasks.AntTask;
import org.eclipse.fx.ide.jdt.ui.internal.handler.SetupDirectory;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractAntHandler
extends AbstractHandler {
    protected IJavaProject project;

    protected BuildConfiguration prepareBuild(IFile f, AntTask task) {
        IFolder t;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        BuildConfiguration config = new BuildConfiguration();
        config.task = task;
        this.project = JavaCore.create((IProject)f.getProject());
        IPath[] paths = BuildPathSupport.getFxJarPath((IJavaProject)this.project);
        if (paths != null) {
            config.jfxjar = paths[0].toFile().getAbsolutePath();
            config.jfxantjar = paths[2].toFile().getAbsolutePath();
        }
        if (task.getBuildDirectory() == null) {
            DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.setText("Staging Directory");
            String directory = dialog.open();
            if (directory == null) {
                return null;
            }
            config.buildDirectory = directory;
        } else {
            config.buildDirectory = this.resolvePath(task.getBuildDirectory(), this.project.getProject());
        }
        config.projectName = f.getProject().getName();
        config.keyStore = task.getSignjar().getKeystore() != null ? this.resolvePath(task.getSignjar().getKeystore(), this.project.getProject()) : null;
        try {
            config.projectEncoding = f.getProject().getDefaultCharset();
            config.sourceCompliance = this.project.getOption("org.eclipse.jdt.core.compiler.source", true);
            config.targetCompliance = this.project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        HashSet<IPath> listProjectSourceDirs = new HashSet<IPath>();
        HashSet<IPath> listRefProjectSourceDirs = new HashSet<IPath>();
        HashSet<IPath> listRefLibraries = new HashSet<IPath>();
        this.resolveDataProject(this.project, listProjectSourceDirs, listRefProjectSourceDirs, listRefLibraries);
        HashSet<String> set = new HashSet<String>();
        HashSet<File> set2 = new HashSet<File>();
        for (IPath p : listRefLibraries) {
            set.add(p.lastSegment());
            IFile file = root.getFile(p);
            if (file != null && file.exists()) {
                p = file.getLocation();
            }
            set2.add(p.toFile());
        }
        config.externalLibs = set;
        config.origExternalLibs = set2;
        set = new HashSet();
        set2 = new HashSet();
        for (IPath p : listProjectSourceDirs) {
            t = root.getFolder(p);
            set.add(t.getProjectRelativePath().toString());
            if (t.isLinked()) {
                set2.add((File)((Object)new SetupDirectory(t.getLocation().toFile().getParentFile(), new File(t.getProjectRelativePath().toString()))));
                continue;
            }
            set2.add((File)((Object)new SetupDirectory(t.getProject().getLocation().toFile(), new File(t.getProjectRelativePath().toString()))));
        }
        config.projectSourceDirs = set;
        config.origProjectSourceDirs = set2;
        set = new HashSet();
        set2 = new HashSet();
        for (IPath p : listRefProjectSourceDirs) {
            t = root.getFolder(p);
            set.add(t.getProject().getName() + "/" + String.valueOf(t.getProjectRelativePath()));
            set2.add((File)((Object)new SetupDirectory(t.getProject().getLocation().toFile().getParentFile(), new File(t.getProject().getName() + "/" + t.getProjectRelativePath().toString()))));
        }
        config.projectRefSourceDirs = set;
        config.origProjectRefSourceDirs = set2;
        return config;
    }

    public final String resolvePath(String basePath, IProject project) {
        String path;
        if (basePath.contains("${workspace}")) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource res = root.findMember(basePath.replace("${workspace}", ""));
            if (res != null) {
                path = res.getLocation().makeAbsolute().toString();
            } else {
                String workbench = root.getLocation().toString();
                path = basePath.replace("${workspace}", workbench);
            }
        } else {
            path = project != null && basePath.contains("${project}") ? basePath.replace("${project}", project.getLocation().toString()) : basePath;
        }
        return path;
    }

    private void resolveDataProject(IJavaProject project, Set<IPath> listProjectSourceDirs, Set<IPath> listRefProjectSourceDirs, Set<IPath> listRefLibraries) {
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = project.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String start;
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 2) {
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(e.getPath().lastSegment());
                    if (p.exists()) {
                        this.resolveDataProject(JavaCore.create((IProject)p), listRefProjectSourceDirs, listRefProjectSourceDirs, listRefLibraries);
                    }
                } else if (e.getEntryKind() == 1) {
                    listRefLibraries.add(e.getPath());
                } else if (e.getEntryKind() == 3) {
                    listProjectSourceDirs.add(e.getPath());
                } else if (e.getEntryKind() == 5 && !"org.eclipse.jdt.launching.JRE_CONTAINER".equals(start = e.getPath().segment(0)) && !"org.eclipse.fx.ide.jdt.core.JAVAFX_CONTAINER".equals(start)) {
                    IClasspathEntry[] cpEntries;
                    IClasspathContainer cpe = JavaCore.getClasspathContainer((IPath)e.getPath(), (IJavaProject)project);
                    IClasspathEntry[] iClasspathEntryArray2 = cpEntries = cpe.getClasspathEntries();
                    int n3 = cpEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry tmp = iClasspathEntryArray2[n4];
                        if (tmp.getEntryKind() == 1) {
                            listRefLibraries.add(tmp.getPath());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public class BuildConfiguration {
        public Set<SetupDirectory> origProjectRefSourceDirs;
        public Set<String> projectRefSourceDirs;
        public Set<SetupDirectory> origProjectSourceDirs;
        public Set<String> projectSourceDirs;
        public Set<File> origExternalLibs;
        public Set<String> externalLibs;
        public String targetCompliance;
        public String projectEncoding;
        public String sourceCompliance;
        public Object keyStore;
        public String projectName;
        public Object builderName;
        public String buildDirectory;
        public String jfxantjar;
        public String jfxjar;
        public AntTask task;
    }
}

