/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GroupOrderStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class DFSNodeOrderCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);
    private List<LNode> sources;
    private boolean[] visited;
    private boolean[] active;
    private List<LEdge> edgesToBeReversed;
    private LGraph graph;

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Depth-first cycle removal", 1.0f);
        this.graph = graph;
        List<LNode> nodes = graph.getLayerlessNodes();
        int nodeCount = nodes.size();
        this.sources = new ArrayList<LNode>();
        this.visited = new boolean[nodeCount];
        this.active = new boolean[nodeCount];
        this.edgesToBeReversed = new ArrayList<LEdge>();
        int index = 0;
        for (LNode node : nodes) {
            node.id = index;
            if (Iterables.isEmpty(node.getIncomingEdges())) {
                this.sources.add(node);
            }
            ++index;
        }
        for (LNode source : this.sources) {
            this.dfs(source);
        }
        int i = 0;
        while (i < nodeCount) {
            if (!this.visited[i]) {
                LNode n = nodes.get(i);
                assert (n.id == i);
                this.dfs(n);
            }
            ++i;
        }
        for (LEdge edge : this.edgesToBeReversed) {
            edge.reverse(graph, true);
            graph.setProperty(InternalProperties.CYCLIC, true);
        }
        this.sources = null;
        this.visited = null;
        this.active = null;
        this.edgesToBeReversed = null;
        monitor.done();
    }

    private void dfs(LNode n) {
        if (this.visited[n.id]) {
            return;
        }
        this.visited[n.id] = true;
        this.active[n.id] = true;
        HashMap modelOrderMap = new HashMap();
        boolean groupModelOrder = this.graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CB_GROUP_ORDER_STRATEGY) == GroupOrderStrategy.ENFORCED;
        n.getOutgoingEdges().forEach(e -> {
            if (e.getTarget().getNode().getProperty(InternalProperties.MODEL_ORDER) == null) {
                modelOrderMap.put(Integer.MAX_VALUE - modelOrderMap.size(), new HashSet<LEdge>(Arrays.asList(e)));
            } else {
                int targetModelOrder = 0;
                LNode target = e.getTarget().getNode();
                if (groupModelOrder) {
                    int maxModelOrderGroupSize = (Integer)this.graph.getProperty(InternalProperties.MAX_MODEL_ORDER_NODES);
                    targetModelOrder = maxModelOrderGroupSize * (Integer)target.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CYCLE_BREAKING_ID) + (Integer)target.getProperty(InternalProperties.MODEL_ORDER);
                } else {
                    targetModelOrder = (Integer)e.getTarget().getNode().getProperty(InternalProperties.MODEL_ORDER);
                }
                if (modelOrderMap.containsKey(targetModelOrder)) {
                    ((HashSet)modelOrderMap.get(targetModelOrder)).add(e);
                } else {
                    modelOrderMap.put(targetModelOrder, new HashSet<LEdge>(Arrays.asList(e)));
                }
            }
        });
        TreeSet modelOrderSet = new TreeSet(modelOrderMap.keySet());
        Iterator iterator = modelOrderSet.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            LEdge out = (LEdge)((Object)((HashSet)modelOrderMap.get(key)).iterator().next());
            if (out.isSelfLoop()) continue;
            LNode target = out.getTarget().getNode();
            if (this.active[target.id]) {
                this.edgesToBeReversed.addAll((Collection)modelOrderMap.get(key));
                continue;
            }
            this.dfs(target);
        }
        this.active[n.id] = false;
    }
}

