/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eunit.junit;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eunit.EUnitModule;
import org.eclipse.epsilon.eunit.EUnitTest;
import org.eclipse.epsilon.eunit.EUnitTestListener;
import org.eclipse.epsilon.eunit.EUnitTestResultType;
import org.eclipse.epsilon.eunit.junit.IEUnitSuite;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class EUnitTestRunner
extends ParentRunner<EUnitTest> {
    private Map<EUnitTest, Description> testDescriptions = new IdentityHashMap<EUnitTest, Description>();
    protected EUnitModule module;
    protected IEUnitSuite suiteInstance;

    public EUnitTestRunner(Class<? extends IEUnitSuite> testClass) throws InitializationError {
        super(testClass);
        try {
            this.suiteInstance = testClass.newInstance();
            URI moduleURI = this.suiteInstance.getModuleURI();
            this.module = new EUnitModule();
            this.module.parse(moduleURI);
            OperationContributor contrib = this.suiteInstance.getOperationContributor();
            if (contrib != null) {
                this.module.getContext().getOperationContributorRegistry().add(contrib);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InitializationError((Throwable)e);
        }
    }

    protected List<EUnitTest> getChildren() {
        try {
            return Arrays.asList(this.module.getSuiteRoot());
        }
        catch (EolRuntimeException e) {
            e.printStackTrace();
            return new ArrayList<EUnitTest>();
        }
    }

    protected Description describeChild(EUnitTest child) {
        if (this.testDescriptions.containsKey(child)) {
            return this.testDescriptions.get(child);
        }
        Description desc = child.isRootTest() ? Description.createSuiteDescription((Class)this.getTestClass().getJavaClass()) : Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)child.getCaseName());
        for (EUnitTest c : child.getChildren()) {
            desc.addChild(this.describeChild(c));
        }
        this.testDescriptions.put(child, desc);
        return desc;
    }

    protected void runChild(EUnitTest child, RunNotifier notifier) {
        Description thisDesc = this.describeChild(child);
        if (child.isRootTest()) {
            try {
                JUnitEUnitTestListener listener = new JUnitEUnitTestListener(notifier);
                this.module.addTestListener((EUnitTestListener)listener);
                this.module.execute();
                this.module.removeTestListener((EUnitTestListener)listener);
            }
            catch (EolRuntimeException e) {
                notifier.fireTestFailure(new Failure(thisDesc, (Throwable)e));
            }
        }
    }

    protected class JUnitEUnitTestListener
    implements EUnitTestListener {
        private final RunNotifier notifier;

        private JUnitEUnitTestListener(RunNotifier notifier) {
            this.notifier = notifier;
        }

        public void beforeCase(EUnitModule module, EUnitTest test) {
            Description desc = EUnitTestRunner.this.describeChild(test);
            this.notifier.fireTestStarted(desc);
            if (test.getResult().equals((Object)EUnitTestResultType.SKIPPED)) {
                this.notifier.fireTestIgnored(desc);
            }
            if (test.isLeafTest()) {
                ModelRepository repository = module.getContext().getModelRepository();
                repository.dispose();
                try {
                    List<IModel> models = EUnitTestRunner.this.suiteInstance.prepareModels();
                    if (models != null) {
                        for (IModel model : models) {
                            repository.addModel(model);
                        }
                    }
                }
                catch (Exception e) {
                    test.setResult(EUnitTestResultType.ERROR);
                    test.setException(e);
                }
            }
        }

        public void afterCase(EUnitModule module, EUnitTest test) {
            EUnitTestResultType res;
            Description desc = EUnitTestRunner.this.describeChild(test);
            if (test.isLeafTest() && ((res = test.getResult()).equals((Object)EUnitTestResultType.FAILURE) || res.equals((Object)EUnitTestResultType.ERROR))) {
                this.notifier.fireTestFailure(new Failure(desc, (Throwable)test.getException()));
            }
            this.notifier.fireTestFinished(desc);
        }
    }
}

