/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.json.dt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.dt.launching.dialogs.AbstractCachedModelConfigurationDialog;
import org.eclipse.epsilon.common.dt.launching.dialogs.AbstractModelConfigurationDialog;
import org.eclipse.epsilon.emc.json.dt.HeaderNameEditingSupport;
import org.eclipse.epsilon.emc.json.dt.HeaderValueEditingSupport;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class JsonModelConfigurationDialog
extends AbstractCachedModelConfigurationDialog {
    protected Label fileTextLabel;
    protected Text fileText;
    protected Button browseModelFile;
    protected Button filebasedButton;
    protected Label uriTextLabel;
    protected Text uriText;
    protected TableViewer headersTable;
    protected List<Header> headers = new ArrayList<Header>();
    private Button btnAddHeader;
    private Button btnRemoveHeader;
    private Button btnClearHeaders;

    protected String getModelName() {
        return "JSON Document";
    }

    protected String getModelType() {
        return "JSON";
    }

    protected void createGroups(Composite control) {
        super.createGroups(control);
        this.createFilesGroup(control);
        this.createLoadStoreOptionsGroup(control);
        this.toggleEnabledFields();
    }

    protected void toggleEnabledFields() {
        boolean isFileBased = this.filebasedButton.getSelection();
        this.fileTextLabel.setEnabled(isFileBased);
        this.fileText.setEnabled(isFileBased);
        this.storeOnDisposalCheckbox.setEnabled(isFileBased);
        if (!isFileBased) {
            this.fileText.setText("");
            this.storeOnDisposalCheckbox.setSelection(false);
        }
        this.uriTextLabel.setEnabled(!isFileBased);
        this.uriText.setEnabled(!isFileBased);
        this.headersTable.getTable().setEnabled(!isFileBased);
        this.btnAddHeader.setEnabled(!isFileBased);
        this.btnRemoveHeader.setEnabled(!isFileBased);
        this.btnClearHeaders.setEnabled(!isFileBased);
        if (isFileBased) {
            this.uriText.setText("");
            this.headers.clear();
            this.headersTable.refresh();
        }
    }

    protected Composite createFilesGroup(Composite parent) {
        Composite groupContent = JsonModelConfigurationDialog.createGroupContainer((Composite)parent, (String)"Files/URIs", (int)3);
        this.filebasedButton = new Button(groupContent, 32);
        GridData filebasedButtonGridData = new GridData(768);
        filebasedButtonGridData.horizontalSpan = 3;
        this.filebasedButton.setSelection(true);
        this.filebasedButton.setText("Workspace file");
        this.filebasedButton.setLayoutData((Object)filebasedButtonGridData);
        this.filebasedButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                JsonModelConfigurationDialog.this.toggleEnabledFields();
            }
        });
        this.fileTextLabel = new Label(groupContent, 0);
        this.fileTextLabel.setText("File: ");
        this.fileText = new Text(groupContent, 2048);
        this.fileText.setLayoutData((Object)new GridData(768));
        this.browseModelFile = new Button(groupContent, 0);
        this.browseModelFile.setText("Browse Workspace...");
        this.browseModelFile.addListener(13, (Listener)new AbstractModelConfigurationDialog.BrowseWorkspaceForModelsListener((AbstractModelConfigurationDialog)this, this.fileText, "XML Documents in the workspace", "Select an XML document"));
        this.uriTextLabel = new Label(groupContent, 0);
        this.uriTextLabel.setText("URI: ");
        this.uriText = new Text(groupContent, 2048);
        GridData uriTextGridData = new GridData(768);
        uriTextGridData.horizontalSpan = 2;
        this.uriText.setLayoutData((Object)uriTextGridData);
        this.createHeadersTable(groupContent);
        groupContent.layout();
        groupContent.pack();
        return groupContent;
    }

    private void createHeadersTable(Composite groupContent) {
        this.headersTable = new TableViewer(groupContent, 68354);
        GridData headersTableGridData = new GridData(1808);
        headersTableGridData.horizontalSpan = 2;
        this.headersTable.getTable().setLayoutData((Object)headersTableGridData);
        this.headersTable.getTable().setLinesVisible(true);
        this.headersTable.getTable().setHeaderVisible(true);
        this.createTableColumns();
        this.createHeadersTableButtons(groupContent);
        this.headersTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.headersTable.setInput(this.headers);
    }

    private void createHeadersTableButtons(Composite groupContent) {
        Composite headerButtons = new Composite(groupContent, 0);
        FillLayout headerButtonsLayout = new FillLayout(512);
        headerButtons.setLayout((Layout)headerButtonsLayout);
        headerButtonsLayout.spacing = 4;
        GridData headerButtonsGridData = new GridData(768);
        headerButtonsGridData.horizontalSpan = 1;
        headerButtons.setLayoutData((Object)headerButtonsGridData);
        this.btnAddHeader = new Button(headerButtons, 0);
        this.btnAddHeader.setText("Add");
        this.btnAddHeader.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.headers.add(new Header("header", "value"));
            this.headersTable.refresh();
        }));
        this.btnRemoveHeader = new Button(headerButtons, 0);
        this.btnRemoveHeader.setText("Remove");
        this.btnRemoveHeader.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.headersTable.getStructuredSelection().forEach(o -> this.headers.remove((Header)o));
            this.headersTable.refresh();
        }));
        this.btnClearHeaders = new Button(headerButtons, 0);
        this.btnClearHeaders.setText("Clear");
        this.btnClearHeaders.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.headers.clear();
            this.headersTable.refresh();
        }));
    }

    private void createTableColumns() {
        TableViewerColumn colHeader = new TableViewerColumn(this.headersTable, 0);
        colHeader.getColumn().setWidth(200);
        colHeader.getColumn().setText("Header");
        colHeader.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Header)element).name;
            }
        });
        colHeader.setEditingSupport((EditingSupport)new HeaderNameEditingSupport(this.headersTable));
        TableViewerColumn colValue = new TableViewerColumn(this.headersTable, 0);
        colValue.getColumn().setWidth(400);
        colValue.getColumn().setText("Value");
        colValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Header)element).value;
            }
        });
        colValue.setEditingSupport((EditingSupport)new HeaderValueEditingSupport(this.headersTable));
    }

    protected void loadProperties() {
        super.loadProperties();
        if (this.properties == null) {
            return;
        }
        this.fileText.setText(this.properties.getProperty("file"));
        this.uriText.setText(this.properties.getProperty("uri"));
        this.headers.clear();
        for (Map.Entry e : this.properties.entrySet()) {
            String nameValue;
            int indexOfSeparator;
            if (!e.getKey().toString().startsWith("header") || (indexOfSeparator = (nameValue = e.getValue().toString()).indexOf(58)) < 0) continue;
            this.headers.add(new Header(nameValue.substring(0, indexOfSeparator), nameValue.substring(indexOfSeparator + 1)));
        }
        this.headersTable.refresh();
        this.filebasedButton.setSelection(this.properties.getProperty("file", "").trim().length() > 0);
        this.toggleEnabledFields();
    }

    protected void storeProperties() {
        super.storeProperties();
        this.properties.put((Object)"uri", (Object)this.uriText.getText().trim());
        this.properties.put((Object)"file", (Object)this.fileText.getText().trim());
        int iHeader = 0;
        for (Header header : this.headers) {
            this.properties.put((Object)("header" + iHeader), (Object)String.format("%s%s%s", header.name.trim(), Character.valueOf(':'), header.value.trim()));
            ++iHeader;
        }
    }

    public static class Header {
        public String name;
        public String value;

        public Header() {
        }

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

