/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.dictionary.model.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.emc.simulink.dictionary.model.SimulinkDictionaryModel;
import org.eclipse.epsilon.emc.simulink.dictionary.model.element.ISimulinkDictionaryModelElement;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.MatlabHandleElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class SimulinkDataType
extends SimulinkModelElement
implements ISimulinkDictionaryModelElement {
    protected MatlabHandleElement dataType;
    protected String type;
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public SimulinkDataType(SimulinkDictionaryModel model, MatlabEngine engine, String type) {
        super((IGenericSimulinkModel)model, engine);
        if (!type.startsWith("Simulink.")) {
            throw new IllegalStateException("Wrong type " + type);
        }
        try {
            this.dataType = new MatlabHandleElement((IGenericSimulinkModel)model, engine, (HandleObject)engine.fevalWithResult(type, new Object[0]));
            this.type = type;
        }
        catch (MatlabException e) {
            throw new IllegalStateException();
        }
    }

    public SimulinkDataType(SimulinkDictionaryModel model, MatlabEngine engine, HandleObject entryHandle) {
        super((IGenericSimulinkModel)model, engine);
        this.dataType = new MatlabHandleElement((IGenericSimulinkModel)model, engine, entryHandle);
        try {
            this.type = (String)engine.fevalWithResult("class", new Object[]{entryHandle});
        }
        catch (MatlabException e) {
            throw new IllegalStateException();
        }
    }

    public Object getProperty(String property) throws EolRuntimeException {
        return this.dataType.getProperty(property);
    }

    public void setProperty(String property, Object value) throws EolRuntimeException {
        this.dataType.setProperty(property, value);
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        try {
            this.engine.feval("deleteEntry", new Object[]{this.dataType.getHandle()});
            return true;
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList("Entry");
    }

    public String getType() {
        return this.type;
    }

    public Object getHandle() {
        return this.dataType.getHandle();
    }
}

