/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;
import xpt.Externalizer;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.ResourceSetInfo;
import xpt.editor.ResourceSetModificationListener;

@Singleton
public class DocumentProvider {
    @Inject
    @Extension
    private Common _common;
    @Inject
    private Activator xptActivator;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private ResourceSetInfo xptResourceSetInfo;
    @Inject
    private ResourceSetModificationListener xptResourceSetModificationListener;
    @Inject
    private DiagramEditorUtil xptDiagramEditorUtil;

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _documentProviderClassName = it.getDocumentProviderClassName();
        _builder.append((Object)_documentProviderClassName, "");
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenEditorView _editor = _editorGen.getEditor();
        String _packageName = _editor.getPackageName();
        _builder.append((Object)_packageName, "");
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    public CharSequence extendsList(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"extends org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider");
        return _builder;
    }

    public CharSequence implementsList(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"implements org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider");
        return _builder;
    }

    public CharSequence DocumentProvider(GenDiagram it) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        CharSequence _copyright = this._common.copyright(_editorGen);
        _builder.append((Object)_copyright, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)" ");
        CharSequence _extendsList = this.extendsList(it);
        _builder.append((Object)_extendsList, "");
        _builder.append((Object)" ");
        CharSequence _implementsList = this.implementsList(it);
        _builder.append((Object)_implementsList, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _createElementInfo = this.createElementInfo(it);
        _builder.append((Object)_createElementInfo, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _createDocument = this.createDocument(it);
        _builder.append((Object)_createDocument, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _setupDocument = this.setupDocument(it);
        _builder.append((Object)_setupDocument, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _computeModificationStamp = this.computeModificationStamp(it);
        _builder.append((Object)_computeModificationStamp, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _createEmptyDocument = this.createEmptyDocument(it);
        _builder.append((Object)_createEmptyDocument, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _createEditingDomain = this.createEditingDomain(it);
        _builder.append((Object)_createEditingDomain, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _setDocumentContent = this.setDocumentContent(it);
        _builder.append((Object)_setDocumentContent, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _modificationStamp = this.getModificationStamp(it);
        _builder.append((Object)_modificationStamp, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _isDeleted = this.isDeleted(it);
        _builder.append((Object)_isDeleted, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _resourceSetInfo = this.getResourceSetInfo(it);
        _builder.append((Object)_resourceSetInfo, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _disposeElementInfo = this.disposeElementInfo(it);
        _builder.append((Object)_disposeElementInfo, "\t");
        _builder.newLineIfNotEmpty();
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenApplication _application = _editorGen_1.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _doValidateState = this.doValidateState(it);
            _builder.append((Object)_doValidateState, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _isReadOnly = this.isReadOnly(it);
        _builder.append((Object)_isReadOnly, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _isModifiable = this.isModifiable(it);
        _builder.append((Object)_isModifiable, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _updateCache = this.updateCache(it);
        _builder.append((Object)_updateCache, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _doUpdateStateCache = this.doUpdateStateCache(it);
        _builder.append((Object)_doUpdateStateCache, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _isSynchronized = this.isSynchronized(it);
        _builder.append((Object)_isSynchronized, "\t");
        _builder.newLineIfNotEmpty();
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        GenApplication _application_1 = _editorGen_2.getApplication();
        boolean _equals_1 = Objects.equal(null, (Object)_application_1);
        if (_equals_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _resetRule = this.getResetRule(it);
            _builder.append((Object)_resetRule, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _saveRule = this.getSaveRule(it);
            _builder.append((Object)_saveRule, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _synchronizeRule = this.getSynchronizeRule(it);
            _builder.append((Object)_synchronizeRule, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _validateStateRule = this.getValidateStateRule(it);
            _builder.append((Object)_validateStateRule, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _computeSchedulingRule = this.computeSchedulingRule(it);
            _builder.append((Object)_computeSchedulingRule, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _doSynchronize = this.doSynchronize(it);
        _builder.append((Object)_doSynchronize, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _doSaveDocument = this.doSaveDocument(it);
        _builder.append((Object)_doSaveDocument, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _handleElementChanged = this.handleElementChanged(it);
        _builder.append((Object)_handleElementChanged, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _handleElementMoved = this.handleElementMoved(it);
        _builder.append((Object)_handleElementMoved, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _createInputWithEditingDomain = this.createInputWithEditingDomain(it);
        _builder.append((Object)_createInputWithEditingDomain, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _diagramDocument = this.getDiagramDocument(it);
        _builder.append((Object)_diagramDocument, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _operationRunner = this.getOperationRunner(it);
        _builder.append((Object)_operationRunner, "\t");
        _builder.newLineIfNotEmpty();
        GenEditorGenerator _editorGen_3 = it.getEditorGen();
        GenApplication _application_2 = _editorGen_3.getApplication();
        boolean bl = _notEquals = !Objects.equal(null, (Object)_application_2);
        if (_notEquals) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _file = this.getFile(it);
            _builder.append((Object)_file, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _ResourceSetInfo = this.xptResourceSetInfo.ResourceSetInfo(it);
        _builder.append((Object)_ResourceSetInfo, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _ResourceSetModificationListener = this.xptResourceSetModificationListener.ResourceSetModificationListener(it);
        _builder.append((Object)_ResourceSetModificationListener, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createElementInfo(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected ElementInfo createElementInfo(Object element) throws org.eclipse.core.runtime.CoreException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _checkEditorInputInstance = this.checkEditorInputInstance(it);
        _builder.append((Object)_checkEditorInputInstance, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.ui.IEditorInput editorInput = (org.eclipse.ui.IEditorInput) element;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument document = (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) createDocument(editorInput);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = new ResourceSetInfo(document, editorInput);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"info.setModificationStamp(computeModificationStamp(info));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"info.fStatus = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return info;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence checkEditorInputInstance(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"false == element instanceof ");
            CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
            _builder.append((Object)_fileEditorInputClassFQName, "");
            _builder.append((Object)" && ");
        }
        _builder.append((Object)"false == element instanceof ");
        CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
        _builder.append((Object)_uriEditorInputClassFQName, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _throwIncorrectInputException = this.throwIncorrectInputException(it);
        _builder.append((Object)_throwIncorrectInputException, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence throwIncorrectInputException(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenPlugin _plugin = _editorGen.getPlugin();
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName, "");
        _builder.append((Object)".ID, 0, ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.osgi.util.NLS.bind(");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        String _i18nKeyForDocumentProviderIncorrectInputError = this.i18nKeyForDocumentProviderIncorrectInputError(it);
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen_1, _i18nKeyForDocumentProviderIncorrectInputError);
        _builder.append((Object)_accessorCall, "\t\t\t");
        _builder.append((Object)",");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"new Object[] {element, ");
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        GenApplication _application = _editorGen_2.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"\"");
            CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
            _builder.append((Object)_fileEditorInputClassFQName, "\t\t\t");
            _builder.append((Object)"\", ");
        }
        _builder.append((Object)"\"");
        CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
        _builder.append((Object)_uriEditorInputClassFQName, "\t\t\t");
        _builder.append((Object)"\"}), ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t");
        GenEditorGenerator _editorGen_3 = it.getEditorGen();
        GenApplication _application_1 = _editorGen_3.getApplication();
        boolean _equals_1 = Objects.equal(null, (Object)_application_1);
        if (_equals_1) {
            _builder.append((Object)" ");
            CharSequence _nonNLS_1 = this._common.nonNLS(2);
            _builder.append((Object)_nonNLS_1, "\t\t\t");
        }
        _builder.append((Object)" ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"null));");
        _builder.newLine();
        return _builder;
    }

    public CharSequence fileEditorInputClassFQName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.ui.part.FileEditorInput");
        return _builder;
    }

    public CharSequence uriEditorInputClassFQName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.eclipse.emf.common.ui.URIEditorInput");
        return _builder;
    }

    public CharSequence createDocument(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument createDocument(Object element) throws org.eclipse.core.runtime.CoreException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _checkEditorInputInstance = this.checkEditorInputInstance(it);
        _builder.append((Object)_checkEditorInputInstance, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document = createEmptyDocument();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"setDocumentContent(document, (org.eclipse.ui.IEditorInput) element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"setupDocument(element, document);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return document;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setupDocument(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Sets up the given document as it would be provided for the given element. The\ncontent of the document is not changed. This default implementation is empty.\nSubclasses may reimplement.\n\n@param element the blue-print element\n@param document the document to set up");
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void setupDocument(Object element, org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// for subclasses");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence computeModificationStamp(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private long computeModificationStamp(ResourceSetInfo info) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int result = 0;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (file != null) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (file.getLocation() != null) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"result += file.getLocation().toFile().lastModified();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"} else {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"result += file.getModificationStamp();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"java.io.File file = getFile(nextResource);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (file != null && file.exists()) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"result += file.lastModified();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return result;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createEmptyDocument(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument createEmptyDocument() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument document = new org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"document.setEditingDomain(createEditingDomain());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return document;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createEditingDomain(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private org.eclipse.emf.transaction.TransactionalEditingDomain createEditingDomain() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain = org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory.getInstance().createEditingDomain();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"editingDomain.setID(\"");
        String _editingDomainID = it.getEditingDomainID();
        _builder.append((Object)_editingDomainID, "\t");
        _builder.append((Object)"\"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"final org.eclipse.emf.transaction.NotificationFilter diagramResourceModifiedFilter = org.eclipse.emf.transaction.NotificationFilter.createNotifierFilter(editingDomain.getResourceSet()).and(org.eclipse.emf.transaction.NotificationFilter.createEventTypeFilter(org.eclipse.emf.common.notify.Notification.ADD)).and(org.eclipse.emf.transaction.NotificationFilter.createFeatureFilter(org.eclipse.emf.ecore.resource.ResourceSet.class, org.eclipse.emf.ecore.resource.ResourceSet.RESOURCE_SET__RESOURCES));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"editingDomain.getResourceSet().eAdapters().add(new org.eclipse.emf.common.notify.Adapter() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private org.eclipse.emf.common.notify.Notifier myTarger;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public org.eclipse.emf.common.notify.Notifier getTarget() {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return myTarger;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public boolean isAdapterForType(Object type) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return false;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public void notifyChanged(org.eclipse.emf.common.notify.Notification notification) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (diagramResourceModifiedFilter.matches(notification)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"Object value = notification.getNewValue();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (value instanceof org.eclipse.emf.ecore.resource.Resource) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"((org.eclipse.emf.ecore.resource.Resource) value).setTrackingModification(true);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public void setTarget(org.eclipse.emf.common.notify.Notifier newTarget) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"myTarger = newTarget;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"});\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return editingDomain;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setDocumentContent(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void setDocumentContent(org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document, org.eclipse.ui.IEditorInput element) throws org.eclipse.core.runtime.CoreException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument diagramDocument = (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) document;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.transaction.TransactionalEditingDomain domain = diagramDocument.getEditingDomain();");
        _builder.newLine();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"if (element instanceof ");
            CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
            _builder.append((Object)_fileEditorInputClassFQName, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.resources.IStorage storage = ((");
            CharSequence _fileEditorInputClassFQName_1 = this.fileEditorInputClassFQName(it);
            _builder.append((Object)_fileEditorInputClassFQName_1, "\t\t");
            _builder.append((Object)") element).getStorage();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.gmf.runtime.notation.Diagram diagram = org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil.load(domain, storage, true, getProgressMonitor());");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"document.setContent(diagram);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"} else ");
        }
        _builder.append((Object)"if(element instanceof ");
        CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
        _builder.append((Object)_uriEditorInputClassFQName, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.emf.common.util.URI uri = ((");
        CharSequence _uriEditorInputClassFQName_1 = this.uriEditorInputClassFQName(it);
        _builder.append((Object)_uriEditorInputClassFQName_1, "\t\t");
        _builder.append((Object)") element).getURI();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource resource = null;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"resource = domain.getResourceSet().getResource(uri.trimFragment(), false);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (resource == null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"resource = domain.getResourceSet().createResource(uri.trimFragment());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (!resource.isLoaded()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"java.util.Map options = new java.util.HashMap(org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory.getDefaultLoadOptions());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"// @see 171060 ");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"// options.put(org.eclipse.emf.ecore.xmi.XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"resource.load(options);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"} catch (java.io.IOException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"resource.unload();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"throw e;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (uri.fragment() != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.EObject rootElement = resource.getEObject(uri.fragment());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (rootElement instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"document.setContent((org.eclipse.gmf.runtime.notation.Diagram) rootElement);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"for (java.util.Iterator it = resource.getContents().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"Object rootElement = it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"if (rootElement instanceof org.eclipse.gmf.runtime.notation.Diagram) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"document.setContent((org.eclipse.gmf.runtime.notation.Diagram) rootElement);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new RuntimeException(");
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        String _i18nKeyForDocumentProviderNoDiagramInResourceError = this.i18nKeyForDocumentProviderNoDiagramInResourceError(it);
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen_1, _i18nKeyForDocumentProviderNoDiagramInResourceError);
        _builder.append((Object)_accessorCall, "\t\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.core.runtime.CoreException thrownExcp = null;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (e instanceof org.eclipse.core.runtime.CoreException) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"thrownExcp = (org.eclipse.core.runtime.CoreException) e;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"String msg = e.getLocalizedMessage();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"thrownExcp = new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        GenPlugin _plugin = _editorGen_2.getPlugin();
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName, "\t\t\t\t");
        _builder.append((Object)".ID, 0, ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"msg != null ? msg : ");
        GenEditorGenerator _editorGen_3 = it.getEditorGen();
        String _i18nKeyForDocumentProviderDiagramLoadingError = this.i18nKeyForDocumentProviderDiagramLoadingError(it);
        CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(_editorGen_3, _i18nKeyForDocumentProviderDiagramLoadingError);
        _builder.append((Object)_accessorCall_1, "\t\t\t\t");
        _builder.append((Object)", e));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw thrownExcp;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _throwIncorrectInputException = this.throwIncorrectInputException(it);
        _builder.append((Object)_throwIncorrectInputException, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}\t");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getModificationStamp(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public long getModificationStamp(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return computeModificationStamp(info);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return super.getModificationStamp(element);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isDeleted(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public boolean isDeleted(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument document = getDiagramDocument(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (document != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource diagramResource = document.getDiagram().eResource();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (diagramResource != null) {");
        _builder.newLine();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(diagramResource);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return file == null || file.getLocation() == null || !file.getLocation().toFile().exists();");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"java.io.File file = getFile(diagramResource);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return file != null && !file.exists();");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return super.isDeleted(element);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getResourceSetInfo(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ResourceSetInfo getResourceSetInfo(Object editorInput) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return (ResourceSetInfo) super.getElementInfo(editorInput);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence disposeElementInfo(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void disposeElementInfo(Object element, ElementInfo info) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info instanceof ResourceSetInfo) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ResourceSetInfo resourceSetInfo = (ResourceSetInfo) info;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"resourceSetInfo.dispose();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"super.disposeElementInfo(element, info);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence doValidateState(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void doValidateState(Object element, Object computationContext) throws org.eclipse.core.runtime.CoreException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.core.resources.IFile> files2Validate = new java.util.LinkedList<org.eclipse.core.resources.IFile>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (file != null && file.isReadOnly()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"files2Validate.add(file);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.core.resources.ResourcesPlugin.getWorkspace().validateEdit((org.eclipse.core.resources.IFile[]) files2Validate.toArray(new org.eclipse.core.resources.IFile[files2Validate.size()]), computationContext);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"super.doValidateState(element, computationContext);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isReadOnly(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public boolean isReadOnly(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _callUpdateCache = this.callUpdateCache(it);
        _builder.append((Object)_callUpdateCache, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return info.isReadOnly();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return super.isReadOnly(element);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isModifiable(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public boolean isModifiable(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (!isStateValidated(element)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"element instanceof ");
            CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
            _builder.append((Object)_fileEditorInputClassFQName, "\t\t");
            _builder.append((Object)" || ");
        }
        _builder.append((Object)"element instanceof ");
        CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
        _builder.append((Object)_uriEditorInputClassFQName, "\t\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return true;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _callUpdateCache = this.callUpdateCache(it);
        _builder.append((Object)_callUpdateCache, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return info.isModifiable();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return super.isModifiable(element);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence callUpdateCache(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"if (info.isUpdateCache()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"updateCache(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} catch (org.eclipse.core.runtime.CoreException ex) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenPlugin _plugin = _editorGen.getPlugin();
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append((Object)".getInstance().logError(");
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        String _i18nKeyForDocumentProviderIsModifiable = this.i18nKeyForDocumentProviderIsModifiable(it);
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen_1, _i18nKeyForDocumentProviderIsModifiable);
        _builder.append((Object)_accessorCall, "\t\t");
        _builder.append((Object)", ex);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// Error message to log was initially taken from org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages.StorageDocumentProvider_isModifiable");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence updateCache(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void updateCache(Object element) throws org.eclipse.core.runtime.CoreException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (file != null && file.isReadOnly()) {");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"java.io.File file = getFile(nextResource);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (file != null && file.exists() && !file.canWrite()) {");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"info.setReadOnly(true);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"info.setModifiable(false);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"info.setReadOnly(false);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"info.setModifiable(true);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence doUpdateStateCache(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void doUpdateStateCache(Object element) throws org.eclipse.core.runtime.CoreException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"info.setUpdateCache(true);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"super.doUpdateStateCache(element);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence isSynchronized(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public boolean isSynchronized(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return info.isSynchronized();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return super.isSynchronized(element);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getResetRule(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected org.eclipse.core.runtime.jobs.ISchedulingRule getResetRule(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (file != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"rules.add(org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(file));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new org.eclipse.core.runtime.jobs.MultiRule((org.eclipse.core.runtime.jobs.ISchedulingRule[]) rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getSaveRule(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected org.eclipse.core.runtime.jobs.ISchedulingRule getSaveRule(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (file != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"rules.add(computeSchedulingRule(file));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new org.eclipse.core.runtime.jobs.MultiRule((org.eclipse.core.runtime.jobs.ISchedulingRule[]) rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getSynchronizeRule(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected org.eclipse.core.runtime.jobs.ISchedulingRule getSynchronizeRule(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> rules = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (file != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"rules.add(org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule(file));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new org.eclipse.core.runtime.jobs.MultiRule((org.eclipse.core.runtime.jobs.ISchedulingRule[]) rules.toArray(new org.eclipse.core.runtime.jobs.ISchedulingRule[rules.size()]));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getValidateStateRule(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected org.eclipse.core.runtime.jobs.ISchedulingRule getValidateStateRule(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule> files = new java.util.LinkedList<org.eclipse.core.runtime.jobs.ISchedulingRule>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(nextResource);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (file != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"files.add(file);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().validateEditRule((org.eclipse.core.resources.IFile[]) files.toArray(new org.eclipse.core.resources.IFile[files.size()]));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence computeSchedulingRule(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private org.eclipse.core.runtime.jobs.ISchedulingRule computeSchedulingRule(org.eclipse.core.resources.IResource toCreateOrModify) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (toCreateOrModify.exists())");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(toCreateOrModify);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.core.resources.IResource parent = toCreateOrModify;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"do {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/*");
        _builder.newLine();
        _builder.append((Object)"\t\t ");
        _builder.append((Object)"* XXX This is a workaround for");
        _builder.newLine();
        _builder.append((Object)"\t\t ");
        _builder.append((Object)"* https://bugs.eclipse.org/bugs/show_bug.cgi?id=67601");
        _builder.newLine();
        _builder.append((Object)"\t\t ");
        _builder.append((Object)"* IResourceRuleFactory.createRule should iterate the hierarchy");
        _builder.newLine();
        _builder.append((Object)"\t\t ");
        _builder.append((Object)"* itself.");
        _builder.newLine();
        _builder.append((Object)"\t\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"toCreateOrModify = parent;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"parent = toCreateOrModify.getParent();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} while (parent != null && !parent.exists());");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRuleFactory().createRule(toCreateOrModify);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence doSynchronize(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void doSynchronize(Object element, org.eclipse.core.runtime.IProgressMonitor monitor) throws org.eclipse.core.runtime.CoreException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"handleElementChanged(info, nextResource, monitor);\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"super.doSynchronize(element, monitor);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handleElementChanged(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void handleElementChanged(ResourceSetInfo info, org.eclipse.emf.ecore.resource.Resource changedResource, org.eclipse.core.runtime.IProgressMonitor monitor) {");
        _builder.newLine();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.resources.IFile file = org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(changedResource);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (file != null) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"file.refreshLocal(org.eclipse.core.resources.IResource.DEPTH_INFINITE, monitor);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"} catch (org.eclipse.core.runtime.CoreException ex) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            GenEditorGenerator _editorGen_1 = it.getEditorGen();
            GenPlugin _plugin = _editorGen_1.getPlugin();
            CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
            _builder.append((Object)_qualifiedClassName, "\t\t\t");
            _builder.append((Object)".getInstance().logError(");
            GenEditorGenerator _editorGen_2 = it.getEditorGen();
            String _i18nKeyForDocumentProviderHandleElementContentChanged = this.i18nKeyForDocumentProviderHandleElementContentChanged(it);
            CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen_2, _i18nKeyForDocumentProviderHandleElementContentChanged);
            _builder.append((Object)_accessorCall, "\t\t\t");
            _builder.append((Object)", ex);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"// Error message to log was initially taken from org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages.FileDocumentProvider_handleElementContentChanged");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"changedResource.unload();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"fireElementContentAboutToBeReplaced(info.getEditorInput());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"removeUnchangedElementListeners(info.getEditorInput(), info);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"info.fStatus = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"setDocumentContent(info.fDocument, info.getEditorInput());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} catch (org.eclipse.core.runtime.CoreException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"info.fStatus = e.getStatus();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (!info.fCanBeSaved) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"info.setModificationStamp(computeModificationStamp(info));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"addUnchangedElementListeners(info.getEditorInput(), info);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"fireElementContentReplaced(info.getEditorInput());");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence doSaveDocument(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void doSaveDocument(org.eclipse.core.runtime.IProgressMonitor monitor, Object element, org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument document, boolean overwrite) throws org.eclipse.core.runtime.CoreException {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ResourceSetInfo info = getResourceSetInfo(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (info != null) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (!overwrite && !info.isSynchronized()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenPlugin _plugin = _editorGen.getPlugin();
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName, "\t\t\t");
        _builder.append((Object)".ID, ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenApplication _application = _editorGen_1.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"org.eclipse.core.resources.IResourceStatus.OUT_OF_SYNC_LOCAL");
        } else {
            _builder.append((Object)"org.eclipse.core.runtime.IStatus.ERROR");
        }
        _builder.append((Object)", ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        String _i18nKeyForDocumentUnsynchronizedFileSaveError = this.i18nKeyForDocumentUnsynchronizedFileSaveError(it);
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen_2, _i18nKeyForDocumentUnsynchronizedFileSaveError);
        _builder.append((Object)_accessorCall, "\t\t\t\t");
        _builder.append((Object)", ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"null));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GenEditorGenerator _editorGen_3 = it.getEditorGen();
        GenApplication _application_1 = _editorGen_3.getApplication();
        boolean _equals_1 = Objects.equal(null, (Object)_application_1);
        if (_equals_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"info.stopResourceListening();");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"fireElementStateChanging(element);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"monitor.beginTask(");
        GenEditorGenerator _editorGen_4 = it.getEditorGen();
        String _i18nKeyForDocumentSaveDiagramTask = this.i18nKeyForDocumentSaveDiagramTask(it);
        CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(_editorGen_4, _i18nKeyForDocumentSaveDiagramTask);
        _builder.append((Object)_accessorCall_1, "\t\t\t");
        _builder.append((Object)", info.getResourceSet().getResources().size() + 1); //\"Saving diagram\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"for (java.util.Iterator<org.eclipse.emf.ecore.resource.Resource> it = info.getLoadedResourcesIterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"org.eclipse.emf.ecore.resource.Resource nextResource = it.next();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"monitor.setTaskName(org.eclipse.osgi.util.NLS.bind(");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        GenEditorGenerator _editorGen_5 = it.getEditorGen();
        String _i18nKeyForDocumentSaveNextResourceTask = this.i18nKeyForDocumentSaveNextResourceTask(it);
        CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(_editorGen_5, _i18nKeyForDocumentSaveNextResourceTask);
        _builder.append((Object)_accessorCall_2, "\t\t\t\t\t\t");
        _builder.append((Object)", ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"nextResource.getURI()));");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (nextResource.isLoaded() && !info.getEditingDomain().isReadOnly(nextResource)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"nextResource.save(");
        CharSequence _callGetSaveOptions = this.xptDiagramEditorUtil.callGetSaveOptions(it);
        _builder.append((Object)_callGetSaveOptions, "\t\t\t\t\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"} catch (java.io.IOException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"fireElementStateChangeFailed(element);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
        GenEditorGenerator _editorGen_6 = it.getEditorGen();
        GenPlugin _plugin_1 = _editorGen_6.getPlugin();
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(_plugin_1);
        _builder.append((Object)_qualifiedClassName_1, "\t\t\t\t\t\t");
        _builder.append((Object)".ID, org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorStatusCodes.RESOURCE_FAILURE, e.getLocalizedMessage(), null));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"monitor.worked(1);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"monitor.done();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"info.setModificationStamp(computeModificationStamp(info));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (RuntimeException x) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fireElementStateChangeFailed(element);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw x;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} ");
        GenEditorGenerator _editorGen_7 = it.getEditorGen();
        GenApplication _application_2 = _editorGen_7.getApplication();
        boolean _equals_2 = Objects.equal(null, (Object)_application_2);
        if (_equals_2) {
            _builder.append((Object)" finally {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"info.startResourceListening();");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"} ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.emf.common.util.URI newResoruceURI;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.List<org.eclipse.core.resources.IFile> affectedFiles = null;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        GenEditorGenerator _editorGen_8 = it.getEditorGen();
        GenApplication _application_3 = _editorGen_8.getApplication();
        boolean _equals_3 = Objects.equal(null, (Object)_application_3);
        if (_equals_3) {
            _builder.append((Object)"if (element instanceof ");
            CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
            _builder.append((Object)_fileEditorInputClassFQName, "\t\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.resources.IFile newFile = ((");
            CharSequence _fileEditorInputClassFQName_1 = this.fileEditorInputClassFQName(it);
            _builder.append((Object)_fileEditorInputClassFQName_1, "\t\t\t");
            _builder.append((Object)") element).getFile();");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"affectedFiles = java.util.Collections.singletonList(newFile);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"newResoruceURI = org.eclipse.emf.common.util.URI.createPlatformResourceURI(newFile.getFullPath().toString(), true);");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"} else ");
        }
        _builder.append((Object)"if(element instanceof ");
        CharSequence _uriEditorInputClassFQName = this.uriEditorInputClassFQName(it);
        _builder.append((Object)_uriEditorInputClassFQName, "\t\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"newResoruceURI = ((");
        CharSequence _uriEditorInputClassFQName_1 = this.uriEditorInputClassFQName(it);
        _builder.append((Object)_uriEditorInputClassFQName_1, "\t\t\t");
        _builder.append((Object)") element).getURI();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fireElementStateChangeFailed(element);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        CharSequence _throwIncorrectInputException = this.throwIncorrectInputException(it);
        _builder.append((Object)_throwIncorrectInputException, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (false == document instanceof org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fireElementStateChangeFailed(element);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
        GenEditorGenerator _editorGen_9 = it.getEditorGen();
        GenPlugin _plugin_2 = _editorGen_9.getPlugin();
        CharSequence _qualifiedClassName_2 = this.xptActivator.qualifiedClassName(_plugin_2);
        _builder.append((Object)_qualifiedClassName_2, "\t\t\t");
        _builder.append((Object)".ID, 0,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"\"Incorrect document used: \" + document + \" instead of org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument\", null)); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t");
        _builder.append((Object)" ");
        CharSequence _nonNLS_1 = this._common.nonNLS(2);
        _builder.append((Object)_nonNLS_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument diagramDocument = (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) document;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final org.eclipse.emf.ecore.resource.Resource newResource = diagramDocument.getEditingDomain().getResourceSet().createResource(newResoruceURI);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final org.eclipse.gmf.runtime.notation.Diagram diagramCopy = (org.eclipse.gmf.runtime.notation.Diagram) org.eclipse.emf.ecore.util.EcoreUtil.copy(diagramDocument.getDiagram());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"new org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand(diagramDocument.getEditingDomain(), org.eclipse.osgi.util.NLS.bind(");
        GenEditorGenerator _editorGen_10 = it.getEditorGen();
        String _i18nKeyForDocumentSaveAs = this.i18nKeyForDocumentSaveAs(it);
        CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(_editorGen_10, _i18nKeyForDocumentSaveAs);
        _builder.append((Object)_accessorCall_3, "\t\t\t");
        _builder.append((Object)", diagramCopy.getName()), affectedFiles) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"protected org.eclipse.gmf.runtime.common.core.command.CommandResult doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor monitor, org.eclipse.core.runtime.IAdaptable info) throws org.eclipse.core.commands.ExecutionException {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"newResource.getContents().add(diagramCopy);\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"return org.eclipse.gmf.runtime.common.core.command.CommandResult.newOKCommandResult();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}.execute(monitor, null);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"newResource.save(");
        CharSequence _callGetSaveOptions_1 = this.xptDiagramEditorUtil.callGetSaveOptions(it);
        _builder.append((Object)_callGetSaveOptions_1, "\t\t\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (org.eclipse.core.commands.ExecutionException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fireElementStateChangeFailed(element);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
        GenEditorGenerator _editorGen_11 = it.getEditorGen();
        GenPlugin _plugin_3 = _editorGen_11.getPlugin();
        CharSequence _qualifiedClassName_3 = this.xptActivator.qualifiedClassName(_plugin_3);
        _builder.append((Object)_qualifiedClassName_3, "\t\t\t");
        _builder.append((Object)".ID, 0, e.getLocalizedMessage(), null));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (java.io.IOException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"fireElementStateChangeFailed(element);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new org.eclipse.core.runtime.CoreException(new org.eclipse.core.runtime.Status(org.eclipse.core.runtime.IStatus.ERROR, ");
        GenEditorGenerator _editorGen_12 = it.getEditorGen();
        GenPlugin _plugin_4 = _editorGen_12.getPlugin();
        CharSequence _qualifiedClassName_4 = this.xptActivator.qualifiedClassName(_plugin_4);
        _builder.append((Object)_qualifiedClassName_4, "\t\t\t");
        _builder.append((Object)".ID, 0, e.getLocalizedMessage(), null));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"newResource.unload();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence handleElementMoved(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected void handleElementMoved(org.eclipse.ui.IEditorInput input, org.eclipse.emf.common.util.URI uri) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal(null, (Object)_application);
        if (_equals) {
            _builder.append((Object)"if (input instanceof ");
            CharSequence _fileEditorInputClassFQName = this.fileEditorInputClassFQName(it);
            _builder.append((Object)_fileEditorInputClassFQName, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.resources.IFile newFile = org.eclipse.core.resources.ResourcesPlugin.getWorkspace().getRoot().getFile(new org.eclipse.core.runtime.Path(org.eclipse.emf.common.util.URI.decode(uri.path())).removeFirstSegments(1));");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"fireElementMoved(input, newFile == null ? null : new org.eclipse.ui.part.FileEditorInput(newFile));");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            CharSequence _extraLineBreak = this._common.extraLineBreak();
            _builder.append((Object)_extraLineBreak, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"// TODO: append suffix to the URI! (use diagram as a parameter)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"fireElementMoved(input, new org.eclipse.emf.common.ui.URIEditorInput(uri));");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createInputWithEditingDomain(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public org.eclipse.ui.IEditorInput createInputWithEditingDomain(org.eclipse.ui.IEditorInput editorInput, org.eclipse.emf.transaction.TransactionalEditingDomain domain) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return editorInput;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getDiagramDocument(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument getDiagramDocument(Object element) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument doc = getDocument(element);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (doc instanceof org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return (org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument) doc;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getOperationRunner(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"protected org.eclipse.jface.operation.IRunnableContext getOperationRunner(org.eclipse.core.runtime.IProgressMonitor monitor) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getFile(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static java.io.File getFile(org.eclipse.emf.ecore.resource.Resource resource) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.common.util.URI resourceUri = resource.getURI();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (resourceUri != null && resourceUri.isFile()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.io.File file = new java.io.File(resourceUri.toFileString());");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (!file.isDirectory()) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"return file;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _i18nKeyForDocumentProviderIsModifiable = this.i18nKeyForDocumentProviderIsModifiable(it);
        CharSequence _accessorField = this.xptExternalizer.accessorField(_i18nKeyForDocumentProviderIsModifiable);
        _builder.append((Object)_accessorField, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentProviderHandleElementContentChanged = this.i18nKeyForDocumentProviderHandleElementContentChanged(it);
        CharSequence _accessorField_1 = this.xptExternalizer.accessorField(_i18nKeyForDocumentProviderHandleElementContentChanged);
        _builder.append((Object)_accessorField_1, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentProviderIncorrectInputError = this.i18nKeyForDocumentProviderIncorrectInputError(it);
        CharSequence _accessorField_2 = this.xptExternalizer.accessorField(_i18nKeyForDocumentProviderIncorrectInputError);
        _builder.append((Object)_accessorField_2, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentProviderNoDiagramInResourceError = this.i18nKeyForDocumentProviderNoDiagramInResourceError(it);
        CharSequence _accessorField_3 = this.xptExternalizer.accessorField(_i18nKeyForDocumentProviderNoDiagramInResourceError);
        _builder.append((Object)_accessorField_3, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentProviderDiagramLoadingError = this.i18nKeyForDocumentProviderDiagramLoadingError(it);
        CharSequence _accessorField_4 = this.xptExternalizer.accessorField(_i18nKeyForDocumentProviderDiagramLoadingError);
        _builder.append((Object)_accessorField_4, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentUnsynchronizedFileSaveError = this.i18nKeyForDocumentUnsynchronizedFileSaveError(it);
        CharSequence _accessorField_5 = this.xptExternalizer.accessorField(_i18nKeyForDocumentUnsynchronizedFileSaveError);
        _builder.append((Object)_accessorField_5, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentSaveDiagramTask = this.i18nKeyForDocumentSaveDiagramTask(it);
        CharSequence _accessorField_6 = this.xptExternalizer.accessorField(_i18nKeyForDocumentSaveDiagramTask);
        _builder.append((Object)_accessorField_6, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentSaveNextResourceTask = this.i18nKeyForDocumentSaveNextResourceTask(it);
        CharSequence _accessorField_7 = this.xptExternalizer.accessorField(_i18nKeyForDocumentSaveNextResourceTask);
        _builder.append((Object)_accessorField_7, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentSaveAs = this.i18nKeyForDocumentSaveAs(it);
        CharSequence _accessorField_8 = this.xptExternalizer.accessorField(_i18nKeyForDocumentSaveAs);
        _builder.append((Object)_accessorField_8, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _i18nKeyForDocumentProviderIsModifiable = this.i18nKeyForDocumentProviderIsModifiable(it);
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(_i18nKeyForDocumentProviderIsModifiable, "Updating cache failed");
        _builder.append((Object)_messageEntry, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentProviderHandleElementContentChanged = this.i18nKeyForDocumentProviderHandleElementContentChanged(it);
        CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentProviderHandleElementContentChanged, "Failed to refresh hierarchy for changed resource");
        _builder.append((Object)_messageEntry_1, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentProviderIncorrectInputError = this.i18nKeyForDocumentProviderIncorrectInputError(it);
        String _xifexpression = null;
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        _xifexpression = _equals ? "{1} or {2}" : "{1}";
        String _plus = "Incorrect element used: {0} instead of " + _xifexpression;
        CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentProviderIncorrectInputError, _plus);
        _builder.append((Object)_messageEntry_2, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentProviderNoDiagramInResourceError = this.i18nKeyForDocumentProviderNoDiagramInResourceError(it);
        CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentProviderNoDiagramInResourceError, "Diagram is not present in resource");
        _builder.append((Object)_messageEntry_3, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentProviderDiagramLoadingError = this.i18nKeyForDocumentProviderDiagramLoadingError(it);
        CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentProviderDiagramLoadingError, "Error loading diagram");
        _builder.append((Object)_messageEntry_4, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentUnsynchronizedFileSaveError = this.i18nKeyForDocumentUnsynchronizedFileSaveError(it);
        CharSequence _messageEntry_5 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentUnsynchronizedFileSaveError, "The file has been changed on the file system");
        _builder.append((Object)_messageEntry_5, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentSaveDiagramTask = this.i18nKeyForDocumentSaveDiagramTask(it);
        CharSequence _messageEntry_6 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentSaveDiagramTask, "Saving diagram");
        _builder.append((Object)_messageEntry_6, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentSaveNextResourceTask = this.i18nKeyForDocumentSaveNextResourceTask(it);
        CharSequence _messageEntry_7 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentSaveNextResourceTask, "Saving {0}");
        _builder.append((Object)_messageEntry_7, "");
        _builder.newLineIfNotEmpty();
        String _i18nKeyForDocumentSaveAs = this.i18nKeyForDocumentSaveAs(it);
        CharSequence _messageEntry_8 = this.xptExternalizer.messageEntry(_i18nKeyForDocumentSaveAs, "Saving {0} diagram as");
        _builder.append((Object)_messageEntry_8, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence additions(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    @Localization
    public String i18nKeyForDocumentProvider(GenDiagram diagram) {
        CharSequence _className = this.className(diagram);
        return "" + _className;
    }

    @Localization
    public String i18nKeyForDocumentProviderIsModifiable(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + "_isModifiable";
    }

    @Localization
    public String i18nKeyForDocumentProviderHandleElementContentChanged(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + "_handleElementContentChanged";
    }

    @Localization
    public String i18nKeyForDocumentProviderIncorrectInputError(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + ".IncorrectInputError";
    }

    @Localization
    public String i18nKeyForDocumentProviderNoDiagramInResourceError(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + ".NoDiagramInResourceError";
    }

    @Localization
    public String i18nKeyForDocumentProviderDiagramLoadingError(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + ".DiagramLoadingError";
    }

    @Localization
    public String i18nKeyForDocumentUnsynchronizedFileSaveError(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + ".UnsynchronizedFileSaveError";
    }

    @Localization
    public String i18nKeyForDocumentSaveDiagramTask(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + ".SaveDiagramTask";
    }

    @Localization
    public String i18nKeyForDocumentSaveNextResourceTask(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + ".SaveNextResourceTask";
    }

    @Localization
    public String i18nKeyForDocumentSaveAs(GenDiagram diagram) {
        String _i18nKeyForDocumentProvider = this.i18nKeyForDocumentProvider(diagram);
        return String.valueOf(_i18nKeyForDocumentProvider) + ".SaveAsOperation";
    }
}

