/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.model.triggers.parent;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.gmfgraph.BasicFont;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooling.simplemap.model.triggers.parent.NewElementTrigger;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleChildNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLabelNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleParentNode;

public class NewLabelNodeTrigger
extends NewElementTrigger {
    private SimpleParentNode parent;
    private SimpleLabelNode newLabelNode;
    private BasicFont parentFont;

    public NewLabelNodeTrigger(TransactionalEditingDomain domain, SimpleParentNode parent, SimpleLabelNode newLabelNode) {
        super(domain, (SimpleChildNode)newLabelNode);
        this.newLabelNode = newLabelNode;
        this.parent = parent;
    }

    @Override
    public void executeTrigger() {
        DiagramLabel newLabel = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        Label parentLabel = this.getLabelFigure(this.parent);
        BasicFont parentBasicFont = parentLabel != null ? (BasicFont)parentLabel.getFont() : null;
        this.updateCanvas(newLabel, parentBasicFont);
        CreationTool newCreationTool = this.createNewTool();
        if (this.parent instanceof SimpleNode) {
            this.updateMapping((SimpleNode)this.parent, newLabel, newCreationTool);
        }
        if (this.parent instanceof SimpleCompartment) {
            SimpleNode parentNode = ((SimpleCompartment)this.parent).getParent();
            this.updateMapping(parentNode, newLabel, newCreationTool, ((SimpleCompartment)this.parent).getCompartmentMapping());
        }
    }

    private void updateCanvas(DiagramLabel newLabel, BasicFont parentFont) {
        this.canvasFactory.createDefaultLabelFigure(newLabel, parentFont);
    }

    private void updateMapping(SimpleNode parentNode, DiagramLabel newLabel, CreationTool newCreationTool) {
        this.updateMapping(parentNode, newLabel, newCreationTool, null);
    }

    private void updateMapping(SimpleNode parentNode, DiagramLabel newLabel, CreationTool newCreationTool, CompartmentMapping compartment) {
        ChildReference newChildReference = GMFMapFactory.eINSTANCE.createChildReference();
        NodeMapping newNodeMapping = GMFMapFactory.eINSTANCE.createNodeMapping();
        newChildReference.setOwnedChild(newNodeMapping);
        if (compartment != null) {
            newChildReference.setCompartment(compartment);
        }
        newNodeMapping.setDiagramNode((Node)newLabel);
        newNodeMapping.setTool((AbstractTool)newCreationTool);
        FeatureLabelMapping labelMapping = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
        labelMapping.setDiagramLabel(newLabel);
        newNodeMapping.getLabelMappings().add((Object)labelMapping);
        parentNode.getNodeReference().getChild().getChildren().add((Object)newChildReference);
        this.newLabelNode.setNodeReference((NodeReference)newChildReference);
    }
}

