/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks.invcheck;

import java.util.EnumSet;
import org.eclipse.escet.common.java.Assert;

public enum SubSetRelation {
    EQUAL(false, false),
    LEFT_LARGER(true, false),
    RIGHT_LARGER(false, true),
    BOTH_LARGER(true, true);

    public final boolean leftLarger;
    public final boolean rightLarger;

    private SubSetRelation(boolean leftLarger, boolean rightLarger) {
        this.leftLarger = leftLarger;
        this.rightLarger = rightLarger;
    }

    public static SubSetRelation getRelation(boolean leftLarger, boolean rightLarger) {
        SubSetRelation literal = SubSetRelation.values()[(leftLarger ? 1 : 0) + (rightLarger ? 2 : 0)];
        Assert.areEqual((Object)literal.leftLarger, (Object)leftLarger);
        Assert.areEqual((Object)literal.rightLarger, (Object)rightLarger);
        return literal;
    }

    public static <E extends Enum<E>> SubSetRelation compare(EnumSet<E> left, EnumSet<E> right) {
        EnumSet<E> copy = EnumSet.copyOf(left);
        copy.removeAll(right);
        boolean leftLarger = !copy.isEmpty();
        copy = EnumSet.copyOf(right);
        copy.removeAll(left);
        boolean rightLarger = !copy.isEmpty();
        return SubSetRelation.getRelation(leftLarger, rightLarger);
    }
}

