/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.fsm.ast.internal;

import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.etrice.dctools.fsm.ast.DCLanguage;
import org.eclipse.etrice.dctools.fsm.ast.internal.DCKeywords;
import org.eclipse.etrice.dctools.fsm.ast.internal.DCWordDetector;
import org.eclipse.etrice.dctools.fsm.ast.tokens.DCToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordRule;

public class DCKeywordRule
extends WordRule {
    private final DCToken keywordToken = new DCToken(DCToken.Kind.KEYWORD);

    public DCKeywordRule(DCLanguage language) {
        super((IWordDetector)new DCWordDetector(DCKeywordRule.isCFamily(language)));
        if (language != null) {
            switch (language) {
                case C_LANGUAGE: {
                    Consumer<String> consumer = it -> this.addWord((String)it, this.keywordToken);
                    DCKeywords.getCKeywords().forEach(consumer);
                    break;
                }
                case CPP_LANGUAGE: {
                    Consumer<String> consumer = it -> this.addWord((String)it, this.keywordToken);
                    DCKeywords.getCppKeywords().forEach(consumer);
                    break;
                }
                case JAVA_LANGUAGE: {
                    Consumer<String> consumer = it -> this.addWord((String)it, this.keywordToken);
                    DCKeywords.getJavaKeywords().forEach(consumer);
                    break;
                }
            }
        }
    }

    public static boolean isCFamily(DCLanguage language) {
        return Objects.equals((Object)language, (Object)DCLanguage.C_LANGUAGE) || Objects.equals((Object)language, (Object)DCLanguage.CPP_LANGUAGE);
    }
}

