/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gemini.naming.CloseableContextManager;
import org.eclipse.gemini.naming.ContextManagerImpl;
import org.eclipse.gemini.naming.SecurityAwareContextManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

class ContextManagerServiceFactoryImpl
implements ServiceFactory {
    private Map m_mapOfManagers = Collections.synchronizedMap(new HashMap());
    private final BundleContext m_implBundleContext;

    ContextManagerServiceFactoryImpl(BundleContext implBundleContext) {
        this.m_implBundleContext = implBundleContext;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        CloseableContextManager contextManager = ContextManagerServiceFactoryImpl.createContextManager(bundle, this.m_implBundleContext);
        this.m_mapOfManagers.put(bundle, contextManager);
        bundle.getBundleContext().addBundleListener((BundleListener)new ContextManagerBundleListener());
        return contextManager;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        this.closeContextManager(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAll() {
        Map map = this.m_mapOfManagers;
        synchronized (map) {
            for (Bundle bundleKey : this.m_mapOfManagers.keySet()) {
                this.closeContextManager(bundleKey);
            }
        }
    }

    private void closeContextManager(Bundle bundle) {
        CloseableContextManager contextManager = (CloseableContextManager)this.m_mapOfManagers.get(bundle);
        if (contextManager != null) {
            contextManager.close();
            this.m_mapOfManagers.remove(bundle);
        }
    }

    private static CloseableContextManager createContextManager(Bundle bundle, BundleContext implBundleContext) {
        return new SecurityAwareContextManagerImpl(new ContextManagerImpl(bundle, implBundleContext));
    }

    private class ContextManagerBundleListener
    implements SynchronousBundleListener {
        private ContextManagerBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 4 && ContextManagerServiceFactoryImpl.this.m_mapOfManagers.containsKey(event.getBundle())) {
                ContextManagerServiceFactoryImpl.this.closeContextManager(event.getBundle());
            }
        }
    }
}

