/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import org.eclipse.gemini.naming.BuilderSupportedInitialContextFactory;
import org.eclipse.gemini.naming.ContextWrapperImpl;
import org.eclipse.gemini.naming.DirContextWrapperImpl;
import org.eclipse.gemini.naming.FactoryManager;
import org.eclipse.gemini.naming.ServiceAwareContextFactory;

class InitialContextFactoryWrapper
implements InitialContextFactory {
    private final InitialContextFactory m_initialContextFactory;
    private final FactoryManager m_factoryManager;

    public InitialContextFactoryWrapper(InitialContextFactory initialContextFactory, FactoryManager factoryManager) {
        this.m_initialContextFactory = initialContextFactory;
        this.m_factoryManager = factoryManager;
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        Context contextToReturn = this.m_initialContextFactory.getInitialContext(environment);
        if (contextToReturn instanceof DirContext) {
            DirContextWrapperImpl dirContextWrapper = new DirContextWrapperImpl((DirContext)contextToReturn, this.m_factoryManager);
            this.setupFactoryAssociation(dirContextWrapper);
            return ServiceAwareContextFactory.createServiceAwareDirContextWrapper(this.m_initialContextFactory, dirContextWrapper, this.m_factoryManager);
        }
        ContextWrapperImpl contextWrapper = new ContextWrapperImpl(contextToReturn, this.m_factoryManager);
        this.setupFactoryAssociation(contextWrapper);
        return ServiceAwareContextFactory.createServiceAwareContextWrapper(this.m_initialContextFactory, contextWrapper, this.m_factoryManager);
    }

    private void setupFactoryAssociation(Context contextWrapper) {
        if (this.m_initialContextFactory instanceof BuilderSupportedInitialContextFactory) {
            BuilderSupportedInitialContextFactory builderFactory = (BuilderSupportedInitialContextFactory)this.m_initialContextFactory;
            this.m_factoryManager.associateFactoryService(builderFactory.getBuilder(), contextWrapper);
        } else {
            this.m_factoryManager.associateFactoryService(this.m_initialContextFactory, contextWrapper);
        }
    }
}

