/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.ObjectFactory;
import org.eclipse.gemini.naming.CloseableProviderAdmin;
import org.eclipse.gemini.naming.OSGiInitialContextFactoryBuilder;
import org.osgi.framework.BundleContext;

class ProviderAdminImpl
implements CloseableProviderAdmin {
    private final OSGiInitialContextFactoryBuilder m_objectFactoryBuilder;

    ProviderAdminImpl(BundleContext bundleContext) {
        this.m_objectFactoryBuilder = new OSGiInitialContextFactoryBuilder(bundleContext, bundleContext);
    }

    @Override
    public Object getObjectInstance(Object refInfo, Name name, Context context, Map environment) throws NamingException {
        OSGiInitialContextFactoryBuilder oSGiInitialContextFactoryBuilder = this.m_objectFactoryBuilder;
        synchronized (oSGiInitialContextFactoryBuilder) {
            Hashtable jndiEnvironment = new Hashtable();
            if (environment != null) {
                jndiEnvironment.putAll(environment);
            }
            ObjectFactory objectFactory = this.m_objectFactoryBuilder.createObjectFactory(refInfo, jndiEnvironment);
            try {
                return objectFactory.getObjectInstance(refInfo, name, context, jndiEnvironment);
            }
            catch (Exception e) {
                NamingException namingException = new NamingException("Error while attempting to resolve reference");
                namingException.initCause(e);
                throw namingException;
            }
        }
    }

    @Override
    public Object getObjectInstance(Object refInfo, Name name, Context context, Map environment, Attributes attributes) throws NamingException {
        OSGiInitialContextFactoryBuilder oSGiInitialContextFactoryBuilder = this.m_objectFactoryBuilder;
        synchronized (oSGiInitialContextFactoryBuilder) {
            Hashtable jndiEnvironment = new Hashtable();
            if (environment != null) {
                jndiEnvironment.putAll(environment);
            }
            DirObjectFactory dirObjectFactory = this.m_objectFactoryBuilder.getDirObjectFactory(refInfo, jndiEnvironment);
            try {
                return dirObjectFactory.getObjectInstance(refInfo, name, context, jndiEnvironment, attributes);
            }
            catch (Exception e) {
                NamingException namingException = new NamingException("Error while attempting to resolve reference");
                namingException.initCause(e);
                throw namingException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        OSGiInitialContextFactoryBuilder oSGiInitialContextFactoryBuilder = this.m_objectFactoryBuilder;
        synchronized (oSGiInitialContextFactoryBuilder) {
            this.m_objectFactoryBuilder.close();
        }
    }
}

