/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.pop3;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.geronimo.javamail.store.pop3.POP3Constants;
import org.apache.geronimo.javamail.store.pop3.POP3Response;
import org.apache.geronimo.javamail.store.pop3.response.POP3ResponseFactory;

public final class POP3ResponseBuilder
implements POP3Constants {
    public static POP3Response buildResponse(Session session, BufferedReader reader, boolean isMultiLineResponse) throws MessagingException {
        String line;
        int status = 1;
        InputStream data = null;
        try {
            line = reader.readLine();
        }
        catch (IOException e) {
            throw new MessagingException("Error in receving response");
        }
        if (line == null || line.trim().equals("")) {
            if (session.getDebug()) {
                session.getDebugOut().println("Empty Response");
            }
            throw new MessagingException("Empty Response");
        }
        if (session.getDebug()) {
            session.getDebugOut().println("Response From Server " + line);
        }
        if (line.startsWith("+OK")) {
            status = 0;
            line = POP3ResponseBuilder.removeStatusField(line);
            if (isMultiLineResponse) {
                data = POP3ResponseBuilder.getMultiLineResponse(session, reader);
            }
        } else if (line.startsWith("-ERR")) {
            status = 1;
            line = POP3ResponseBuilder.removeStatusField(line);
        } else if (line.startsWith("+")) {
            status = 2;
            line = POP3ResponseBuilder.removeStatusField(line);
            if (isMultiLineResponse) {
                data = POP3ResponseBuilder.getMultiLineResponse(session, reader);
            }
        } else {
            throw new MessagingException("Unexpected response: " + line);
        }
        return POP3ResponseFactory.getDefaultResponse(status, line, data);
    }

    private static String removeStatusField(String line) {
        return line.substring(line.indexOf(" ") + 1);
    }

    private static InputStream getMultiLineResponse(Session session, BufferedReader reader) throws MessagingException {
        int byteRead = -1;
        int lastByteRead = 10;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            while ((byteRead = reader.read()) >= 0 && (lastByteRead != 46 || byteRead != 13 || (byteRead = reader.read()) != 10)) {
                out.write(byteRead);
                lastByteRead = byteRead;
            }
            if (session.getDebug()) {
                session.getDebugOut().println("\n============================ Response Content==================\n");
                session.getDebugOut().write(out.toByteArray());
                session.getDebugOut().println("\n==============================================================\n");
            }
        }
        catch (IOException e) {
            throw new MessagingException("Error processing a multi-line response", e);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }
}

