/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.management.ObjectName;
import org.apache.catalina.Executor;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.openssl.OpenSSLImplementation;
import org.apache.tomcat.util.res.StringManager;

public class Connector
extends LifecycleMBeanBase {
    private static final Log log = LogFactory.getLog(Connector.class);
    public static final boolean RECYCLE_FACADES = Boolean.parseBoolean(System.getProperty("org.apache.catalina.connector.RECYCLE_FACADES", "false"));
    protected Service service = null;
    protected boolean allowTrace = false;
    protected long asyncTimeout = 30000L;
    protected boolean enableLookups = false;
    protected boolean xpoweredBy = false;
    protected int port = -1;
    protected String proxyName = null;
    protected int proxyPort = 0;
    protected int redirectPort = 443;
    protected String scheme = "http";
    protected boolean secure = false;
    protected static final StringManager sm = StringManager.getManager(Connector.class);
    private int maxCookieCount = 200;
    protected int maxParameterCount = 10000;
    protected int maxPostSize = 0x200000;
    protected int maxSavePostSize = 4096;
    protected String parseBodyMethods = "POST";
    protected HashSet<String> parseBodyMethodsSet;
    protected boolean useIPVHosts = false;
    protected String protocolHandlerClassName = "org.apache.coyote.http11.Http11NioProtocol";
    protected final ProtocolHandler protocolHandler;
    protected Adapter adapter = null;
    protected String URIEncoding = null;
    protected String URIEncodingLower = null;
    protected boolean useBodyEncodingForURI = false;
    protected static final HashMap<String, String> replacements = new HashMap();

    public Connector() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connector(String protocol) {
        this.setProtocol(protocol);
        ProtocolHandler p = null;
        try {
            Class<?> clazz = Class.forName(this.protocolHandlerClassName);
            p = (ProtocolHandler)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerInstantiationFailed"), (Throwable)e);
        }
        finally {
            this.protocolHandler = p;
        }
        if (!Globals.STRICT_SERVLET_COMPLIANCE) {
            this.URIEncoding = "UTF-8";
            this.URIEncodingLower = this.URIEncoding.toLowerCase(Locale.ENGLISH);
        }
    }

    public Object getProperty(String name) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = replacements.get(name);
        }
        return IntrospectionUtils.getProperty((Object)this.protocolHandler, (String)repl);
    }

    public boolean setProperty(String name, String value) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = replacements.get(name);
        }
        return IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)repl, (String)value);
    }

    public Object getAttribute(String name) {
        return this.getProperty(name);
    }

    public void setAttribute(String name, Object value) {
        this.setProperty(name, String.valueOf(value));
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public boolean getAllowTrace() {
        return this.allowTrace;
    }

    public void setAllowTrace(boolean allowTrace) {
        this.allowTrace = allowTrace;
        this.setProperty("allowTrace", String.valueOf(allowTrace));
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    public void setAsyncTimeout(long asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
        this.setProperty("asyncTimeout", String.valueOf(asyncTimeout));
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
        this.setProperty("enableLookups", String.valueOf(enableLookups));
    }

    public int getMaxCookieCount() {
        return this.maxCookieCount;
    }

    public void setMaxCookieCount(int maxCookieCount) {
        this.maxCookieCount = maxCookieCount;
    }

    public int getMaxParameterCount() {
        return this.maxParameterCount;
    }

    public void setMaxParameterCount(int maxParameterCount) {
        this.maxParameterCount = maxParameterCount;
        this.setProperty("maxParameterCount", String.valueOf(maxParameterCount));
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
        this.setProperty("maxPostSize", String.valueOf(maxPostSize));
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
        this.setProperty("maxSavePostSize", String.valueOf(maxSavePostSize));
    }

    public String getParseBodyMethods() {
        return this.parseBodyMethods;
    }

    public void setParseBodyMethods(String methods) {
        HashSet<String> methodSet = new HashSet<String>();
        if (null != methods) {
            methodSet.addAll(Arrays.asList(methods.split("\\s*,\\s*")));
        }
        if (methodSet.contains("TRACE")) {
            throw new IllegalArgumentException(sm.getString("coyoteConnector.parseBodyMethodNoTrace"));
        }
        this.parseBodyMethods = methods;
        this.parseBodyMethodsSet = methodSet;
        this.setProperty("parseBodyMethods", methods);
    }

    protected boolean isParseBodyMethod(String method) {
        return this.parseBodyMethodsSet.contains(method);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.setProperty("port", String.valueOf(port));
    }

    public int getLocalPort() {
        return (Integer)this.getProperty("localPort");
    }

    public String getProtocol() {
        if ("org.apache.coyote.http11.Http11NioProtocol".equals(this.getProtocolHandlerClassName()) && (!AprLifecycleListener.isAprAvailable() || !AprLifecycleListener.getUseAprConnector()) || "org.apache.coyote.http11.Http11AprProtocol".equals(this.getProtocolHandlerClassName()) && AprLifecycleListener.getUseAprConnector()) {
            return "HTTP/1.1";
        }
        if ("org.apache.coyote.ajp.AjpNioProtocol".equals(this.getProtocolHandlerClassName()) && (!AprLifecycleListener.isAprAvailable() || !AprLifecycleListener.getUseAprConnector()) || "org.apache.coyote.ajp.AjpAprProtocol".equals(this.getProtocolHandlerClassName()) && AprLifecycleListener.getUseAprConnector()) {
            return "AJP/1.3";
        }
        return this.getProtocolHandlerClassName();
    }

    @Deprecated
    public void setProtocol(String protocol) {
        boolean aprConnector;
        boolean bl = aprConnector = AprLifecycleListener.isAprAvailable() && AprLifecycleListener.getUseAprConnector();
        if ("HTTP/1.1".equals(protocol) || protocol == null) {
            if (aprConnector) {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11AprProtocol");
            } else {
                this.setProtocolHandlerClassName("org.apache.coyote.http11.Http11NioProtocol");
            }
        } else if ("AJP/1.3".equals(protocol)) {
            if (aprConnector) {
                this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpAprProtocol");
            } else {
                this.setProtocolHandlerClassName("org.apache.coyote.ajp.AjpNioProtocol");
            }
        } else {
            this.setProtocolHandlerClassName(protocol);
        }
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    @Deprecated
    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public ProtocolHandler getProtocolHandler() {
        return this.protocolHandler;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName != null && proxyName.length() > 0 ? proxyName : null;
        this.setProperty("proxyName", this.proxyName);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.setProperty("proxyPort", String.valueOf(proxyPort));
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
        this.setProperty("redirectPort", String.valueOf(redirectPort));
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
        this.setProperty("secure", Boolean.toString(secure));
    }

    public String getURIEncoding() {
        return this.URIEncoding;
    }

    public String getURIEncodingLower() {
        return this.URIEncodingLower;
    }

    public void setURIEncoding(String URIEncoding) {
        this.URIEncoding = URIEncoding;
        this.URIEncodingLower = URIEncoding == null ? null : URIEncoding.toLowerCase(Locale.ENGLISH);
        this.setProperty("uRIEncoding", URIEncoding);
    }

    public boolean getUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
        this.setProperty("useBodyEncodingForURI", String.valueOf(useBodyEncodingForURI));
    }

    public boolean getXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
        this.setProperty("xpoweredBy", String.valueOf(xpoweredBy));
    }

    public void setUseIPVHosts(boolean useIPVHosts) {
        this.useIPVHosts = useIPVHosts;
        this.setProperty("useIPVHosts", String.valueOf(useIPVHosts));
    }

    public boolean getUseIPVHosts() {
        return this.useIPVHosts;
    }

    public String getExecutorName() {
        java.util.concurrent.Executor obj = this.protocolHandler.getExecutor();
        if (obj instanceof Executor) {
            return ((Executor)obj).getName();
        }
        return "Internal";
    }

    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
        this.protocolHandler.addSslHostConfig(sslHostConfig);
    }

    public SSLHostConfig[] findSslHostConfigs() {
        return this.protocolHandler.findSslHostConfigs();
    }

    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.protocolHandler.addUpgradeProtocol(upgradeProtocol);
    }

    public UpgradeProtocol[] findUpgradeProtocols() {
        return this.protocolHandler.findUpgradeProtocols();
    }

    public Request createRequest() {
        Request request = new Request();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        Response response = new Response();
        response.setConnector(this);
        return response;
    }

    protected String createObjectNameKeyProperties(String type) {
        Object addressObj = this.getProperty("address");
        StringBuilder sb = new StringBuilder("type=");
        sb.append(type);
        sb.append(",port=");
        int port = this.getPort();
        if (port > 0) {
            sb.append(port);
        } else {
            sb.append("auto-");
            sb.append(this.getProperty("nameIndex"));
        }
        String address = "";
        if (addressObj instanceof InetAddress) {
            address = ((InetAddress)addressObj).getHostAddress();
        } else if (addressObj != null) {
            address = addressObj.toString();
        }
        if (address.length() > 0) {
            sb.append(",address=");
            sb.append(ObjectName.quote(address));
        }
        return sb.toString();
    }

    public void pause() {
        try {
            this.protocolHandler.pause();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerPauseFailed"), (Throwable)e);
        }
    }

    public void resume() {
        try {
            this.protocolHandler.resume();
        }
        catch (Exception e) {
            log.error((Object)sm.getString("coyoteConnector.protocolHandlerResumeFailed"), (Throwable)e);
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        AbstractHttp11JsseProtocol jsseProtocolHandler;
        super.initInternal();
        this.adapter = new CoyoteAdapter(this);
        this.protocolHandler.setAdapter(this.adapter);
        if (null == this.parseBodyMethodsSet) {
            this.setParseBodyMethods(this.getParseBodyMethods());
        }
        if (this.protocolHandler.isAprRequired() && !AprLifecycleListener.isAprAvailable()) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerNoApr", new Object[]{this.getProtocolHandlerClassName()}));
        }
        if (AprLifecycleListener.isAprAvailable() && AprLifecycleListener.getUseOpenSSL() && this.protocolHandler instanceof AbstractHttp11JsseProtocol && (jsseProtocolHandler = (AbstractHttp11JsseProtocol)this.protocolHandler).isSSLEnabled() && jsseProtocolHandler.getSslImplementationName() == null) {
            jsseProtocolHandler.setSslImplementationName(OpenSSLImplementation.class.getName());
        }
        try {
            this.protocolHandler.init();
        }
        catch (Exception e) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerInitializationFailed"), e);
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (this.getPort() < 0) {
            throw new LifecycleException(sm.getString("coyoteConnector.invalidPort", new Object[]{this.getPort()}));
        }
        this.setState(LifecycleState.STARTING);
        try {
            this.protocolHandler.start();
        }
        catch (Exception e) {
            String errPrefix = "";
            if (this.service != null) {
                errPrefix = errPrefix + "service.getName(): \"" + this.service.getName() + "\"; ";
            }
            throw new LifecycleException(errPrefix + " " + sm.getString("coyoteConnector.protocolHandlerStartFailed"), e);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        try {
            this.protocolHandler.stop();
        }
        catch (Exception e) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerStopFailed"), e);
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e) {
            throw new LifecycleException(sm.getString("coyoteConnector.protocolHandlerDestroyFailed"), e);
        }
        if (this.getService() != null) {
            this.getService().removeConnector(this);
        }
        super.destroyInternal();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Connector[");
        sb.append(this.getProtocol());
        sb.append('-');
        int port = this.getPort();
        if (port > 0) {
            sb.append(port);
        } else {
            sb.append("auto-");
            sb.append(this.getProperty("nameIndex"));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected String getDomainInternal() {
        Service s = this.getService();
        if (s == null) {
            return null;
        }
        return this.service.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return this.createObjectNameKeyProperties("Connector");
    }

    static {
        replacements.put("acceptCount", "backlog");
        replacements.put("connectionLinger", "soLinger");
        replacements.put("connectionTimeout", "soTimeout");
        replacements.put("rootFile", "rootfile");
    }
}

