/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationSessionCookieConfig;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.HexUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.MD5Encoder;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public abstract class RealmBase
extends LifecycleMBeanBase
implements Realm {
    private static final Log log = LogFactory.getLog(RealmBase.class);
    protected Container container = null;
    protected Log containerLog = null;
    protected String digest = null;
    protected String digestEncoding = null;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected volatile MessageDigest md = null;
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static volatile MessageDigest md5Helper;
    protected static final StringManager sm;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;
    protected AllRolesMode allRolesMode = AllRolesMode.STRICT_MODE;
    protected boolean stripRealmForGss = true;
    protected String realmPath = "/realm0";

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getAllRolesMode() {
        return this.allRolesMode.toString();
    }

    public void setAllRolesMode(String allRolesMode) {
        this.allRolesMode = AllRolesMode.toMode(allRolesMode);
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDigestEncoding() {
        return this.digestEncoding;
    }

    public void setDigestEncoding(String charset) {
        this.digestEncoding = charset;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean isStripRealmForGss() {
        return this.stripRealmForGss;
    }

    public void setStripRealmForGss(boolean stripRealmForGss) {
        this.stripRealmForGss = stripRealmForGss;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        String serverCredentials = this.getPassword(username);
        boolean validated = serverCredentials == null ? false : (this.hasMessageDigest() ? serverCredentials.equalsIgnoreCase(this.digest(credentials)) : serverCredentials.equals(credentials));
        if (!validated) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{username}));
            }
            return null;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("realmBase.authenticateSuccess", new Object[]{username}));
        }
        return this.getPrincipal(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String username, String clientDigest, String nOnce, String nc, String cnonce, String qop, String realm, String md5a2) {
        String md5a1 = this.getDigest(username, realm);
        if (md5a1 == null) {
            return null;
        }
        String serverDigestValue = qop == null ? md5a1 + ":" + nOnce + ":" + md5a2 : md5a1 + ":" + nOnce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        byte[] valueBytes = null;
        if (this.getDigestEncoding() == null) {
            valueBytes = serverDigestValue.getBytes();
        } else {
            try {
                valueBytes = serverDigestValue.getBytes(this.getDigestEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                throw new IllegalArgumentException(uee.getMessage());
            }
        }
        String serverDigest = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            serverDigest = md5Encoder.encode(md5Helper.digest(valueBytes));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digest : " + clientDigest + " Username:" + username + " ClientSigest:" + clientDigest + " nOnce:" + nOnce + " nc:" + nc + " cnonce:" + cnonce + " qop:" + qop + " realm:" + realm + "md5a2:" + md5a2 + " Server digest:" + serverDigest));
        }
        if (serverDigest.equals(clientDigest)) {
            return this.getPrincipal(username);
        }
        return null;
    }

    @Override
    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Authenticating client certificate chain");
        }
        if (this.validate) {
            for (int i = 0; i < certs.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Checking validity for '" + certs[i].getSubjectDN().getName() + "'"));
                }
                try {
                    certs[i].checkValidity();
                    continue;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Validity exception", (Throwable)e);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(certs[0]);
    }

    @Override
    public Principal authenticate(GSSContext gssContext, boolean storeCred) {
        if (gssContext.isEstablished()) {
            GSSName gssName = null;
            try {
                gssName = gssContext.getSrcName();
            }
            catch (GSSException e) {
                log.warn((Object)sm.getString("realmBase.gssNameFail"), (Throwable)e);
            }
            if (gssName != null) {
                GSSCredential gssCredential;
                String name;
                block8: {
                    int i;
                    name = ((Object)gssName).toString();
                    if (this.isStripRealmForGss() && (i = name.indexOf(64)) > 0) {
                        name = name.substring(0, i);
                    }
                    gssCredential = null;
                    if (storeCred && gssContext.getCredDelegState()) {
                        try {
                            gssCredential = gssContext.getDelegCred();
                        }
                        catch (GSSException e) {
                            e.printStackTrace();
                            if (!log.isDebugEnabled()) break block8;
                            log.debug((Object)sm.getString("realmBase.delegatedCredentialFail", new Object[]{name}), (Throwable)e);
                        }
                    }
                }
                return this.getPrincipal(name, gssCredential);
            }
        }
        return null;
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        String pattern;
        int k;
        boolean matched;
        int i;
        ArrayList<SecurityConstraint> results = null;
        SecurityConstraint[] constraints = context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable constraints defined");
            }
            return null;
        }
        String uri = request.getRequestPathMB().toString();
        if (uri == null) {
            uri = "/";
        }
        String method = request.getMethod();
        boolean found = false;
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                for (int k2 = 0; k2 < patterns.length; ++k2) {
                    if (!uri.equals(patterns[k2])) continue;
                    found = true;
                    if (!collection[j].findMethod(method)) continue;
                    if (results == null) {
                        results = new ArrayList<SecurityConstraint>();
                    }
                    results.add(constraints[i]);
                }
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        int longest = -1;
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                matched = false;
                int length = -1;
                for (k = 0; k < patterns.length; ++k) {
                    pattern = patterns[k];
                    if (!pattern.startsWith("/") || !pattern.endsWith("/*") || pattern.length() < longest) continue;
                    if (pattern.length() == 2) {
                        matched = true;
                        length = pattern.length();
                        continue;
                    }
                    if (!pattern.regionMatches(0, uri, 0, pattern.length() - 1) && (pattern.length() - 2 != uri.length() || !pattern.regionMatches(0, uri, 0, pattern.length() - 2))) continue;
                    matched = true;
                    length = pattern.length();
                }
                if (!matched) continue;
                found = true;
                if (length > longest) {
                    if (results != null) {
                        results.clear();
                    }
                    longest = length;
                }
                if (!collection[j].findMethod(method)) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i]);
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            boolean matched2 = false;
            int pos = -1;
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                for (k = 0; k < patterns.length && !matched2; ++k) {
                    pattern = patterns[k];
                    if (!pattern.startsWith("*.")) continue;
                    int slash = uri.lastIndexOf("/");
                    int dot = uri.lastIndexOf(".");
                    if (slash < 0 || dot <= slash || dot == uri.length() - 1 || uri.length() - dot != pattern.length() - 1 || !pattern.regionMatches(1, uri, dot, uri.length() - dot)) continue;
                    matched2 = true;
                    pos = j;
                }
            }
            if (!matched2) continue;
            found = true;
            if (!collection[pos].findMethod(method)) continue;
            if (results == null) {
                results = new ArrayList();
            }
            results.add(constraints[i]);
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                matched = false;
                for (int k3 = 0; k3 < patterns.length && !matched; ++k3) {
                    String pattern2 = patterns[k3];
                    if (!pattern2.equals("/")) continue;
                    matched = true;
                }
                if (!matched) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i]);
            }
        }
        if (results == null && log.isDebugEnabled()) {
            log.debug((Object)"  No applicable constraint located");
        }
        return this.resultsToArray(results);
    }

    private SecurityConstraint[] resultsToArray(ArrayList<SecurityConstraint> results) {
        if (results == null) {
            return null;
        }
        SecurityConstraint[] array = new SecurityConstraint[results.size()];
        results.toArray(array);
        return array;
    }

    @Override
    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        String[] roles;
        SecurityConstraint constraint;
        int i;
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        LoginConfig config = context.getLoginConfig();
        if (config != null && "FORM".equals(config.getAuthMethod())) {
            String requestURI = request.getRequestPathMB().toString();
            String loginPage = config.getLoginPage();
            if (loginPage.equals(requestURI)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Allow access to login page " + loginPage));
                }
                return true;
            }
            String errorPage = config.getErrorPage();
            if (errorPage.equals(requestURI)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Allow access to error page " + errorPage));
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)" Allow access to username/password submission");
                }
                return true;
            }
        }
        Principal principal = request.getPrincipal();
        boolean status = false;
        boolean denyfromall = false;
        for (i = 0; i < constraints.length; ++i) {
            constraint = constraints[i];
            roles = constraint.getAllRoles() ? request.getContext().findSecurityRoles() : constraint.findAuthRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking roles " + principal));
            }
            if (roles.length == 0 && !constraint.getAllRoles()) {
                if (constraint.getAuthConstraint()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No role)s ");
                    }
                    status = false;
                    denyfromall = true;
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Passing all access");
                }
                status = true;
                continue;
            }
            if (principal == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"  No user authenticated, cannot grant access");
                continue;
            }
            for (int j = 0; j < roles.length; ++j) {
                if (this.hasRole(null, principal, roles[j])) {
                    status = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Role found:  " + roles[j]));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No role found:  " + roles[j]));
            }
        }
        if (!denyfromall && this.allRolesMode != AllRolesMode.STRICT_MODE && !status && principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for all roles mode: " + this.allRolesMode));
            }
            for (i = 0; i < constraints.length; ++i) {
                constraint = constraints[i];
                if (!constraint.getAllRoles()) continue;
                if (this.allRolesMode == AllRolesMode.AUTH_ONLY_MODE) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Granting access for role-name=*, auth-only");
                    }
                    status = true;
                    break;
                }
                roles = request.getContext().findSecurityRoles();
                if (roles.length != 0 || this.allRolesMode != AllRolesMode.STRICT_AUTH_ONLY_MODE) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Granting access for role-name=*, strict auth-only");
                }
                status = true;
                break;
            }
        }
        if (!status) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return status;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        String realRole;
        if (wrapper != null && (realRole = wrapper.findSecurityReference(role)) != null) {
            role = realRole;
        }
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        boolean result = gp.hasRole(role);
        if (log.isDebugEnabled()) {
            String name = principal.getName();
            if (result) {
                log.debug((Object)sm.getString("realmBase.hasRoleSuccess", new Object[]{name, role}));
            } else {
                log.debug((Object)sm.getString("realmBase.hasRoleFailure", new Object[]{name, role}));
            }
        }
        return result;
    }

    @Override
    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        String queryString;
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable security constraint defined");
            }
            return true;
        }
        for (int i = 0; i < constraints.length; ++i) {
            SecurityConstraint constraint = constraints[i];
            String userConstraint = constraint.getUserConstraint();
            if (userConstraint == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  No applicable user data constraint defined");
                }
                return true;
            }
            if (!userConstraint.equals("NONE")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint already satisfied");
            }
            return true;
        }
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  SSL redirect is disabled");
            }
            response.sendError(403, request.getRequestURI());
            return false;
        }
        StringBuilder file = new StringBuilder();
        String protocol = "https";
        String host = request.getServerName();
        file.append(protocol).append("://").append(host);
        if (redirectPort != 443) {
            file.append(":").append(redirectPort);
        }
        file.append(request.getRequestURI());
        String requestedSessionId = request.getRequestedSessionId();
        if (requestedSessionId != null && request.isRequestedSessionIdFromURL()) {
            file.append(";");
            file.append(ApplicationSessionCookieConfig.getSessionUriParamName(request.getContext()));
            file.append("=");
            file.append(requestedSessionId);
        }
        if ((queryString = request.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Redirecting to " + file.toString()));
        }
        response.sendRedirect(file.toString());
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.container != null) {
            this.containerLog = this.container.getLogger();
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new LifecycleException(sm.getString("realmBase.algorithm", new Object[]{this.digest}), e);
            }
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.md = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Realm[");
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String digest(String credentials) {
        if (!this.hasMessageDigest()) {
            return credentials;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                byte[] bytes = null;
                if (this.getDigestEncoding() == null) {
                    bytes = credentials.getBytes();
                } else {
                    try {
                        bytes = credentials.getBytes(this.getDigestEncoding());
                    }
                    catch (UnsupportedEncodingException uee) {
                        log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                        throw new IllegalArgumentException(uee.getMessage());
                    }
                }
                this.md.update(bytes);
                return HexUtils.convert(this.md.digest());
            }
            catch (Exception e) {
                log.error((Object)sm.getString("realmBase.digest"), (Throwable)e);
                return credentials;
            }
        }
    }

    protected boolean hasMessageDigest() {
        return this.md != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDigest(String username, String realmName) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Couldn't get MD5 digest: ", (Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (this.hasMessageDigest()) {
            return this.getPassword(username);
        }
        String digestValue = username + ":" + realmName + ":" + this.getPassword(username);
        byte[] valueBytes = null;
        if (this.getDigestEncoding() == null) {
            valueBytes = digestValue.getBytes();
        } else {
            try {
                valueBytes = digestValue.getBytes(this.getDigestEncoding());
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                throw new IllegalArgumentException(uee.getMessage());
            }
        }
        byte[] digest = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            digest = md5Helper.digest(valueBytes);
        }
        return md5Encoder.encode(digest);
    }

    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected Principal getPrincipal(X509Certificate usercert) {
        return this.getPrincipal(usercert.getSubjectDN().getName());
    }

    protected abstract Principal getPrincipal(String var1);

    protected Principal getPrincipal(String username, GSSCredential gssCredential) {
        Principal p = this.getPrincipal(username);
        if (p instanceof GenericPrincipal) {
            ((GenericPrincipal)p).setGssCredential(gssCredential);
        }
        return p;
    }

    protected Server getServer() {
        Service s;
        Container c = this.container;
        if (c instanceof Context) {
            c = c.getParent();
        }
        if (c instanceof Host) {
            c = c.getParent();
        }
        if (c instanceof Engine && (s = ((Engine)c).getService()) != null) {
            return s.getServer();
        }
        return null;
    }

    public static final String Digest(String credentials, String algorithm, String encoding) {
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            if (encoding == null) {
                md.update(credentials.getBytes());
            } else {
                md.update(credentials.getBytes(encoding));
            }
            return HexUtils.convert(md.digest());
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return credentials;
        }
    }

    public static void main(String[] args) {
        String encoding = null;
        int firstCredentialArg = 2;
        if (args.length > 4 && args[2].equalsIgnoreCase("-e")) {
            encoding = args[3];
            firstCredentialArg = 4;
        }
        if (args.length > firstCredentialArg && args[0].equalsIgnoreCase("-a")) {
            for (int i = firstCredentialArg; i < args.length; ++i) {
                System.out.print(args[i] + ":");
                System.out.println(RealmBase.Digest(args[i], args[1], encoding));
            }
        } else {
            System.out.println("Usage: RealmBase -a <algorithm> [-e <encoding>] <credentials>");
        }
    }

    @Override
    public String getObjectNameKeyProperties() {
        StringBuilder keyProperties = new StringBuilder("type=Realm");
        keyProperties.append(this.getRealmSuffix());
        keyProperties.append(MBeanUtils.getContainerKeyProperties(this.container));
        return keyProperties.toString();
    }

    @Override
    public String getDomainInternal() {
        return MBeanUtils.getDomain(this.container);
    }

    public String getRealmPath() {
        return this.realmPath;
    }

    public void setRealmPath(String theRealmPath) {
        this.realmPath = theRealmPath;
    }

    protected String getRealmSuffix() {
        return ",realmPath=" + this.getRealmPath();
    }

    static {
        sm = StringManager.getManager((String)"org.apache.catalina.realm");
    }

    protected static class AllRolesMode {
        private String name;
        public static final AllRolesMode STRICT_MODE = new AllRolesMode("strict");
        public static final AllRolesMode AUTH_ONLY_MODE = new AllRolesMode("authOnly");
        public static final AllRolesMode STRICT_AUTH_ONLY_MODE = new AllRolesMode("strictAuthOnly");

        static AllRolesMode toMode(String name) {
            AllRolesMode mode;
            if (name.equalsIgnoreCase(AllRolesMode.STRICT_MODE.name)) {
                mode = STRICT_MODE;
            } else if (name.equalsIgnoreCase(AllRolesMode.AUTH_ONLY_MODE.name)) {
                mode = AUTH_ONLY_MODE;
            } else if (name.equalsIgnoreCase(AllRolesMode.STRICT_AUTH_ONLY_MODE.name)) {
                mode = STRICT_AUTH_ONLY_MODE;
            } else {
                throw new IllegalStateException("Unknown mode, must be one of: strict, authOnly, strictAuthOnly");
            }
            return mode;
        }

        private AllRolesMode(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            boolean equals = false;
            if (o instanceof AllRolesMode) {
                AllRolesMode mode = (AllRolesMode)o;
                equals = this.name.equals(mode.name);
            }
            return equals;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

