/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.dse;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.commons.eclipse.core.resources.IFileUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.gemoc.commons.eclipse.core.resources.Marker;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.dse.GemocDSEBuilderAddonExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.dse.GemocDSEBuilderAddonExtensionPoint;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.dse.IGemocDSEBuilderAddon;
import org.eclipse.gemoc.moccml.mapping.ecltoqvto.main.AcceleoLauncherForEclToQvto;

public class GemocDSEBuilder
extends IncrementalProjectBuilder {
    public static String QVTO_GEN_FOLDER = "qvto-gen";
    private ArrayList<IGemocDSEBuilderAddon> addons;
    public static final String BUILDER_ID = "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.dse_builder";
    public static final String MARKER_TYPE = "org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.dse_problem";

    public GemocDSEBuilder() {
        AcceleoPreferences.switchForceDeactivationNotifications((boolean)true);
        try {
            this.addons = this.instanciateBuilderAddons();
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    public final ArrayList<IGemocDSEBuilderAddon> instanciateBuilderAddons() throws CoreException {
        ArrayList<IGemocDSEBuilderAddon> addons = new ArrayList<IGemocDSEBuilderAddon>();
        for (GemocDSEBuilderAddonExtension addonExtension : GemocDSEBuilderAddonExtensionPoint.getSpecifications()) {
            addons.add(addonExtension.instanciateComponent());
        }
        return addons;
    }

    protected void addMarker(IResource resource, String message, int lineNumber, int severity) {
        try {
            Marker.addMarker((IResource)resource, (String)MARKER_TYPE, (String)message, (int)lineNumber, (int)severity);
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        Marker.removeMarkers((IResource)this.getProject(), (String)MARKER_TYPE);
    }

    protected void processResource(IResource resource) {
        if (resource instanceof IFile && resource.getName().equals("moc2as.properties")) {
            this.checkProjectProperties((IFile)resource);
        } else if (resource instanceof IProject) {
            this.checkProjectMinimalContent((IProject)resource);
        } else if (resource instanceof IFile && resource.getName().endsWith(".ecl")) {
            this.updateQVTOFromECL(resource);
        } else if (resource instanceof IFile && resource.getName().endsWith(".qvto") && resource.getProjectRelativePath().segment(0).equalsIgnoreCase(QVTO_GEN_FOLDER)) {
            this.checkQVTOContent((IFile)resource);
        }
        for (IGemocDSEBuilderAddon addon : this.addons) {
            try {
                addon.processResourceAddon(resource);
            }
            catch (Throwable e) {
                Activator.error("Error in addon " + e.getMessage(), e);
            }
        }
    }

    protected void checkProjectMinimalContent(IProject project) {
        this.deleteMarkers((IResource)project);
        IFile propertyFile = project.getFile("moc2as.properties");
        if (!propertyFile.exists()) {
            this.addMarker((IResource)project, "Missing moc2as.properties, cannot generate qvto", -1, 2);
            return;
        }
    }

    protected void checkQVTOContent(IFile qvtoFile) {
        this.deleteMarkers((IResource)qvtoFile);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(qvtoFile.getContents(), Charsets.UTF_8));
            int lineNumber = 0;
            while (reader.ready()) {
                String line = reader.readLine();
                ++lineNumber;
                if (!line.contains("uses 'invalid';")) continue;
                this.addMarker((IResource)qvtoFile, "Generated QVTO file is Invalid. Check your ECL file or try to clean/rebuild the project", lineNumber, 2);
                return;
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void checkProjectProperties(IFile propertyFile) {
        this.checkProjectMinimalContent(propertyFile.getProject());
        this.deleteMarkers((IResource)propertyFile);
        Properties properties = new Properties();
        try {
            properties.load(propertyFile.getContents());
            String rootElement = properties.getProperty("rootElement");
            if (rootElement == null || rootElement.isEmpty()) {
                this.addMarker((IResource)propertyFile, "rootElement not defined in moc2as.properties, cannot generate qvto", -1, 2);
                return;
            }
        }
        catch (IOException e1) {
            Activator.error(e1.getMessage(), e1);
        }
        catch (CoreException e1) {
            Activator.error(e1.getMessage(), e1);
        }
    }

    void updateQVTOFromECL(IResource resource) {
        if (resource instanceof IFile && (resource.getName().endsWith(".ecl") || resource.getName().endsWith(".moccmlmapping"))) {
            IProject project = resource.getProject();
            final IFile eclFile = (IFile)resource;
            this.deleteMarkers((IResource)eclFile);
            IFile propertyFile = resource.getProject().getFile("moc2as.properties");
            if (!propertyFile.exists()) {
                this.addMarker((IResource)eclFile, "Missing moc2as.properties, cannot generate qvto with DSE builder", -1, 1);
                return;
            }
            try {
                Properties properties = new Properties();
                properties.load(propertyFile.getContents());
                String rootElement = properties.getProperty("rootElement");
                if (rootElement == null || rootElement.isEmpty()) {
                    this.addMarker((IResource)eclFile, "rootElement not defined in moc2as.properties, cannot generate qvto with DSE builder", -1, 1);
                    return;
                }
                String uristring = eclFile.getLocation().toOSString();
                final URI uri = URI.createFileURI((String)uristring);
                String genFolder = QVTO_GEN_FOLDER;
                final IFolder modelingFolder = IProjectUtils.createFolder((IProject)project, (String)(String.valueOf(genFolder) + "/modeling"));
                final IFolder languageFolder = IProjectUtils.createFolder((IProject)project, (String)(String.valueOf(genFolder) + "/language"));
                final String qvtoFileName = eclFile.getFullPath().removeFileExtension().addFileExtension("qvto").lastSegment();
                final ArrayList<String> arguments = new ArrayList<String>();
                arguments.add(qvtoFileName);
                String fixedRootElement = rootElement;
                if (rootElement.contains("::")) {
                    fixedRootElement = rootElement.substring(rootElement.indexOf("::") + 2);
                }
                arguments.add(fixedRootElement);
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        Activator.error(e.getMessage(), e);
                    }

                    public void run() throws Exception {
                        try {
                            System.out.println("launching ecl to qvto:\n\turi=" + uri + "\n\tfolder=" + languageFolder + "\n\targs=" + arguments);
                            AcceleoLauncherForEclToQvto launcher = new AcceleoLauncherForEclToQvto(uri, new File(languageFolder.getLocation().toOSString()), arguments);
                            launcher.doGenerate((Monitor)new BasicMonitor());
                            IFile qvtoFileForLanguage = languageFolder.getFile(qvtoFileName);
                            qvtoFileForLanguage.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            GemocDSEBuilder.this.checkQVTOContent(qvtoFileForLanguage);
                            IFile qvtoFileForModeling = modelingFolder.getFile(qvtoFileName);
                            String qvtoLanguageContent = IFileUtils.getStringContent((IFile)qvtoFileForLanguage);
                            String qvtoModelingContent = qvtoLanguageContent.replaceAll("platform:/resource", "platform:/plugin");
                            IFileUtils.writeInFileIfDifferent((IFile)qvtoFileForModeling, (String)qvtoModelingContent, (IProgressMonitor)new NullProgressMonitor());
                            qvtoFileForModeling.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            GemocDSEBuilder.this.checkQVTOContent(qvtoFileForModeling);
                        }
                        catch (IOException e) {
                            GemocDSEBuilder.this.addMarker((IResource)eclFile, e.getMessage(), -1, 2);
                            Activator.error(e.getMessage(), e);
                        }
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
            catch (CoreException e1) {
                Activator.error(e1.getMessage(), e1);
            }
            catch (IOException e1) {
                this.addMarker((IResource)eclFile, e1.getMessage(), 0, 2);
                Activator.error(e1.getMessage(), e1);
            }
        }
    }

    private void deleteMarkers(IResource file) {
        try {
            Marker.removeMarkers((IResource)file, (String)MARKER_TYPE);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new Moc2ASProjectResourceVisitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new GemocDSEBuilderDeltaVisitor());
    }

    class GemocDSEBuilderDeltaVisitor
    implements IResourceDeltaVisitor {
        GemocDSEBuilderDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    GemocDSEBuilder.this.processResource(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    GemocDSEBuilder.this.processResource(resource);
                }
            }
            return true;
        }
    }

    class Moc2ASProjectResourceVisitor
    implements IResourceVisitor {
        Moc2ASProjectResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            GemocDSEBuilder.this.processResource(resource);
            return true;
        }
    }
}

