/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.core.interpreter.CriticalFailureException;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;

public class DiagnosticLogger {
    private static final Pattern AQL_SERVICE_ERROR_PATTERN = Pattern.compile(".*with arguments \\[.*\\].* failed:(.*)", 32);
    List<Diagnostic> log = new ArrayList<Diagnostic>();
    private final IBehaviors semantics;

    public DiagnosticLogger(IBehaviors semantics) {
        this.semantics = Objects.requireNonNull(semantics, "semantics");
    }

    public void notify(Diagnostic diag) {
        this.log.add(diag);
    }

    public List<Diagnostic> getLog() {
        return this.log;
    }

    public void diagnosticForHuman() {
        this.log.stream().forEach(diagnotic -> {
            if (diagnotic instanceof BasicDiagnostic) {
                this.diagnosticForHuman((BasicDiagnostic)diagnotic, new LinkedList<String>());
            }
        });
    }

    public void diagnosticForHuman(BasicDiagnostic diagnostic, LinkedList<String> stacktrace) {
        diagnostic.getChildren().forEach(diag -> {
            Exception e;
            if (diag.getSource().equals("org.eclipse.emf.ecoretools.ale.core")) {
                Object failedExp = diag.getData().get(0);
                Diagnostic diagExp = diag;
                if (diag.getData().size() > 1) {
                    diagExp = (Diagnostic)diag.getData().get(1);
                }
                this.printError(failedExp, diagExp, stacktrace);
                if (diagExp instanceof BasicDiagnostic) {
                    this.diagnosticForHuman((BasicDiagnostic)diagExp, stacktrace);
                }
            } else if (!diag.getData().isEmpty() && diag.getData().get(0) instanceof Exception && (e = (Exception)diag.getData().get(0)).getCause() instanceof CriticalFailureException) {
                CriticalFailureException interpreterFailure = (CriticalFailureException)e.getCause();
                this.diagnosticForHuman(interpreterFailure.getDiagnostic(), stacktrace);
            }
        });
    }

    private void printError(Object expr, Diagnostic diagnostic, LinkedList<String> stacktrace) {
        ParsedFile parsedFile = this.semantics.findParsedFileDefining(expr).orElse(null);
        if (parsedFile == null) {
            stacktrace.addFirst("At unknown file and line (" + expr + "):");
            Stream.concat(Stream.of(diagnostic), diagnostic.getChildren().stream()).map(Diagnostic::getMessage).map(this.getActualError()).filter(msg -> msg != null && !msg.trim().isEmpty()).forEach(message -> {
                System.err.println((String)message);
                DiagnosticLogger.unfold(stacktrace);
            });
        } else {
            Integer startPos = parsedFile.getStartPositions().get(expr);
            if (startPos != null) {
                String file;
                String filePath = file = parsedFile.getSourceFile();
                IContainer[] ifiles = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new File(file).toURI());
                if (ifiles.length > 0) {
                    filePath = ifiles[0].getFullPath().makeRelative().toString();
                }
                filePath = filePath.replace('\\', '/');
                int line = this.getLine(startPos, file);
                stacktrace.addFirst("At " + filePath + ":" + line);
                Stream.concat(Stream.of(diagnostic), diagnostic.getChildren().stream()).map(Diagnostic::getMessage).filter(msg -> msg != null && !msg.trim().isEmpty()).map(this.getActualError()).filter(msg -> !"AQL evaluation failed".equals(msg)).forEach(message -> {
                    System.err.println((String)message);
                    DiagnosticLogger.unfold(stacktrace);
                });
            }
        }
    }

    private static void unfold(List<String> stacktrace) {
        System.err.println();
        for (String trace : stacktrace) {
            System.err.println("  " + trace);
        }
        stacktrace.clear();
    }

    private Function<String, String> getActualError() {
        return message -> {
            Matcher matcher = AQL_SERVICE_ERROR_PATTERN.matcher((CharSequence)message);
            if (matcher.matches()) {
                return matcher.group(1).trim();
            }
            return message;
        };
    }

    private int getLine(int offset, String file) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (LineNumberReader r = new LineNumberReader(new FileReader(file));){
                r.setLineNumber(1);
                int count = 0;
                while (r.read() != -1 && count < offset) {
                    ++count;
                }
                if (count == offset) {
                    return r.getLineNumber();
                }
                System.out.println("File is not long enough");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

