/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.explorer.ui.popup.action;

import fr.inria.aoste.timesquare.ccslkernel.explorer.CCSLConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.explorer.CCSLKernelExplorer;
import fr.inria.aoste.timesquare.ccslkernel.explorer.StateSpace;
import fr.inria.aoste.timesquare.ccslkernel.model.utils.ResourceLoader;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnfoldingException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.kairos.timesquare.grph.viewer.GrphViewControler;
import fr.inria.kairos.timesquare.statespace.view.views.MoCCMLStateSpaceView;
import it.unimi.dsi.fastutil.ints.IntIterable;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import toools.collections.primitive.IntCursor;
import toools.io.file.RegularFile;

public class CreateStateSpace
extends AbstractHandler {
    private IFile ccslFile;
    private CCSLKernelExplorer clockExplorer;
    private String ccslFilePath;
    private String ccslPriorityFilePath;
    StateSpace stateSpace = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selected;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (selected = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.ccslFile = (IFile)selected;
            this.ccslFilePath = this.ccslFile.getLocation().toString();
            this.ccslPriorityFilePath = this.ccslFilePath.replaceAll("extendedCCSL", "ccslPriority");
        }
        Job job = new Job("TimeSquare State Space Exploration on " + this.ccslFile.toString()){

            protected IStatus run(IProgressMonitor monitor) {
                CreateStateSpace.this.clockExplorer = new CCSLKernelExplorer(monitor);
                Resource ccslResource = null;
                try {
                    ccslResource = ResourceLoader.INSTANCE.loadResource(CreateStateSpace.this.ccslFile.getFullPath());
                }
                catch (Throwable e) {
                    System.err.println("load ccsl file problem on " + CreateStateSpace.this.ccslFilePath + "\nexception:");
                    e.printStackTrace();
                    return null;
                }
                Resource priorityResource = null;
                try {
                    priorityResource = ResourceLoader.INSTANCE.loadResource(CreateStateSpace.this.ccslFile.getFullPath().removeFileExtension() + ".ccslPriority");
                }
                catch (Throwable e) {
                    System.out.println("no priority file " + CreateStateSpace.this.ccslPriorityFilePath + "\n:");
                }
                try {
                    CreateStateSpace.this.clockExplorer.loadModel(ccslResource);
                    if (priorityResource != null) {
                        System.err.println("WARNING: state space is construct with priority file: " + CreateStateSpace.this.ccslPriorityFilePath);
                        CreateStateSpace.this.clockExplorer.loadPriorityModel(priorityResource);
                    }
                }
                catch (UnfoldingException | SimulationException | IOException e) {
                    e.printStackTrace();
                }
                try {
                    CreateStateSpace.this.clockExplorer.initSimulation();
                }
                catch (SimulationException e1) {
                    e1.printStackTrace();
                }
                CreateStateSpace.this.stateSpace = null;
                try {
                    CreateStateSpace.this.stateSpace = CreateStateSpace.this.clockExplorer.explore(false);
                }
                catch (SimulationException e) {
                    e.printStackTrace();
                }
                RegularFile dotRegFile = new RegularFile(String.valueOf(CreateStateSpace.this.ccslFilePath) + ".dot");
                dotRegFile.setContentAsASCII(CreateStateSpace.this.stateSpace.getGrph().toDot());
                dotRegFile.create();
                this.createAutStateSpaceFormat();
                CreateStateSpace.this.clockExplorer = null;
                for (IntCursor v : IntCursor.fromFastUtil((IntIterable)CreateStateSpace.this.stateSpace.getGrph().getVertices())) {
                    CreateStateSpace.this.stateSpace.getGrph().getVertexLabelProperty().setValue(v.value, "");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MoCCMLStateSpaceView statespaceView = MoCCMLStateSpaceView.getCourant();
                        GrphViewControler statespaceViewControler = statespaceView.controller;
                        if (statespaceViewControler == null) {
                            throw new RuntimeException("MoCCML state space view is now open, please retry");
                        }
                        statespaceViewControler.model = (this).CreateStateSpace.this.stateSpace.getGrph();
                        statespaceViewControler.addGrph((this).CreateStateSpace.this.stateSpace.v2i((this).CreateStateSpace.this.stateSpace.initialState));
                    }
                });
                System.out.println("# of states: " + CreateStateSpace.this.stateSpace.getGrph().getVertices().size() + "\n# of transitions: " + CreateStateSpace.this.stateSpace.getGrph().getEdges().size() + " is there an infinite schedule: " + new Boolean(CreateStateSpace.this.stateSpace.getGrph().isCyclic()) + "which is " + CreateStateSpace.this.stateSpace.getGrph().getShortestCycle());
                return Status.OK_STATUS;
            }

            private void createAutStateSpaceFormat() {
                RegularFile cipRegFile = new RegularFile(String.valueOf(CreateStateSpace.this.ccslFilePath) + ".aut");
                Iterator iterVertices = CreateStateSpace.this.stateSpace.getVertices().iterator();
                CCSLConstraintState aState = (CCSLConstraintState)iterVertices.next();
                if (aState == null) {
                    System.err.println("no State space to serialize");
                    return;
                }
                StringBuilder fileContent = new StringBuilder();
                fileContent.append("des(");
                fileContent.append(CreateStateSpace.this.stateSpace.v2i(CreateStateSpace.this.stateSpace.initialState));
                fileContent.append(",");
                fileContent.append(CreateStateSpace.this.stateSpace.getGrph().getEdges().size());
                fileContent.append(",");
                fileContent.append(CreateStateSpace.this.stateSpace.getGrph().getVertices().size());
                fileContent.append(")\n");
                for (CCSLConstraintState s1 : CreateStateSpace.this.stateSpace.getVertices()) {
                    for (CCSLConstraintState s2 : CreateStateSpace.this.stateSpace.getVertices()) {
                        for (StringBuffer t : CreateStateSpace.this.stateSpace.getEdges((Object)s1, (Object)s2)) {
                            String aLine = "(" + CreateStateSpace.this.stateSpace.v2i(s1) + ", " + this.mclFormat(t) + "\", " + CreateStateSpace.this.stateSpace.v2i(s2) + ")";
                            fileContent.append(aLine);
                            fileContent.append("\n");
                        }
                    }
                }
                cipRegFile.setContentAsASCII(fileContent.toString());
                cipRegFile.create();
            }

            private String mclFormat(StringBuffer t) {
                StringBuffer res = new StringBuffer("\"LS !");
                String[] stringArray = t.toString().split(", ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    res.append(":");
                    res.append(s);
                    ++n2;
                }
                return res.toString().replaceAll("\\[", "").replaceAll("\\]", "");
            }
        };
        job.schedule();
        return null;
    }
}

