/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core;

import fr.inria.aoste.timesquare.launcher.core.PESolverManager;
import fr.inria.aoste.timesquare.launcher.core.SimulatorControl;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.timesquare.launcher.core.errorhandler.ErrorHandler;
import fr.inria.aoste.timesquare.launcher.core.errorhandler.ErrorHandlerDisplay;
import fr.inria.aoste.timesquare.launcher.core.errorhandler.ErrorHandlerSimulation;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLNormalThread;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLProcess;
import fr.inria.aoste.timesquare.launcher.debug.model.MySimulationEngine;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.CCSLSimulationConfigurationHelper;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.ICCSLModelLauncher;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.ISimulatorControl;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class CCSLModelLauncher
implements ILaunchConfigurationDelegate,
ICCSLModelLauncher {
    private static final String noFileFoundMessage = "No CCSL source file found ";

    public CCSLModelLauncher() {
        System.out.println("Init delegate");
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            PESolverManager.getDefault().clearCache(0);
            CCSLSimulationConfigurationHelper helper = CCSLSimulationConfigurationHelper.create(configuration);
            try {
                if (!configuration.exists() && configuration instanceof ILaunchConfigurationWorkingCopy) {
                    ILaunchConfigurationWorkingCopy loc = (ILaunchConfigurationWorkingCopy)configuration;
                    String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(helper.get_NameFile(false));
                    loc.rename(name);
                    loc.doSave();
                }
            }
            catch (Throwable e) {
                System.err.println(e);
            }
            CCSLSimulationConfigurationHelper.clearCache();
            this.launch(helper, mode, launch);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (t instanceof CoreException) {
                throw (CoreException)t;
            }
            throw new CoreException((IStatus)new Status(4, "fr.inria.aoste.timesquare.launcher.core", "error launching ", t));
        }
    }

    public void getShowPerspective() {
        IWorkbench workBench = PlatformUI.getWorkbench();
        try {
            Display display = workBench.getDisplay();
            display.syncExec((Runnable)new DisplayRunnable(workBench));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public ISimulatorControl launch(CCSLSimulationConfigurationHelper helper, String mode, ILaunch launch) throws CoreException, InterruptedException {
        IFile file = helper.get_SourceIFile();
        if (file == null || !file.exists()) {
            System.err.println("No CCSL source file found  :" + file);
            throw new CoreException((IStatus)new Status(4, "fr.inria.aoste.timesquare.launcher.core", noFileFoundMessage, (Throwable)new Error(noFileFoundMessage)));
        }
        boolean b = false;
        try {
            if (PluginHelpers.getActiveWorkbench() != null) {
                IEditorPart[] iEditorPartArray = PluginHelpers.getActiveWorkbench().getActivePage().getDirtyEditors();
                int n = iEditorPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart iep = iEditorPartArray[n2];
                    IEditorInput iei = iep.getEditorInput();
                    IPersistableElement ipe = iei.getPersistable();
                    if (ipe instanceof FileEditorInput && file.equals((Object)((FileEditorInput)ipe).getFile())) {
                        b = true;
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable iep) {
            // empty catch block
        }
        if (b) {
            AskRunnable ask = new AskRunnable();
            Display.getDefault().syncExec((Runnable)ask);
            if (!ask.get()) {
                return null;
            }
        }
        CCSLProcess process = new CCSLProcess(launch, helper);
        MySimulationEngine sim = new MySimulationEngine(helper);
        if (mode.equals("debug")) {
            sim.setErrorHandler(new ErrorHandlerDisplay());
            PluginHelpers.getShowView((String)"org.eclipse.debug.ui.DebugView");
            helper.setConsole(new ConsoleSimulation(process, "CCSL : " + helper.getSource() + " " + helper.getDatestr()));
            this.getShowPerspective();
            helper.setConsole(new ConsoleSimulation(process, "   priority specification : " + helper.getPrioritySource() + " " + helper.getDatestr()));
            this.getShowPerspective();
            CCSLDebugTarget ccslDebugTarget = new CCSLDebugTarget(launch, process, sim);
            return new SimulatorControl(ccslDebugTarget.getRun(), sim);
        }
        if (mode.equals("simulation")) {
            ErrorHandler errorHandler = helper.getErrorHandler();
            if (errorHandler == null) {
                sim.setErrorHandler(new ErrorHandlerSimulation());
            } else {
                sim.setErrorHandler(errorHandler);
            }
            helper.setConsole(new ConsoleSimulation());
            CCSLDebugTarget ccslDebugTarget = new CCSLDebugTarget(launch, process, sim);
            return new SimulatorControl(ccslDebugTarget.getRun(), sim);
        }
        if (mode.equals("run")) {
            sim.setErrorHandler(new ErrorHandlerDisplay());
            PluginHelpers.getShowView((String)"org.eclipse.debug.ui.DebugView");
            helper.setConsole(new ConsoleSimulation(process, "CCSL : " + helper.getSource() + " " + helper.getDatestr()));
            CCSLNormalThread runnable = new CCSLNormalThread(sim, process);
            Thread d = process.addThread(runnable);
            return new SimulatorControl(d, sim);
        }
        throw new RuntimeException("Unknow Simulation mode :" + mode);
    }

    private static final class AskRunnable
    implements Runnable {
        boolean b = false;

        private AskRunnable() {
        }

        @Override
        public void run() {
            try {
                this.b = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Simulation ", (String)"the input model is not saved . Do you want run simulation ?");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public boolean get() {
            return this.b;
        }
    }

    private static final class DisplayRunnable
    implements Runnable {
        private final IWorkbench workBench;

        private DisplayRunnable(IWorkbench workBench) {
            this.workBench = workBench;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = this.workBench.getActiveWorkbenchWindow();
            try {
                IWorkbenchPage iwp = this.workBench.showPerspective("org.eclipse.debug.ui.DebugPerspective", window);
                iwp.findView("org.eclipse.debug.ui.DebugView");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

