/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLDebugElement;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLDebugThread;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLProcess;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLStackFrame;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.ISimulationInterface;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public final class CCSLDebugTarget
extends CCSLDebugElement
implements ICCSLDebugTarget {
    private CCSLProcess process;
    private CCSLDebugThread thread;
    private IThread[] threads;
    private ILaunch launch;
    private CCSLStackFrame stackFrame;
    private IStackFrame[] frames;
    private String name;
    private boolean isSuspended = true;
    private Thread run = null;

    public CCSLDebugTarget(ILaunch launch, CCSLProcess process, ISimulationInterface sim) {
        super(null);
        this.process = process;
        this.thread = new CCSLDebugThread(this, sim);
        this.launch = launch;
        this.threads = new IThread[]{this.thread};
        try {
            this.name = "CCSL simulator " + sim.getSourceFile();
        }
        catch (Throwable e) {
            this.name = "CCSL Simulator ";
        }
        this.stackFrame = new CCSLStackFrame(this, this.thread);
        this.frames = new IStackFrame[1];
        this.frames[0] = this.stackFrame;
        launch.addDebugTarget((IDebugTarget)this);
        this.run = this.process.addThread(this.thread);
    }

    @Override
    public Thread getRun() {
        return this.run;
    }

    protected void finalize() throws Throwable {
        System.out.println("finalize :" + this.toString());
        super.finalize();
    }

    @Override
    public IStackFrame[] getStackFrames() {
        return this.frames;
    }

    public IThread[] getThreads() throws DebugException {
        if (this.thread == null) {
            return new IThread[0];
        }
        return (IThread[])this.threads.clone();
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    @Override
    public CCSLProcess getProcess() {
        return this.process;
    }

    @Override
    public ILaunch getLaunch() {
        return this.launch;
    }

    public final void terminate() throws DebugException {
        this.fireTerminateEvent();
        this.fireSuspendEvent(256);
    }

    public boolean canTerminate() {
        return this.getProcess().canTerminate();
    }

    public boolean isTerminated() {
        return this.getProcess().isTerminated();
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public void resume() throws DebugException {
        this.isSuspended = false;
        this.fireResumeEvent(2);
    }

    public void suspend() throws DebugException {
        this.isSuspended = true;
        this.fireSuspendEvent(2);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return this.getProcess().canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.getProcess().disconnect();
    }

    public boolean isDisconnected() {
        return this.getProcess().isDisconnected();
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "fr.inria.aoste.timesquare.launcher.debug.model", "Storege Retrieval not supported"));
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }
}

