/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLDebugElement;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public abstract class CCSLVariable
extends CCSLDebugElement
implements IVariable {
    private String name;
    private String type;
    private IValue value = null;
    private boolean hasValueChanged = false;
    private boolean modifiable = false;

    protected void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    protected CCSLVariable(ICCSLDebugTarget target, String name, String type) {
        super(target);
        this.name = name;
        this.type = type;
    }

    public final String getName() {
        return this.name;
    }

    public final String getReferenceTypeName() {
        return this.type;
    }

    public final IValue getValue() {
        return this.value;
    }

    public final boolean hasValueChanged() {
        return this.hasValueChanged;
    }

    public void setValue(String expression) {
        this.hasValueChanged = true;
    }

    public final void setValue(IValue value) {
        this.hasValueChanged = true;
        this.value = value;
    }

    public final boolean supportsValueModification() {
        return this.modifiable;
    }

    public final boolean verifyValue(IValue value) {
        try {
            return value.getReferenceTypeName().equals(this.getReferenceTypeName());
        }
        catch (DebugException de) {
            return false;
        }
    }
}

