/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model.proxy;

import fr.inria.aoste.timesquare.launcher.core.OutputManager;
import fr.inria.aoste.timesquare.launcher.core.PESolverManager;
import fr.inria.aoste.timesquare.launcher.core.PropertySimulation;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.timesquare.launcher.core.errorhandler.ErrorHandler;
import fr.inria.aoste.timesquare.launcher.core.inter.CCSLInfo;
import fr.inria.aoste.timesquare.launcher.core.inter.ICCSLProxy;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolver;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLConstants;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.CCSLInfoDelegate;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.Configurator;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.ICCSLModelLauncher;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.ISimulatorControl;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputOption;
import fr.inria.aoste.timesquare.simulationpolicy.OptionPolitic;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyManager;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.relation.IDescription;
import fr.inria.aoste.trace.relation.IRelation;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class CCSLSimulationConfigurationHelper
implements ICCSLProxy {
    private static final OutputManager outputManager = OutputManager.getDefault();
    private static final PESolverManager peSolverManager = PESolverManager.getDefault();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy_MMdd_HHmmss");
    private static CCSLSimulationConfigurationHelper cache = null;
    private ILaunchConfigurationWorkingCopy _config;
    private ILaunchConfiguration config;
    private final String datestr;
    private ConsoleSimulation console;
    private List<ModelElementReference> listofassert = null;
    private List<ModelElementReference> listofclock = null;
    private List<ModelElementReference> listofconstraint = null;
    private List<IDescription> listofrelation = null;
    private List<Resource> listressource = new ArrayList<Resource>();
    private List<EObject> listReferencedObject = new ArrayList<EObject>();
    private ISolver isolver = null;
    private ErrorHandler errorHandler = null;
    private long stamp = 0L;
    private HashMap<String, IOutputOption> cachedtable;
    private IRelation relation = null;
    Map<URI, Resource> mappingURI = null;
    private boolean saveconf = true;
    private IFile prioritySourceFile;
    private IFile sourceFile;
    private final CCSLInfoDelegate delegate = new CCSLInfoDelegate(this);
    private int ccslinfoevolution = 0;

    public static synchronized void clearCache() {
        cache = null;
    }

    public static synchronized CCSLSimulationConfigurationHelper create(ILaunchConfiguration configin) {
        ILaunchConfiguration ilc;
        if (cache != null && CCSLSimulationConfigurationHelper.cache.config == configin) {
            cache.getSolver();
            return cache;
        }
        if (cache != null && configin instanceof ILaunchConfigurationWorkingCopy && CCSLSimulationConfigurationHelper.cache.config == (ilc = ((ILaunchConfigurationWorkingCopy)configin).getOriginal())) {
            System.out.println(ilc);
            CCSLSimulationConfigurationHelper.cache._config = (ILaunchConfigurationWorkingCopy)configin;
            CCSLSimulationConfigurationHelper.cache.config = configin;
            return cache;
        }
        cache = new CCSLSimulationConfigurationHelper(configin);
        return cache;
    }

    public static CCSLSimulationConfigurationHelper createlaunch(IFile file) throws CoreException {
        CCSLSimulationConfigurationHelper.clearCache();
        if (file == null) {
            throw new NullPointerException("file is null ");
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType lcType = manager.getLaunchConfigurationType("fr.inria.aoste.timesquare.launcher.core.launchConfigurationType");
        ILaunchConfigurationWorkingCopy conf = lcType.newInstance(file.getParent(), "default");
        ILaunchConfigurationWorkingCopy workingCopy = conf.getWorkingCopy();
        CCSLSimulationConfigurationHelper helper = CCSLSimulationConfigurationHelper.create((ILaunchConfiguration)workingCopy);
        helper.setSource(file);
        helper.setSaveconf(false);
        if (!helper.haveSolver()) {
            throw new RuntimeException("Solver init fail", PESolverManager.getDefault().getThrowable());
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateTime() {
        DateFormat dateFormat = CCSLSimulationConfigurationHelper.dateFormat;
        synchronized (dateFormat) {
            return CCSLSimulationConfigurationHelper.dateFormat.format(new Date());
        }
    }

    private CCSLSimulationConfigurationHelper(ILaunchConfiguration configin) {
        assert (configin != null);
        this.config = configin;
        this.datestr = CCSLSimulationConfigurationHelper.getDateTime();
        this._config = configin instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)configin : null;
        this.cachedtable = new HashMap();
        this.init();
    }

    private List<IDescription> getRelationDescription() {
        List<Object> lst = new ArrayList<IDescription>();
        try {
            EObject eo = (EObject)((Resource)this.isolver.getResourceSet().getResources().get(0)).getContents().get(0);
            this.relation = (IRelation)PluginHelpers.getNewInstance((String)"fr.inria.aoste.timesquare.instantrelation", (String)"fr.inria.aoste.timesquare.instantrelation.generator.InstantRelationModelGenerator", (Class)IRelation.CLASS);
            if (this.relation == null) {
                return lst;
            }
            this.relation.setListClock(this.listofclock);
            this.relation.setListRelation(this.listofconstraint);
            this.relation.extract(eo);
            lst = this.relation.getDescription();
        }
        catch (Throwable e) {
            System.err.println(e);
        }
        return lst;
    }

    private void init() {
        this.relation = null;
        this.isolver = peSolverManager.createSolver(this);
        if (this.isolver == null) {
            this.stamp = -1L;
            this.listofclock = Collections.unmodifiableList(new ArrayList());
            this.listofassert = Collections.unmodifiableList(new ArrayList());
            this.listReferencedObject = Collections.unmodifiableList(new ArrayList());
            this.listofconstraint = Collections.unmodifiableList(new ArrayList());
            this.listofrelation = Collections.unmodifiableList(new ArrayList());
            this.listressource = Collections.unmodifiableList(new ArrayList());
            this.mappingURI = Collections.unmodifiableMap(new HashMap());
            return;
        }
        if (this.stamp == this.get_SourceIFile().getModificationStamp()) {
            return;
        }
        this.stamp = this.get_SourceIFile().getModificationStamp();
        this.listofclock = Collections.unmodifiableList(this.isolver.getClockList());
        this.listofassert = Collections.unmodifiableList(this.isolver.getAssertList());
        this.listofconstraint = Collections.unmodifiableList(this.isolver.getConstraint());
        this.listofrelation = Collections.unmodifiableList(this.getRelationDescription());
        this.listReferencedObject = new ArrayList<EObject>();
        for (ModelElementReference modelElementReference : this.listofclock) {
            AdapterRegistry.getAdapter((EObject)modelElementReference).fillWithReferencedElements((EObject)modelElementReference, this.listReferencedObject);
        }
        this.listReferencedObject = Collections.unmodifiableList(this.listReferencedObject);
        this.listressource = new ArrayList<Resource>();
        for (EObject eObject : this.listReferencedObject) {
            Resource rs = eObject.eResource();
            if (rs == null || this.listressource.contains(rs)) continue;
            this.listressource.add(rs);
        }
        this.listressource = Collections.unmodifiableList(this.listressource);
        this.mappingURI = new HashMap<URI, Resource>();
        for (Resource resource : this.listressource) {
            System.out.println("URI :" + resource.getURI());
            this.mappingURI.put(resource.getURI(), resource);
        }
        this.mappingURI = Collections.unmodifiableMap(this.mappingURI);
        for (IOutputOption iOutputOption : this.cachedtable.values()) {
            try {
                if (!iOutputOption.isActivable()) continue;
                iOutputOption.updateModel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IRelation getRelation() {
        return this.relation;
    }

    @Override
    public boolean haveSolver() {
        return this.getSolver() != null;
    }

    public ISolver getSolver() {
        if (this.get_SourceIFile() == null || this.get_SourceIFile().getModificationStamp() != this.stamp) {
            this.init();
        }
        return this.isolver;
    }

    @Override
    public List<EObject> getListReferencedObject() {
        return this.listReferencedObject;
    }

    @Override
    public final List<Resource> getRessourceOfReferencedObject() {
        return this.listressource;
    }

    @Override
    public final List<ModelElementReference> getListofClock() {
        return this.listofclock;
    }

    @Override
    public List<IDescription> getListofRelation() {
        return this.listofrelation;
    }

    @Override
    public final Map<URI, Resource> getMappingURIReferencedObject() {
        return this.mappingURI;
    }

    @Override
    public final List<ModelElementReference> getListofAssert() {
        return this.listofassert;
    }

    @Override
    public boolean haveClockWithReferenceTo(EClass element) {
        if (element != null) {
            for (EObject eo : this.listReferencedObject) {
                EClass eClass = eo.eClass();
                if (!element.isSuperTypeOf(eClass)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final ConsoleSimulation getConsole() {
        return this.console;
    }

    public final void setConsole(ConsoleSimulation console) {
        this.console = console;
    }

    private void setSaveconf(boolean saveconf) {
        this.saveconf = saveconf;
    }

    public void save() {
        try {
            if (this.saveconf && this._config != null) {
                this._config.doSave();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setDefault() {
        this.setPolicyId(SimulationPolicyManager.getDefault().getIndexofUID(ICCSLConstants.DEFAULT_POLICY));
        this.setSource(null);
        this.setPrioritySource(null);
        this.setStepNbr(0);
        this.setEstate(false);
        this.setTime(false);
    }

    public boolean solverUsedEstate() {
        if (this.get_SourceIFile() == null) {
            return true;
        }
        return PropertySimulation.EnableInactive.iscontaint(peSolverManager.getSupportPropertySimulation(this));
    }

    @Override
    public boolean getEstate() {
        if (!this.solverUsedEstate()) {
            return true;
        }
        try {
            return this.config.getAttribute("EState", false);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void setEstate(boolean estate) {
        try {
            if (this.solverUsedEstate() && this._config != null && this.getEstate() != estate) {
                this.incCCCSLIinfoEvolution();
                this._config.setAttribute("EState", estate);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean getTime() {
        try {
            return this.config.getAttribute("TimeDisplay", false);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void setTime(boolean nbr) {
        try {
            if (this._config != null) {
                this._config.setAttribute("TimeDisplay", nbr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setCopy(boolean cpy) {
        try {
            if (this._config != null && this.getCopy() != cpy) {
                this.incCCCSLIinfoEvolution();
                this._config.setAttribute("copysource", cpy);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getStepNbr() {
        try {
            return this.config.getAttribute("SimulationSteps", 0);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void setStepNbr(int nbr) {
        try {
            if (this._config != null && this.getStepNbr() != nbr) {
                this.incCCCSLIinfoEvolution();
                this._config.setAttribute("SimulationSteps", nbr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public OptionPolitic getOptionPolicy() {
        OptionPolitic op = new OptionPolitic(this.getEstate(), this.getPolicyId());
        if (this.console != null) {
            op.setSysout(this.console.getConsolestd());
        }
        return op;
    }

    @Override
    public int getPolicyId() {
        String s = ICCSLConstants.DEFAULT_POLICY;
        try {
            s = this.config.getAttribute("SimulationPolicy", ICCSLConstants.DEFAULT_POLICY);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return SimulationPolicyManager.getDefault().getIndexofUID(s);
    }

    public void setPolicyId(int nbr) {
        try {
            if (this._config != null) {
                this._config.setAttribute("SimulationPolicy", SimulationPolicyManager.getDefault().getUID(nbr));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getSource() {
        try {
            return this.config.getAttribute("Source", "");
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public IFile get_SourceIFile() {
        String name;
        block5: {
            if (this.sourceFile != null) {
                return this.sourceFile;
            }
            try {
                name = this.config.getAttribute("Source", null);
                if (name != null && name.trim().length() != 0) break block5;
                return null;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        Path p = new Path(name);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource r = iWorkspaceRoot.findMember((IPath)p);
        if (r instanceof IFile) {
            this.sourceFile = (IFile)r;
            return this.sourceFile;
        }
        return null;
    }

    @Override
    public String getPrioritySource() {
        try {
            return this.config.getAttribute("PrioritySource", "");
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @Override
    public IFile get_PrioritySourceIFile() {
        String name;
        block5: {
            if (this.prioritySourceFile != null) {
                return this.prioritySourceFile;
            }
            try {
                name = this.config.getAttribute("PrioritySource", null);
                if (name != null && name.trim().length() != 0) break block5;
                return null;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        Path p = new Path(name);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource r = iWorkspaceRoot.findMember((IPath)p);
        if (r instanceof IFile) {
            this.prioritySourceFile = (IFile)r;
            return this.prioritySourceFile;
        }
        return null;
    }

    @Override
    public String getExtension() {
        if (this.get_SourceIFile() == null) {
            return null;
        }
        return this.get_SourceIFile().getFileExtension();
    }

    @Override
    public String get_NameFile(boolean timed) {
        try {
            IFile ifilelocal = this.get_SourceIFile();
            if (ifilelocal == null) {
            }
            String namefile = ifilelocal.getName();
            String ext = ifilelocal.getFileExtension();
            namefile = namefile.substring(0, namefile.length() - ext.length() - 1);
            if (timed) {
                return String.valueOf(namefile) + this.datestr;
            }
            return namefile;
        }
        finally {
            return null;
        }
    }

    public void setPrioritySource(IFile file) {
        try {
            this.prioritySourceFile = file;
            if (this._config != null) {
                this.incCCCSLIinfoEvolution();
                this._config.setAttribute("PrioritySource", file == null ? "" : file.getFullPath().toString());
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public void setSource(IFile file) {
        try {
            this.sourceFile = file;
            if (this._config != null) {
                this.incCCCSLIinfoEvolution();
                this._config.setAttribute("Source", file == null ? "" : file.getFullPath().toString());
            }
        }
        catch (Throwable e) {
            System.err.println(e);
        }
    }

    public Configurator getConfigurator(Class<?> _class) {
        String key = outputManager.getkey(_class);
        if (key == null) {
            return null;
        }
        IOutputOption iot = this.getTable(key);
        if (iot != null) {
            return iot.getConfigurator();
        }
        return null;
    }

    @Override
    public IOutputOption getTable(String key) {
        IOutputOption ioo;
        block9: {
            if (key == null) {
                return null;
            }
            ioo = null;
            ioo = this.cachedtable.get(key);
            if (ioo != null) {
                ioo.setCs(this.console);
                ioo.setCcslhelper(this);
                if (ioo.isActivable()) {
                    ioo.updateModel();
                }
                return ioo;
            }
            ioo = outputManager.getOptionforKey(key);
            if (ioo != null) break block9;
            return null;
        }
        try {
            if (key.compareTo(ioo.getKey()) == 0) {
                ioo.setCs(this.console);
                Map table = this.config.getAttribute(key, new HashMap());
                HashMap<String, String> hmcp = new HashMap<String, String>();
                for (Map.Entry es : table.entrySet()) {
                    hmcp.put((String)es.getKey(), (String)es.getValue());
                }
                ioo.setTable(hmcp);
                ioo.setCcslhelper(this.getDelegateICCSLProxy());
                if (ioo.isActivable()) {
                    ioo.updateModel();
                    ioo.restore();
                }
                this.cachedtable.put(key, ioo);
                return ioo;
            }
            return null;
        }
        catch (Throwable throwable) {
            return ioo;
        }
    }

    @Override
    public void writeTable(IOutputOption ioo) {
        try {
            Map<String, String> hmin = ioo.getTable();
            HashMap<String, String> hmcp = new HashMap<String, String>();
            for (Map.Entry<String, String> es : hmin.entrySet()) {
                hmcp.put(es.getKey(), es.getValue());
            }
            this.setTable(ioo.getKey(), hmcp);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setTable(String key, Map<String, String> table) {
        try {
            if (this._config != null) {
                this._config.setAttribute(key, table);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Map<String, String> getOptionModel() {
        try {
            Map table = this.config.getAttribute("Model.option", new HashMap());
            return table;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setOptionModel(HashMap<String, String> hmcp) {
        this.setTable("Model.option", hmcp);
    }

    public void clearOptionModel() {
        this.setTable("Model.option", null);
    }

    @Override
    public final String getDatestr() {
        return this.datestr;
    }

    public ISimulatorControl launch() throws CoreException, InterruptedException, Exception {
        String mode = "simulation";
        if (this.config == null) {
            throw new NullPointerException("config is null");
        }
        if (Display.getCurrent() != null) {
            throw new SWTException(22, "Runnning on UI Thread");
        }
        Set modes = this.config.getModes();
        modes.add(mode);
        ILaunchDelegate[] delegates = this.config.getType().getDelegates(modes);
        ILaunchConfigurationDelegate delegate = null;
        delegate = delegates[0].getDelegate();
        Launch launch = null;
        launch = new Launch(this.config, mode, null);
        launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
        launch.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING", DebugPlugin.getDefault().getLaunchManager().getEncoding(this.config));
        if (delegate instanceof ICCSLModelLauncher) {
            CCSLSimulationConfigurationHelper.clearCache();
            ISimulatorControl iSimulatorControl = ((ICCSLModelLauncher)delegate).launch(this, mode, (ILaunch)launch);
            iSimulatorControl.join();
            return iSimulatorControl;
        }
        return null;
    }

    @Override
    public boolean getCopy() {
        try {
            return this.config.getAttribute("copysource", true);
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public final CCSLInfo getDelegateCCSLInfo() {
        return this.delegate;
    }

    public final ICCSLProxy getDelegateICCSLProxy() {
        return this;
    }

    private void incCCCSLIinfoEvolution() {
        ++this.ccslinfoevolution;
    }

    @Override
    public int getCCSLInfoEvolution() {
        return this.ccslinfoevolution;
    }
}

