/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model.values;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLValue;
import fr.inria.aoste.timesquare.launcher.debug.model.ICCSLDebugTarget;
import fr.inria.aoste.timesquare.launcher.debug.model.values.CCSLIntVariable;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.State;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public final class CCSLClocksValue
extends CCSLValue {
    private LogicalStep stValue;

    public CCSLClocksValue(ICCSLDebugTarget target, LogicalStep value) {
        super(target, "ccsl");
        this.stValue = value;
    }

    public void setValue(LogicalStep st) {
        this.stValue = st;
    }

    public String getValueString() throws DebugException {
        if (this.stValue == null) {
            return "null";
        }
        return " LogicalStep  " + this.stValue.getStepNumber();
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        try {
            ICCSLDebugTarget ccsldt = this.getDebugTarget();
            if (this.stValue == null) {
                return new IVariable[0];
            }
            int n = this.stValue.getEventOccurrences().size();
            IVariable[] vt = new IVariable[n];
            int i = 0;
            while (i < n) {
                EventOccurrence cs = (EventOccurrence)this.stValue.getEventOccurrences().get(i);
                vt[i] = new CCSLIntVariable(ccsldt, this.getClockName((State)cs));
                vt[i].setValue("" + cs.getCounter());
                ++i;
            }
            return vt;
        }
        catch (Throwable e) {
            return new IVariable[0];
        }
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return this.stValue != null;
    }
}

