/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.modelunfolding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class EqualitySolver<T> {
    private Vector<Set<T>> equalityClasses = new Vector();
    private HashMap<T, Integer> equalityClassMap = new HashMap();

    public void registerEquality(T c1, T c2) {
        if (c1 == c2) {
            return;
        }
        Integer class1 = this.equalityClassMap.get(c1);
        Integer class2 = this.equalityClassMap.get(c2);
        if (class1 != null) {
            if (class2 != null) {
                this.mergeClasses(class1, class2);
            } else {
                this.storeInClass(class1, c2);
            }
        } else if (class2 != null) {
            this.storeInClass(class2, c1);
        } else {
            int newClass = this.newClassIndex();
            this.storeInClass(newClass, c1);
            this.storeInClass(newClass, c2);
        }
    }

    public int getEqualityClassIndex(T cl) {
        Integer classIndex = this.equalityClassMap.get(cl);
        return classIndex != null ? classIndex : -1;
    }

    public Set<T> getEqualityClass(T cl) {
        Integer classIndex = this.equalityClassMap.get(cl);
        if (classIndex == null) {
            return null;
        }
        return this.equalityClasses.elementAt(classIndex);
    }

    public boolean areEqual(T c1, T c2) {
        Integer class1 = this.equalityClassMap.get(c1);
        Integer class2 = this.equalityClassMap.get(c2);
        return class1 != null && class2 != null && class1.equals(class2);
    }

    private int newClassIndex() {
        int i = 0;
        while (i < this.equalityClasses.size()) {
            if (this.equalityClasses.elementAt(i) == null) {
                this.equalityClasses.setElementAt(new HashSet(), i);
                return i;
            }
            ++i;
        }
        int newIndex = this.equalityClasses.size();
        this.equalityClasses.setSize(newIndex + 1);
        this.equalityClasses.setElementAt(new HashSet(), newIndex);
        return newIndex;
    }

    private boolean storeInClass(Integer classIndex, T c2) {
        this.equalityClassMap.put(c2, classIndex);
        return this.equalityClasses.elementAt(classIndex).add(c2);
    }

    private void mergeClasses(Integer class1, Integer class2) {
        int removedClass;
        int targetClass;
        if (class1.compareTo(class2) == 0) {
            return;
        }
        if (class1.compareTo(class2) < 0) {
            targetClass = class1;
            removedClass = class2;
        } else {
            targetClass = class2;
            removedClass = class1;
        }
        for (T clock : this.equalityClasses.elementAt(removedClass)) {
            this.storeInClass(targetClass, clock);
        }
        this.equalityClasses.elementAt(removedClass).clear();
        this.equalityClasses.set(removedClass, null);
    }
}

