/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesFactory;
import org.eclipse.sirius.properties.WizardModelOperation;
import org.eclipse.sirius.properties.core.api.IDescriptionLinkResolver;
import org.eclipse.sirius.properties.core.api.IDescriptionPreprocessor;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.SiriusPropertiesCorePlugin;

public class WizardModelOperationPreprocessor {
    private WizardModelOperation wizardModelOperation;
    private IInterpreter interpreter;
    private IVariableManager variableManager;
    private OverridesProvider overridesProvider;

    public WizardModelOperationPreprocessor(WizardModelOperation wizardModelOperation, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        this.wizardModelOperation = wizardModelOperation;
        this.interpreter = interpreter;
        this.variableManager = variableManager;
        this.overridesProvider = overridesProvider;
    }

    public Optional<WizardModelOperation> convert() {
        WizardModelOperation convertedWizardModelOperation = PropertiesFactory.eINSTANCE.createWizardModelOperation();
        TransformationCache cache = new TransformationCache();
        cache.put(this.wizardModelOperation, convertedWizardModelOperation);
        this.convertEAttributes(convertedWizardModelOperation);
        this.convertPage(convertedWizardModelOperation, cache);
        this.convertGroups(convertedWizardModelOperation, cache);
        List<IDescriptionLinkResolver> linkResolvers = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessorLinkResolvers();
        linkResolvers.forEach(linkResolver -> linkResolver.resolve((EObject)convertedWizardModelOperation, cache));
        return Optional.of(convertedWizardModelOperation);
    }

    private void convertEAttributes(WizardModelOperation convertedWizardModelOperation) {
        convertedWizardModelOperation.setTitleExpression(this.wizardModelOperation.getTitleExpression());
        convertedWizardModelOperation.setWindowTitleExpression(this.wizardModelOperation.getWindowTitleExpression());
        convertedWizardModelOperation.setDescriptionExpression(this.wizardModelOperation.getDescriptionExpression());
        convertedWizardModelOperation.setIsPageCompleteExpression(this.wizardModelOperation.getIsPageCompleteExpression());
        Optional.ofNullable(this.wizardModelOperation.getInitialOperation()).map(EcoreUtil::copy).ifPresent(arg_0 -> ((WizardModelOperation)convertedWizardModelOperation).setInitialOperation(arg_0));
    }

    private void convertPage(WizardModelOperation convertedWizardModelOperation, TransformationCache cache) {
        this.wizardModelOperation.getPages().forEach(pageDescription -> {
            Optional<IDescriptionPreprocessor> optionalPreprocessor = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessor((EObject)pageDescription);
            optionalPreprocessor.ifPresent(preprocessor -> {
                EObject convertedEObject = preprocessor.convert((EObject)pageDescription, cache, this.interpreter, this.variableManager, this.overridesProvider);
                if (convertedEObject instanceof PageDescription) {
                    convertedWizardModelOperation.getPages().add((Object)((PageDescription)convertedEObject));
                }
            });
        });
    }

    private void convertGroups(WizardModelOperation convertedWizardModelOperation, TransformationCache cache) {
        this.wizardModelOperation.getGroups().forEach(groupDescription -> {
            Optional<IDescriptionPreprocessor> optionalPreprocessor = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessor((EObject)groupDescription);
            optionalPreprocessor.ifPresent(preprocessor -> {
                EObject convertedEObject = preprocessor.convert((EObject)groupDescription, cache, this.interpreter, this.variableManager, this.overridesProvider);
                if (convertedEObject instanceof GroupDescription) {
                    convertedWizardModelOperation.getGroups().add((Object)((GroupDescription)convertedEObject));
                }
            });
        });
    }
}

