/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.extension;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExternalRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.ExpressionsExtensionManager;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.ISolverExpressionFactory;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.ISolverRelationFactory;
import fr.inria.aoste.timesquare.ccslkernel.solver.extension.RelationsExtensionManager;
import java.util.ArrayList;
import java.util.List;

public final class FactoryManager {
    private final List<ISolverExpressionFactory> expressionFactories = new ArrayList<ISolverExpressionFactory>();
    private final List<ISolverRelationFactory> relationFactories = new ArrayList<ISolverRelationFactory>();

    private FactoryManager() {
        this.expressionFactories.addAll(ExpressionsExtensionManager.getInstance().getFactories());
        this.relationFactories.addAll(RelationsExtensionManager.getInstance().getFactories());
    }

    public static FactoryManager getInstance() {
        return FactoryManagerHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRelationFactory(ISolverRelationFactory factory) {
        List<ISolverRelationFactory> list = this.relationFactories;
        synchronized (list) {
            this.relationFactories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExpressionFactory(ISolverExpressionFactory factory) {
        List<ISolverExpressionFactory> list = this.expressionFactories;
        synchronized (list) {
            this.expressionFactories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISolverExpressionFactory getExpressionFactory(ExpressionDeclaration declaration, ExternalExpressionDefinition definition) {
        List<ISolverExpressionFactory> list = this.expressionFactories;
        synchronized (list) {
            for (ISolverExpressionFactory factory : this.expressionFactories) {
                if (!factory.canHandle(declaration, definition)) continue;
                return factory;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISolverRelationFactory getRelationFactory(RelationDeclaration declaration, ExternalRelationDefinition definition) {
        List<ISolverRelationFactory> list = this.relationFactories;
        synchronized (list) {
            for (ISolverRelationFactory factory : this.relationFactories) {
                if (!factory.canHandle(declaration, definition)) continue;
                return factory;
            }
        }
        return null;
    }

    /* synthetic */ FactoryManager(FactoryManager factoryManager) {
        this();
    }

    private static class FactoryManagerHolder {
        private static final FactoryManager instance = new FactoryManager(null);

        private FactoryManagerHolder() {
        }
    }
}

