/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;

public class MapObjectBinding<A, B>
extends ObjectBinding<B> {
    private ObservableValue<A> source;
    private Function<A, ObservableValue<B>> map;
    private Observable next = null;

    public MapObjectBinding(ObservableValue<A> source, Function<A, ObservableValue<B>> map) {
        this.source = source;
        this.map = map;
        this.bind(new Observable[]{this.source});
    }

    protected B computeValue() {
        this.clearNextReference();
        Object sourceVal = this.source.getValue();
        if (sourceVal != null) {
            ObservableValue<B> apply;
            this.next = apply = this.map.apply(sourceVal);
            this.bind(new Observable[]{this.next});
            return (B)apply.getValue();
        }
        return null;
    }

    private void clearNextReference() {
        if (this.next != null) {
            this.unbind(new Observable[]{this.next});
            this.next = null;
        }
    }

    protected void onInvalidating() {
        this.clearNextReference();
    }

    public void dispose() {
        this.clearNextReference();
        this.unbind(new Observable[]{this.source});
        super.dispose();
    }
}

